/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.commoninterface.tags;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.objects.cataloguing.structures.R01MLabel;
import com.ejie.r01m.objects.cataloguing.structures.R01MStructureItem;
import com.ejie.r01m.objects.cataloguing.structures.R01MTerm;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public class R01MTreeLabelsTag
extends TagSupport {
    private static final long serialVersionUID = -4067642655544120393L;
    private String structureGUID = null;
    private String language = R01MConstants.DEFAULT_LANG;
    private String numberCombo = "1";
    private String relationId = null;
    private String labelGUID = "";
    private String comboIdentify = null;
    private String comboTitles = "";
    private String comboStyle = "";
    private String comboTitleStyle = "";
    private String presentation = "true";
    private String labelGuidJS = "";

    public void setStructureGUID(String theStructureGUID) {
        this.structureGUID = theStructureGUID;
    }

    public void setLanguage(String theLanguage) {
        this.language = theLanguage;
    }

    public String getRelationId() {
        return this.relationId;
    }

    public void setRelationId(String theRelationId) {
        this.relationId = theRelationId;
    }

    public void setNumberCombo(String theNumberCombo) {
        this.numberCombo = theNumberCombo;
    }

    public void setLabelGUID(String theLabelGUID) {
        this.labelGUID = theLabelGUID;
    }

    public void setComboIdentify(String theComboIdentify) {
        this.comboIdentify = theComboIdentify;
    }

    public void setComboTitles(String theComboTitles) {
        this.comboTitles = theComboTitles;
    }

    public void setComboStyle(String theComboStyle) {
        this.comboStyle = theComboStyle;
    }

    public void setComboTitleStyle(String theComboTitleStyle) {
        this.comboTitleStyle = theComboTitleStyle;
    }

    public void setLabelGuidJS(String theLabelGuidJS) {
        this.labelGuidJS = theLabelGuidJS;
    }

    public void setPresentation(String thePresentation) {
        this.presentation = thePresentation;
    }

    public String getComboIdentify() {
        return this.comboIdentify;
    }

    public String getComboTitles() {
        return this.comboTitles;
    }

    public String getComboStyle() {
        return this.comboStyle;
    }

    public String getComboTitleStyle() {
        return this.comboTitleStyle;
    }

    public String getPresentation() {
        return this.presentation;
    }

    public String getLabelGuidJS() {
        return this.labelGuidJS;
    }

    public String getStructureGUID() {
        return this.structureGUID;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getNumberCombo() {
        return this.numberCombo;
    }

    public String getLabelGUID() {
        return this.labelGUID;
    }

    public int doStartTag() throws JspException {
        int level = 1;
        try {
            Integer numberComboInt = new Integer(this.numberCombo);
            int numberComboI = numberComboInt;
            this.labelGUID = this.labelGUID == "" ? "root_" + this.comboIdentify : this.labelGUID + "_" + this.comboIdentify;
            String relation = "";
            relation = StringUtils.isEmptyString((String)this.relationId) ? "0" : this.relationId;
            ArrayList childrenCombo = this.getChildrenNames(relation);
            StringBuffer combo = childrenCombo != null ? new StringBuffer(300) : new StringBuffer(173);
            combo.append("<div id=\"rb_");
            combo.append(this.labelGUID);
            combo.append("\" ");
            combo.append(" class=\"firstCombo\">\n<ul class='comboGroup'>");
            for (int i = 0; childrenCombo != null && i < childrenCombo.size(); ++i) {
                String child = (String)childrenCombo.get(i);
                String[] childStr = child.split(";");
                combo.append("<li><input type=\"radio\" name=\"labelRadio_");
                combo.append(this.comboIdentify);
                combo.append("\" value=\"");
                combo.append(this.structureGUID);
                combo.append(';');
                combo.append(childStr[1]);
                combo.append("\" class='radioButton'/>&nbsp;");
                combo.append(childStr[0]);
                if (numberComboI > 1) {
                    combo.append(this.drawCombo(childStr[1] + "_" + this.comboIdentify, ++level, this.comboIdentify, childStr[2]));
                }
                combo.append("</li>");
            }
            combo.append("</ul></div>\n");
            this.pageContext.getOut().println((Object)combo);
        }
        catch (IOException e) {
            R01FLog.to((String)"r01m.servlet").severe("*** IOException en el taglib (R01EComboTag.java): " + e.getMessage());
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        this.labelGUID = "";
        this.numberCombo = null;
        this.labelGuidJS = "";
        return 6;
    }

    private ArrayList getChildrenNames(String labelGUIDAux) {
        String[] label = labelGUIDAux.split("_");
        ArrayList vNodes = new ArrayList();
        ArrayList<String> vNodesAux = new ArrayList<String>();
        vNodesAux.add(0, this.structureGUID);
        if (label[0] == null) {
            vNodesAux.add(1, "0");
        } else {
            vNodesAux.add(1, label[0]);
        }
        vNodes.add(vNodesAux);
        ArrayList<String> childrenArray = null;
        try {
            ArrayList children = (ArrayList)R01MClientFactory.getCatalogAPI(R01MAuthManager.createMasterSystemUserContext()).loadChildrenOrdered(vNodes);
            if (children != null && !children.isEmpty()) {
                childrenArray = new ArrayList<String>();
                for (int j = 0; j < children.size(); ++j) {
                    R01MStructureItem structureChild = (R01MStructureItem)children.get(j);
                    R01MLabel labelChild = R01MClientFactory.getCatalogAPI(R01MAuthManager.createMasterSystemUserContext()).loadLabel(structureChild.getRootLabelOid());
                    R01MTerm termLabel = labelChild.getStandardizedTerm(this.language);
                    if (termLabel == null) continue;
                    String labelName = termLabel.getValue();
                    childrenArray.add(labelName + ";" + labelChild.getOid() + ";" + structureChild.getRelationId());
                }
            }
        }
        catch (Exception e) {
            R01FLog.to((String)"r01m.servlet").severe("*** Exception en el taglib (R01EComboTag.java): " + e.getMessage());
        }
        return childrenArray;
    }

    private StringBuffer drawCombo(String labelGUIDAux, int level, String optionName, String relation) {
        this.labelGUID = !StringUtils.isEmptyString((String)labelGUIDAux) ? labelGUIDAux : null;
        StringBuffer combo = new StringBuffer("");
        Integer numberComboInt = new Integer(this.numberCombo);
        int numberComboI = numberComboInt;
        ArrayList childrenCombo = this.getChildrenNames(relation);
        try {
            if (childrenCombo != null && !childrenCombo.isEmpty()) {
                combo.append("<ul>");
                for (int i = 0; childrenCombo != null && i < childrenCombo.size(); ++i) {
                    String child = (String)childrenCombo.get(i);
                    String[] childStr = child.split(";");
                    combo.append("<li><input type=\"radio\" name=\"labelRadio_");
                    combo.append(optionName);
                    combo.append("\" value=\"");
                    combo.append(this.structureGUID);
                    combo.append(';');
                    combo.append(childStr[1]);
                    combo.append("\" class='radioButton'/>&nbsp;");
                    combo.append(childStr[0]);
                    if (numberComboI > level) {
                        combo.append(this.drawCombo(childStr[1] + "_" + this.comboIdentify, level + 1, optionName, childStr[2]));
                    }
                    combo.append("</li>");
                }
                combo.append("</ul>");
            }
        }
        catch (Exception e) {
            R01FLog.to((String)"r01m.servlet").severe("*** Exception en el taglib (R01EComboTag.java): " + e.getMessage());
        }
        return combo;
    }
}

