/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.commoninterface.tags;

import com.ejie.r01f.file.ResourcesLoader;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.exceptions.R01MCatalogElementNotFoundException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.cataloguing.structures.R01MLabel;
import com.ejie.r01m.objects.cataloguing.structures.R01MStructureDefinition;
import com.ejie.r01m.objects.cataloguing.structures.R01MTerm;
import com.ejie.r01m.services.R01MCatalogManagerAPI;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public class R01MSelectionLabels
extends TagSupport {
    private static final long serialVersionUID = -754363906721281849L;
    private String divId = null;
    private String buttonValue = "Seleccionar";
    private String language = R01MConstants.DEFAULT_LANG;
    private String returnSelection = "functionSelection";
    private String nodeId = "";
    private String labelName = "";
    private String role = "";
    private String styleButton = "";
    private String styleText = "";
    private String borderColor = "#A0A0A0";
    private String deleteImage = "/comun/images/r01ldelete.gif";
    private String structureCataloguingConfig = "";
    private String structureGroupCataloguingConfig = "";
    private String allowedBagsOid = "";
    private String workAreaBagsOid = "";
    private String buttonsEnabled = "true";
    private String unique = "false";
    private String selectParentLabels = "false";
    private String showAllBags = "false";
    private String withStructureCheck = "false";
    private static String puntoImage = "/comun/images/icn_bullet.gif";
    private Properties propertiesSearch = null;

    public String getButtonsEnabled() {
        return this.buttonsEnabled;
    }

    public void setButtonsEnabled(String theButtonsEnabled) {
        this.buttonsEnabled = theButtonsEnabled;
    }

    public String getAllowedBagsOid() {
        return this.allowedBagsOid;
    }

    public void setAllowedBagsOid(String theAllowedBagsOid) {
        this.allowedBagsOid = theAllowedBagsOid;
    }

    public String getWorkAreaBagsOid() {
        return this.workAreaBagsOid;
    }

    public void setWorkAreaBagsOid(String theworkAreaBagsOid) {
        this.workAreaBagsOid = theworkAreaBagsOid;
    }

    public String getStructureCataloguingConfig() {
        return this.structureCataloguingConfig;
    }

    public void setStructureCataloguingConfig(String theStructureCataloguingConfig) {
        this.structureCataloguingConfig = theStructureCataloguingConfig;
    }

    public String getStructureGroupCataloguingConfig() {
        return this.structureGroupCataloguingConfig;
    }

    public void setStructureGroupCataloguingConfig(String theStructureGroupCataloguingConfig) {
        this.structureGroupCataloguingConfig = theStructureGroupCataloguingConfig;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String theRole) {
        this.role = theRole;
    }

    public String getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(String theBorderColor) {
        this.borderColor = theBorderColor;
    }

    public String getStyleButton() {
        return this.styleButton;
    }

    public void setStyleButton(String theStyleButton) {
        this.styleButton = theStyleButton;
    }

    public String getStyleText() {
        return this.styleText;
    }

    public void setStyleText(String theStyleText) {
        this.styleText = theStyleText;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String theNodeId) {
        this.nodeId = theNodeId;
    }

    public String getLabelName() {
        return this.labelName;
    }

    public void setLabelName(String theLabelName) {
        this.labelName = theLabelName;
    }

    public String getDivId() {
        return this.divId;
    }

    public void setDivId(String value) {
        this.divId = value;
    }

    public String getReturnSelection() {
        return this.returnSelection;
    }

    public void setReturnSelection(String value) {
        this.returnSelection = value;
    }

    public String getButtonValue() {
        return this.buttonValue;
    }

    public void setButtonValue(String value) {
        this.buttonValue = value;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String value) {
        this.language = value;
    }

    public String getDeleteImage() {
        return this.deleteImage;
    }

    public void setDeleteImage(String theDeleteImage) {
        this.deleteImage = theDeleteImage;
    }

    public String getUnique() {
        return this.unique;
    }

    public void setUnique(String theUnique) {
        this.unique = theUnique;
    }

    public String getSelectParentLabels() {
        return this.selectParentLabels;
    }

    public void setSelectParentLabels(String theSelectParentLabels) {
        this.selectParentLabels = theSelectParentLabels;
    }

    public String getShowAllBags() {
        return this.showAllBags;
    }

    public void setShowAllBags(String theShowAllBags) {
        this.showAllBags = theShowAllBags;
    }

    public Properties getPropertiesSearch() {
        return this.propertiesSearch;
    }

    public void setPropertiesSearch(Properties thePropertiesSearch) {
        this.propertiesSearch = thePropertiesSearch;
    }

    public int doStartTag() throws JspException {
        StringBuffer catalogation = new StringBuffer(200);
        String urlpopup = XMLProperties.getProperty((String)R01MConstants.USERINTERFACE_APPCODE, (String)"webApps/url/urlCatalog");
        try {
            catalogation.append("<input type='button' id='button");
            catalogation.append(this.divId);
            catalogation.append("' value='");
            catalogation.append(this.buttonValue);
            catalogation.append("' ");
            if (this.styleButton != null && this.styleButton.length() > 0) {
                catalogation.append("class='");
                catalogation.append(this.styleButton);
                catalogation.append("' ");
            }
            if (this.buttonsEnabled != null && !this.buttonsEnabled.equals("true")) {
                catalogation.append("disabled ");
                catalogation.append("style=\"cursor:default\" ");
            }
            StringBuffer nodeIdRole = new StringBuffer();
            if (!StringUtils.isEmptyString((String)this.nodeId)) {
                String[] arrNodeId = this.nodeId.split("\\$");
                String[] arrRole = this.role.split("\\$");
                for (int i = 0; i < arrNodeId.length; ++i) {
                    if (StringUtils.isEmptyString((String)arrNodeId[i])) continue;
                    nodeIdRole.append(arrNodeId[i]);
                    nodeIdRole.append(';');
                    nodeIdRole.append(arrRole[i]);
                    if (i >= arrNodeId.length - 1) continue;
                    nodeIdRole.append('$');
                }
            }
            catalogation.append("onClick=\"javascript:selectAxes('");
            catalogation.append(this.language);
            catalogation.append("','");
            catalogation.append(urlpopup);
            catalogation.append("',");
            catalogation.append(this.returnSelection);
            catalogation.append(",'");
            catalogation.append(this.divId);
            catalogation.append("','");
            catalogation.append(nodeIdRole);
            catalogation.append("','");
            catalogation.append(this.structureCataloguingConfig);
            catalogation.append("','");
            catalogation.append(this.structureGroupCataloguingConfig);
            catalogation.append("','");
            catalogation.append(this.allowedBagsOid);
            catalogation.append("','");
            catalogation.append(this.workAreaBagsOid);
            catalogation.append("','");
            catalogation.append(this.unique);
            catalogation.append("','");
            catalogation.append(this.selectParentLabels);
            catalogation.append("','");
            catalogation.append(this.withStructureCheck);
            catalogation.append("','");
            catalogation.append(this.showAllBags);
            catalogation.append("');\">\n<div id=\"");
            catalogation.append(this.divId);
            catalogation.append("\">\n<ul>\n");
            if (!StringUtils.isEmptyString((String)this.nodeId)) {
                catalogation.append(this._composeSelectedLabelsHTML(nodeIdRole));
            } else {
                catalogation.append("<ul>\n");
            }
            catalogation.append("</ul>\n</div>\n");
            this.pageContext.getOut().println((Object)catalogation);
        }
        catch (IOException e) {
            R01FLog.to((String)"r01m.selectiontool").severe("*** IOException en el taglib (R01LSelectionLabels.java): " + e.getMessage());
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        return 6;
    }

    private StringBuffer _composeSelectedLabelsHTML(StringBuffer nodeIdRole) {
        R01MCatalogManagerAPI catalogAPI;
        StringBuffer axisSelected = new StringBuffer("");
        if (this.propertiesSearch == null) {
            this.setPropertiesSearch();
        }
        String[] nodeIdST = nodeIdRole.toString().split("\\u0024");
        ArrayList catsList = new ArrayList(nodeIdST.length);
        try {
            catalogAPI = R01MClientFactory.getCatalogAPI(R01MAuthManager.createMasterSystemUserContext());
        }
        catch (R01MSecurityException ex1) {
            R01FLog.to((String)"r01m.selectiontool").severe("Error de seguridad al obtener el contexto de usuario" + ex1.toString());
            return null;
        }
        for (int i = 0; i < nodeIdST.length; ++i) {
            String currCat = nodeIdST[i];
            String[] stringArray = currCat.split(";");
            ArrayList<String> currCatEls = new ArrayList<String>(stringArray.length);
            for (int j = 0; j < stringArray.length; ++j) {
                currCatEls.add(stringArray[j]);
            }
            catsList.add(currCatEls);
        }
        this._sortCats(catsList);
        ArrayList structureOidsList = new ArrayList(catsList.size());
        for (List list : catsList) {
            try {
                if (list.size() > 2 && !"0".equals(list.get(1))) {
                    Map<String, R01MTerm> labelMap;
                    String termValue = this.propertiesSearch.getProperty("catalogation.label.deteted") + "(" + (String)list.get(1) + ")";
                    R01MLabel label = catalogAPI.loadLabel((String)list.get(1));
                    if (label != null && (labelMap = label.getStandardizedTerms()).containsKey(this.language)) {
                        R01MTerm mTerm = labelMap.get(this.language);
                        termValue = mTerm.getValue();
                    }
                    structureOidsList.add(list.get(0));
                    String structureName = this.propertiesSearch.getProperty("catalogation.structure.deteted") + "(" + (String)list.get(0) + ")";
                    try {
                        R01MStructureDefinition structureDefinition = catalogAPI.loadStructureDefinition((String)list.get(0));
                        structureName = structureDefinition.getName(this.language);
                    }
                    catch (R01MCatalogElementNotFoundException exNotFound) {
                        R01FLog.to((String)"r01m.selectiontool").severe("No se encuentra la estructura de oid " + (String)list.get(0) + ". " + exNotFound.toString());
                    }
                    axisSelected.append("<b>[");
                    axisSelected.append(structureName);
                    axisSelected.append("]:</b>&nbsp;");
                    axisSelected.append(termValue);
                    axisSelected.append('$');
                    continue;
                }
                structureOidsList.add(list.get(0));
                String structureName = this.propertiesSearch.getProperty("catalogation.structure.deteted") + "(" + (String)list.get(0) + ")";
                try {
                    R01MStructureDefinition structureDefinition = catalogAPI.loadStructureDefinition((String)list.get(0));
                    structureName = structureDefinition.getName(this.language);
                }
                catch (R01MCatalogElementNotFoundException exNotFound) {
                    R01FLog.to((String)"r01m.selectiontool").severe("No se encuentra la estructura de oid " + (String)list.get(0) + ". " + exNotFound.toString());
                }
                axisSelected.append("<b>[");
                axisSelected.append(structureName);
                axisSelected.append("]:</b>&nbsp;$");
            }
            catch (Exception ex) {
                R01FLog.to((String)"r01m.selectiontool").severe("Error al obtener el value del termino" + ex.toString());
            }
        }
        List manadatoryStructs = this._composeMandatoryStructuresList();
        String[] stringArray = axisSelected.toString().split("\\u0024");
        StringBuffer catalogation = new StringBuffer("");
        for (int i = 0; i < stringArray.length; ++i) {
            catalogation.append("<div ");
            if (this.styleText != null && this.styleText.length() > 0) {
                catalogation.append('>');
                if ("true".equals(this.buttonsEnabled)) {
                    boolean canBeDeleted = true;
                    for (int j = 0; j < manadatoryStructs.size(); ++j) {
                        if (!manadatoryStructs.get(j).equals(structureOidsList.get(i))) continue;
                        canBeDeleted = false;
                        break;
                    }
                    if (canBeDeleted) {
                        String catStr = ((List)catsList.get(i)).size() > 2 ? ((List)catsList.get(i)).get(0) + ";" + ((List)catsList.get(i)).get(1) : (String)((List)catsList.get(i)).get(0);
                        catalogation.append("<img style='cursor:pointer' src='");
                        catalogation.append(this.deleteImage);
                        catalogation.append("' title='");
                        catalogation.append(this.propertiesSearch.getProperty("catalogation.deleteLabel"));
                        catalogation.append("' onclick=\"javascript:deleteLabel('");
                        catalogation.append(catStr);
                        catalogation.append("','");
                        catalogation.append(this.nodeId);
                        catalogation.append("','");
                        catalogation.append(this.labelName);
                        catalogation.append("','");
                        catalogation.append(this.role);
                        catalogation.append("',");
                        catalogation.append(this.returnSelection);
                        catalogation.append(");\"/>");
                    } else {
                        catalogation.append("<img style='cursor:default' src='");
                        catalogation.append(puntoImage);
                        catalogation.append("'/>");
                    }
                }
                catalogation.append("<span class='");
                catalogation.append(this.styleText);
                catalogation.append("'>");
                catalogation.append(stringArray[i]);
                catalogation.append("</span>\n");
            } else {
                catalogation.append("><img style='cursor:pointer' src='");
                catalogation.append(this.deleteImage);
                catalogation.append("' title='");
                catalogation.append(this.propertiesSearch.getProperty("catalogation.deleteLabel"));
                catalogation.append("' onclick=\"javascript:deleteLabel('");
                catalogation.append((String)catsList.get(i));
                catalogation.append("','");
                catalogation.append(this.nodeId);
                catalogation.append("','");
                catalogation.append(this.labelName);
                catalogation.append("','");
                catalogation.append(this.role);
                catalogation.append("',");
                catalogation.append(this.returnSelection);
                catalogation.append(");\"/>");
                catalogation.append(stringArray[i]);
            }
            catalogation.append("</div>\n");
        }
        return catalogation;
    }

    private void setPropertiesSearch() {
        try {
            this.propertiesSearch = new Properties();
            String languageResource = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)("commonInterfaceTagResources/" + this.language));
            R01FLog.to((String)"r01m.selectiontool").info("Leyendo el fichero de idiomas: " + languageResource);
            this.propertiesSearch.load(ResourcesLoader.getResourceFileAsStream((String)languageResource));
        }
        catch (IOException e) {
            R01FLog.to((String)"r01m.selectiontool").severe("Error cargando ficheros de idiomas: " + e.toString());
        }
    }

    public String getWithStructureCheck() {
        return this.withStructureCheck;
    }

    public void setWithStructureCheck(String theWithStructureCheck) {
        this.withStructureCheck = theWithStructureCheck;
    }

    private List _composeMandatoryStructuresList() {
        ArrayList manadatoryStructs = new ArrayList();
        ArrayList<String> mandatoryList = new ArrayList<String>();
        String[] structureCataloguingConfigST = this.structureCataloguingConfig.split("\\u0024");
        for (int i = 0; i < structureCataloguingConfigST.length; ++i) {
            mandatoryList.clear();
            String structureRole = structureCataloguingConfigST[i];
            String[] structureRoleST = structureRole.split(";");
            for (int j = 0; j < structureRoleST.length; ++j) {
                String mandatory = structureRoleST[j];
                mandatoryList.add(mandatory);
            }
            manadatoryStructs.add(mandatoryList.get(0));
        }
        return manadatoryStructs;
    }

    private void _sortCats(List listToSort) {
        Collections.sort(listToSort, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                if (obj1 != null && obj2 != null) {
                    List l1 = (List)obj1;
                    List l2 = (List)obj2;
                    if (l1.size() == 3 && l2.size() == 3 && l1.get(0) != null && l2.get(0) != null) {
                        int structComp = ((String)l1.get(0)).compareTo((String)l2.get(0));
                        if (structComp == 0) {
                            if (l1.get(2) != null && l2.get(2) != null) {
                                return ((String)l1.get(2)).compareTo((String)l2.get(2));
                            }
                            if (l1.get(2) != null) {
                                return 1;
                            }
                            if (l2.get(2) != null) {
                                return -1;
                            }
                            return 0;
                        }
                        return structComp;
                    }
                    if (l1.get(0) != null) {
                        return 1;
                    }
                    if (l2.get(0) != null) {
                        return -1;
                    }
                    return 0;
                }
                if (obj1 != null) {
                    return 1;
                }
                if (obj2 != null) {
                    return -1;
                }
                return 0;
            }
        });
    }
}

