/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.commoninterface.tags;

import com.ejie.r01f.file.ResourcesLoader;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.commoninterface.tags.util.R01MGeographicCatalogLoad;
import com.ejie.r01m.objects.cataloguing.geo.R01MGeocode;
import com.ejie.r01m.utils.R01MConstants;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public class R01MGeographicCatalog
extends TagSupport {
    private static final long serialVersionUID = 7693274705003325592L;
    private String buttonValue = "Catalogaci\u00f3n";
    private String divId = null;
    private String language = R01MConstants.DEFAULT_LANG;
    private String styleButton = "";
    private String styleText = "";
    private String deleteImage = "/comun/images/r01ldelete.gif";
    private String borderColor = "#A0A0A0";
    private String returnSelection = "functionSelection";
    private String geoCatalogation = "";
    private String provinceId = "";
    private String municipalityId = "";
    private String buttonsEnabled = "true";
    private boolean bButtonsEnabled = true;
    private Properties propertiesSearch = null;

    public String getMunicipalityId() {
        return this.municipalityId;
    }

    public void setMunicipalityId(String theMunicipalityId) {
        this.municipalityId = theMunicipalityId;
    }

    public String getProvinceId() {
        return this.provinceId;
    }

    public void setProvinceId(String theProvinceId) {
        this.provinceId = theProvinceId;
    }

    public String getButtonValue() {
        return this.buttonValue;
    }

    public void setButtonValue(String theButtonValue) {
        this.buttonValue = theButtonValue;
    }

    public String getDeleteImage() {
        return this.deleteImage;
    }

    public void setDeleteImage(String theDeleteImage) {
        this.deleteImage = theDeleteImage;
    }

    public String getDivId() {
        return this.divId;
    }

    public void setDivId(String theDivId) {
        this.divId = theDivId;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String theLanguage) {
        this.language = theLanguage;
    }

    public String getStyleButton() {
        return this.styleButton;
    }

    public void setStyleButton(String theStyleButton) {
        this.styleButton = theStyleButton;
    }

    public String getStyleText() {
        return this.styleText;
    }

    public void setStyleText(String theStyleText) {
        this.styleText = theStyleText;
    }

    public String getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(String theBorderColor) {
        this.borderColor = theBorderColor;
    }

    public String getGeoCatalogation() {
        return this.geoCatalogation;
    }

    public void setGeoCatalogation(String theGeoCatalogation) {
        this.geoCatalogation = theGeoCatalogation;
    }

    public String getReturnSelection() {
        return this.returnSelection;
    }

    public void setReturnSelection(String theReturnSelection) {
        this.returnSelection = theReturnSelection;
    }

    public String getButtonsEnabled() {
        return this.buttonsEnabled;
    }

    public void setButtonsEnabled(String theButtonsEnabled) {
        this.buttonsEnabled = theButtonsEnabled;
        this.bButtonsEnabled = Boolean.getBoolean(theButtonsEnabled);
    }

    public boolean isBButtonsEnabled() {
        return this.bButtonsEnabled;
    }

    public void setBButtonsEnabled(boolean theButtonsEnabled) {
        this.bButtonsEnabled = theButtonsEnabled;
    }

    public Properties getPropertiesSearch() {
        return this.propertiesSearch;
    }

    public void setPropertiesSearch(Properties thePropertiesSearch) {
        this.propertiesSearch = thePropertiesSearch;
    }

    private StringBuffer _getProvinceMunipalityName() {
        R01MGeocode geoCatalog;
        int i;
        R01MGeographicCatalogLoad geographicCatalogLoad = new R01MGeographicCatalogLoad();
        ArrayList provMuniListAux = new ArrayList();
        ArrayList<String> provListAux = new ArrayList<String>();
        StringTokenizer provinceST = new StringTokenizer(this.provinceId, "$");
        StringTokenizer municipioST = new StringTokenizer(this.municipalityId, "$");
        while (provinceST.hasMoreTokens()) {
            String provinceStr = provinceST.nextToken();
            String municipioStr = municipioST.nextToken();
            if ("-1".equals(municipioStr)) {
                provListAux.add(provinceStr);
                continue;
            }
            ArrayList<String> provMunArray = new ArrayList<String>();
            provMunArray.add(provinceStr);
            provMunArray.add(municipioStr);
            provMuniListAux.add(provMunArray);
        }
        List geoCatalogProvList = geographicCatalogLoad.getGeograohicCatalogProvince(provListAux, this.language);
        List geoCatalogProvMuniList = geographicCatalogLoad.getGeograohicCatalogProvinceMunicipal(provMuniListAux, this.language);
        StringBuffer provinceName = new StringBuffer("");
        StringBuffer municipalityName = new StringBuffer("");
        for (i = 0; geoCatalogProvMuniList != null && i < geoCatalogProvMuniList.size(); ++i) {
            geoCatalog = (R01MGeocode)geoCatalogProvMuniList.get(i);
            provinceName.append(geoCatalog.getTerritory().getName());
            provinceName.append('$');
            municipalityName.append(geoCatalog.getMunicipality().getName());
            municipalityName.append('$');
        }
        for (i = 0; geoCatalogProvList != null && i < geoCatalogProvList.size(); ++i) {
            geoCatalog = (R01MGeocode)geoCatalogProvMuniList.get(i);
            provinceName.append(geoCatalog.getTerritory().getName());
            provinceName.append('$');
            municipalityName.append('$');
        }
        return this._generateHTML(geoCatalogProvMuniList, geoCatalogProvList, provinceName, municipalityName);
    }

    private StringBuffer _generateHTML(List geoCatalogProvMuniList, List geoCatalogProvList, StringBuffer provinceNameList, StringBuffer municipalityNameList) {
        String municipalityIdStr;
        String provinceIdStr;
        R01MGeocode geoCatalog;
        int i;
        if (this.propertiesSearch == null) {
            this.setPropertiesSearch();
        }
        StringBuffer provinceTxt = geoCatalogProvMuniList != null && geoCatalogProvList != null ? new StringBuffer(100) : new StringBuffer();
        for (i = 0; geoCatalogProvMuniList != null && i < geoCatalogProvMuniList.size(); ++i) {
            geoCatalog = (R01MGeocode)geoCatalogProvMuniList.get(i);
            provinceIdStr = geoCatalog.getTerritory().getName().toString();
            municipalityIdStr = geoCatalog.getMunicipality().getName().toString();
            provinceTxt.append("<div>");
            if (this.bButtonsEnabled) {
                provinceTxt.append("<img style='cursor:pointer' src='");
                provinceTxt.append(this.deleteImage);
                provinceTxt.append("' title='");
                provinceTxt.append(this.propertiesSearch.getProperty("catalogation.deleteLabel"));
                provinceTxt.append("' onClick=\"javascript:deleteGeoCatalog('");
                provinceTxt.append(provinceIdStr);
                provinceTxt.append("','");
                provinceTxt.append(municipalityIdStr);
                provinceTxt.append("','");
                provinceTxt.append(this.provinceId);
                provinceTxt.append("','");
                provinceTxt.append(this.municipalityId);
                provinceTxt.append("',");
                provinceTxt.append(this.returnSelection);
                provinceTxt.append(",'");
                provinceTxt.append(provinceNameList);
                provinceTxt.append("','");
                provinceTxt.append(municipalityNameList);
                provinceTxt.append("');\"/>");
            }
            provinceTxt.append("<span class='");
            provinceTxt.append(this.styleText);
            provinceTxt.append("'>");
            provinceTxt.append(geoCatalog.getTerritory().getName());
            provinceTxt.append(" / ");
            provinceTxt.append(geoCatalog.getMunicipality().getName());
            provinceTxt.append("</span></div>\n");
        }
        for (i = 0; geoCatalogProvList != null && i < geoCatalogProvList.size(); ++i) {
            geoCatalog = (R01MGeocode)geoCatalogProvList.get(i);
            provinceIdStr = geoCatalog.getTerritory().getName().toString();
            municipalityIdStr = "-1";
            provinceTxt.append("<div>");
            if (this.bButtonsEnabled) {
                provinceTxt.append("<img style='cursor:pointer' src='");
                provinceTxt.append(this.deleteImage);
                provinceTxt.append("' title='");
                provinceTxt.append(this.propertiesSearch.getProperty("catalogation.deleteLabel"));
                provinceTxt.append("' onClick=\"javascript:deleteGeoCatalog('");
                provinceTxt.append(provinceIdStr);
                provinceTxt.append("','");
                provinceTxt.append(municipalityIdStr);
                provinceTxt.append("','");
                provinceTxt.append(this.provinceId);
                provinceTxt.append("','");
                provinceTxt.append(this.municipalityId);
                provinceTxt.append("',");
                provinceTxt.append(this.returnSelection);
                provinceTxt.append(");\"/>");
            }
            provinceTxt.append("<span class='");
            provinceTxt.append(this.styleText);
            provinceTxt.append("'>");
            provinceTxt.append(geoCatalog.getTerritory().getName());
            provinceTxt.append("</span></div>\n");
        }
        return provinceTxt;
    }

    public int doStartTag() throws JspException {
        StringBuffer text = new StringBuffer(200);
        try {
            text.append("<input type='button' id='button");
            text.append(this.divId);
            text.append("' value='");
            text.append(this.buttonValue);
            text.append("' ");
            if (this.styleButton != null && !this.styleButton.equals("")) {
                text.append("class='");
                text.append(this.styleButton);
                text.append("' ");
            }
            if (!this.bButtonsEnabled) {
                text.append("disabled ");
            }
            text.append("onClick=\"javascript:seleccionarCatalogacionGeografica('");
            text.append(this.language);
            text.append("','");
            text.append(this.returnSelection);
            text.append("','");
            text.append(this.provinceId);
            text.append("','");
            text.append(this.municipalityId);
            text.append("');\">\n<div id=\"");
            text.append(this.divId);
            text.append("\">\n");
            if (this.provinceId != "") {
                text.append("<ul>\n");
                if (this.municipalityId != "") {
                    text.append(this._getProvinceMunipalityName());
                }
            }
            text.append("</ul>\n</div>\n");
            this.pageContext.getOut().println((Object)text);
        }
        catch (IOException e) {
            R01FLog.to((String)"r01m.selectiontool").severe("*** IOException en el taglib (R01LGeographicCatalogLoad.java): " + e.getMessage());
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        return 6;
    }

    private void setPropertiesSearch() {
        try {
            this.propertiesSearch = new Properties();
            String languageResource = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)("commonInterfaceTagResources/" + this.language));
            this.propertiesSearch.load(ResourcesLoader.getResourceFileAsStream((String)languageResource));
        }
        catch (IOException e) {
            R01FLog.to((String)"r01m.selectiontool").severe("Error cargando ficheros de idiomas: " + e.toString());
        }
    }
}

