/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.commoninterface.tags;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MCatalogException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.cataloguing.structures.R01MLabel;
import com.ejie.r01m.objects.cataloguing.structures.R01MStructureItem;
import com.ejie.r01m.objects.cataloguing.structures.R01MTerm;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public class R01MComboLabelsTag
extends TagSupport {
    private static final long serialVersionUID = -4067642655544120393L;
    private String structureGUID = null;
    private String relationId = null;
    private String language = "";
    private String numberCombo = "1";
    private String labelGUID = "";
    private String comboIdentify = null;
    private String comboTitles = "";
    private String comboStyle = "";
    private String comboTitleStyle = "";
    private String presentation = "true";
    private String labelGuidJS = "";

    public void setStructureGUID(String theStructureGUID) {
        this.structureGUID = theStructureGUID;
    }

    public void setLanguage(String theLanguage) {
        this.language = theLanguage;
    }

    public String getRelationId() {
        return this.relationId;
    }

    public void setRelationId(String theRelationId) {
        this.relationId = theRelationId;
    }

    public void setNumberCombo(String theNumberCombo) {
        this.numberCombo = theNumberCombo;
    }

    public void setLabelGUID(String theLabelGUID) {
        this.labelGUID = theLabelGUID;
    }

    public void setComboIdentify(String theComboIdentify) {
        this.comboIdentify = theComboIdentify;
    }

    public void setComboTitles(String theComboTitles) {
        this.comboTitles = theComboTitles;
    }

    public void setComboStyle(String theComboStyle) {
        this.comboStyle = theComboStyle;
    }

    public void setComboTitleStyle(String theComboTitleStyle) {
        this.comboTitleStyle = theComboTitleStyle;
    }

    public String getPresentation() {
        return this.presentation;
    }

    public void setPresentation(String thePresentation) {
        this.presentation = thePresentation;
    }

    public String getLabelGuidJS() {
        return this.labelGuidJS;
    }

    public void setLabelGuidJS(String theLabelGuidJS) {
        this.labelGuidJS = theLabelGuidJS;
    }

    public String getStructureGUID() {
        return this.structureGUID;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getNumberCombo() {
        return this.numberCombo;
    }

    public String getLabelGUID() {
        return this.labelGUID;
    }

    public String getComboIdentify() {
        return this.comboIdentify;
    }

    public String getComboTitles() {
        return this.comboTitles;
    }

    public String getComboStyle() {
        return this.comboStyle;
    }

    public String getComboTitleStyle() {
        return this.comboTitleStyle;
    }

    public int doStartTag() throws JspException {
        StringBuffer html = new StringBuffer(500);
        try {
            int i;
            Integer numberComboInt = Integer.valueOf(this.numberCombo);
            int numberComboI = numberComboInt;
            String relation = "";
            relation = StringUtils.isEmptyString((String)this.relationId) ? "0" : this.relationId;
            List elementsCatalogation = null;
            try {
                elementsCatalogation = this._getChildrenNames(R01MAuthManager.createMasterSystemUserContext(), relation);
            }
            catch (R01MSecurityException ex) {
                R01FLog.to((String)"r01m.servlet").warning("No se puede crear el contexto de usuario.");
                ex.printStackTrace();
            }
            StringBuffer combo = new StringBuffer(500);
            combo.append("<div class=\"clearfix firstCombo\" id=\"div_combo_");
            combo.append(this.comboIdentify);
            combo.append("_0\">\n");
            if ("true".equals(this.presentation)) {
                combo.append("<div class=\"");
                combo.append(this.comboTitleStyle);
                combo.append("\">  <span><label for=\"combo_");
                combo.append(this.comboIdentify);
                combo.append("_0\">");
                combo.append(this._getComboTitle().get(0));
                combo.append("</label></span></div>");
                combo.append("<div class=\"");
                combo.append(this.comboStyle);
                combo.append("\">\n");
            } else {
                combo.append("<span class=\"");
                combo.append(this.comboTitleStyle);
                combo.append("\">  <input type=\"text\" id=\"text_0_");
                combo.append(this.comboIdentify);
                combo.append("\" value=\"");
                combo.append(this._getComboTitle().get(0));
                combo.append("\" onchange=\"levelTextChange(this,");
                combo.append(0);
                combo.append(",'");
                combo.append(this.comboIdentify);
                combo.append("')\">&nbsp;</span><span class=\"");
                combo.append(this.comboStyle);
                combo.append("\">\n");
            }
            combo.append("<select id=\"combo_");
            combo.append(this.comboIdentify);
            combo.append("_0\" ");
            if (numberComboI > 1) {
                combo.append(" onchange=\"javascript:loadComboOptions(this," + this.comboIdentify + ",'");
                combo.append(this._getComboDefaultValue());
                combo.append("')\"");
            }
            combo.append(">\n<option value=\"0\">");
            combo.append(this._getComboDefaultValue());
            combo.append("</option>\n");
            if (elementsCatalogation != null && !elementsCatalogation.isEmpty()) {
                for (i = 0; i < elementsCatalogation.size(); ++i) {
                    R01MStructureItem structureItem = (R01MStructureItem)elementsCatalogation.get(i);
                    R01MLabel labelObj = null;
                    R01MTerm termLabel = null;
                    try {
                        labelObj = R01MClientFactory.getCatalogAPI(R01MAuthManager.createMasterSystemUserContext()).loadLabel(structureItem.getRootLabelOid(), false);
                        if (labelObj == null) continue;
                        try {
                            termLabel = labelObj.getStandardizedTerm(this.language);
                            if (termLabel == null) continue;
                            String labelName = termLabel.getValue();
                            combo.append("<option value=\"");
                            combo.append(labelObj.getOid());
                            combo.append("\">");
                            combo.append(labelName);
                            combo.append("</option>\n");
                        }
                        catch (R01MCatalogException ex) {
                            R01FLog.to((String)"r01m.servlet").severe("*** R01MCatalogException en el taglib (R01EComboLabelsTag.java): " + ex.getMessage());
                            ex.printStackTrace();
                        }
                        continue;
                    }
                    catch (R01MCatalogException ex) {
                        R01FLog.to((String)"r01m.servlet").severe("*** R01MCatalogException en el taglib (R01EComboLabelsTag.java): " + ex.getMessage());
                        ex.printStackTrace();
                        continue;
                    }
                    catch (R01MSecurityException ex) {
                        R01FLog.to((String)"r01m.servlet").warning("No se puede crear el contexto de usuario.");
                        ex.printStackTrace();
                    }
                }
            }
            combo.append("</select>");
            if ("true".equals(this.presentation)) {
                combo.append("</div>\n");
            } else {
                combo.append("</span>\n");
            }
            combo.append("</div>\n");
            for (i = 1; i < numberComboI; ++i) {
                combo.append("<div class=\"clearfix firstCombo\" id=\"div_combo_");
                combo.append(this.comboIdentify);
                combo.append("_");
                combo.append(i);
                combo.append("\">");
                if ("true".equals(this.presentation)) {
                    combo.append("<div class=\"");
                    combo.append(this.comboTitleStyle);
                    combo.append("\"><span><label for=\"combo_");
                    combo.append(this.comboIdentify);
                    combo.append("_");
                    combo.append(i);
                    combo.append("\">");
                    combo.append(this._getComboTitle().get(i));
                    combo.append("</label></span></div><div class=\"");
                    combo.append(this.comboStyle);
                    combo.append("\">\n");
                } else {
                    combo.append("<span class=\"");
                    combo.append(this.comboTitleStyle);
                    combo.append("\">  <input type=\"text\" id=\"text_");
                    combo.append(i);
                    combo.append('_');
                    combo.append(this.comboIdentify);
                    combo.append("\" value=\"");
                    combo.append(this._getComboTitle().get(i));
                    combo.append("\" onchange=\"levelTextChange(this,");
                    combo.append(i);
                    combo.append(",'");
                    combo.append(this.comboIdentify);
                    combo.append("')\">&nbsp;</span><span class=\"");
                    combo.append(this.comboStyle);
                    combo.append("\">\n");
                }
                combo.append("<select id=\"combo_");
                combo.append(this.comboIdentify);
                combo.append('_');
                combo.append(i);
                combo.append("\"");
                if (i + 1 < numberComboI) {
                    combo.append(" onchange=\"javascript:loadComboOptions(this,");
                    combo.append(this.comboIdentify);
                    combo.append(",'");
                    combo.append(this._getComboDefaultValue());
                    combo.append("')\"");
                }
                combo.append(">\n<option value=\"0\">");
                combo.append(this._getComboDefaultValue());
                combo.append("</option>\n</select>\n");
                if ("true".equals(this.presentation)) {
                    combo.append("</div>\n");
                } else {
                    combo.append("</span>\n");
                }
                combo.append("</div>\n");
            }
            StringBuffer arrayJson = new StringBuffer(500);
            try {
                arrayJson.append(this._composeJSON(R01MAuthManager.createMasterSystemUserContext(), elementsCatalogation, numberComboI, 0));
            }
            catch (R01MSecurityException ex) {
                R01FLog.to((String)"r01m.servlet").warning("No se puede crear el contexto de usuario.");
                ex.printStackTrace();
            }
            html.append("<script type=\"text/javascript\">\nvar paramJSON");
            html.append(this.comboIdentify);
            html.append("= '");
            html.append(arrayJson);
            html.append("';\nvar structureId");
            html.append(this.comboIdentify);
            html.append(" = '");
            html.append(this.structureGUID);
            html.append("';\nvar numCombos");
            html.append(this.comboIdentify);
            html.append("= ");
            html.append(numberComboI);
            html.append(";\nvar arrayJSON");
            html.append(this.comboIdentify);
            html.append(" = eval(paramJSON");
            html.append(this.comboIdentify);
            html.append(");\nvar defaultValueTxt = '");
            html.append(this._getComboDefaultValue());
            html.append("';\nvar childArray = new Array();\n</script>\n");
            html.append(combo);
            this.pageContext.getOut().println((Object)html);
        }
        catch (IOException e) {
            R01FLog.to((String)"r01m.servlet").severe("*** IOException en el taglib (R01EComboTag.java): " + e.getMessage());
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        this.labelGUID = "";
        this.numberCombo = null;
        this.labelGuidJS = "";
        return 6;
    }

    private ArrayList _getComboTitle() {
        ArrayList<String> comboTitlesArray = new ArrayList<String>();
        StringTokenizer token = new StringTokenizer(this.comboTitles, ";");
        while (token.hasMoreTokens()) {
            comboTitlesArray.add(token.nextToken());
        }
        return comboTitlesArray;
    }

    private List _getChildrenNames(R01MUserContext userContext, String relation) {
        ArrayList vNodes = new ArrayList();
        ArrayList<String> vNodesAux = new ArrayList<String>();
        List children = new ArrayList();
        vNodesAux.add(0, this.structureGUID);
        vNodesAux.add(1, relation);
        vNodes.add(vNodesAux);
        try {
            children = R01MClientFactory.getCatalogAPI(userContext).loadChildrenOrdered(vNodes);
        }
        catch (Exception e) {
            R01FLog.to((String)"r01m.servlet").severe("*** Exception en el taglib (R01EComboTag.java): " + e.getMessage());
        }
        return children;
    }

    private String _getComboDefaultValue() {
        String defaultValue = "";
        String lang = R01MConstants.DEFAULT_LANG;
        if (this.getLanguage() != null && !StringUtils.isEmptyString((String)this.getLanguage())) {
            lang = this.getLanguage();
        }
        defaultValue = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "visualAreasResources", lang, "portal.combo.defaultOption");
        return defaultValue;
    }

    private StringBuffer _composeJSON(R01MUserContext userContext, List labelList, int finalDeep, int initialDeep) {
        StringBuffer arrayJSON = new StringBuffer(500);
        R01MStructureItem structureItem = null;
        arrayJSON.append('[');
        if (labelList != null && !labelList.isEmpty()) {
            List labelListChild = new ArrayList();
            for (int i = 0; i < labelList.size(); ++i) {
                structureItem = (R01MStructureItem)labelList.get(i);
                R01MLabel labelObj = null;
                R01MTerm termLabel = null;
                try {
                    labelObj = R01MClientFactory.getCatalogAPI(userContext).loadLabel(structureItem.getRootLabelOid(), false);
                    if (labelObj == null) continue;
                    try {
                        termLabel = labelObj.getStandardizedTerm(this.language);
                        if (termLabel == null) continue;
                        String labelName = termLabel.getValue();
                        if (arrayJSON.charAt(arrayJSON.length() - 1) != '[') {
                            arrayJSON.append(',');
                        }
                        arrayJSON.append("{\"labelOid\":\"");
                        arrayJSON.append(labelObj.getOid());
                        arrayJSON.append("\",\"labelName\":\"");
                        arrayJSON.append(labelName);
                        arrayJSON.append("\",\"relationId\":\"");
                        arrayJSON.append(structureItem.getRelationId());
                        arrayJSON.append("\",\"child\":");
                        if (initialDeep < finalDeep) {
                            if (labelListChild != null) {
                                labelListChild.clear();
                            }
                            if ((labelListChild = this._getChildrenNames(userContext, String.valueOf(structureItem.getRelationId()))) != null && !labelListChild.isEmpty()) {
                                arrayJSON.append(this._composeJSON(userContext, labelListChild, finalDeep, initialDeep + 1));
                            } else {
                                arrayJSON.append("[]");
                            }
                        } else {
                            arrayJSON.append("[]");
                        }
                        arrayJSON.append('}');
                    }
                    catch (R01MCatalogException ex) {
                        R01FLog.to((String)"r01m.servlet").severe("*** R01MCatalogException en el taglib (R01EComboLabelsTag.java): " + ex.getMessage());
                        ex.printStackTrace();
                    }
                    continue;
                }
                catch (R01MCatalogException ex) {
                    R01FLog.to((String)"r01m.servlet").severe("*** R01MCatalogException en el taglib (R01EComboLabelsTag.java): " + ex.getMessage());
                    ex.printStackTrace();
                }
            }
        }
        arrayJSON.append(']');
        return arrayJSON;
    }
}

