/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.xmlproperties.customizer;

import com.ejie.r01f.file.DirectoryWalker;
import com.ejie.r01f.file.DirectoryWalkerEventListener;
import com.ejie.r01f.file.FileUtils;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.MainParamsParser;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.customizer.XMLPropertiesCustomizer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLPropertiesCustomizerFileProcessor {
    public static void main(String[] args) {
        try {
            long t1 = System.currentTimeMillis();
            MainParamsParser mainParamsParser = new MainParamsParser();
            mainParamsParser.addParamDef("-appCode", "Codigo de aplicacion", MainParamsParser.PARAM_TYPE_GENERAL, true);
            mainParamsParser.addParamDef("-env", "Entorno (loc/sb_des/des/sb_pru/pru/pro)", MainParamsParser.PARAM_TYPE_GENERAL, true);
            mainParamsParser.addParamDef("-exceptionRegExp", "Expresion regular que indica que appCodes no se aplican segun el env ", MainParamsParser.PARAM_TYPE_GENERAL, true);
            mainParamsParser.addParamDef("-varsFile", "Fichero XML con los valores de las variables", MainParamsParser.PARAM_TYPE_ALFANUMERIC, false);
            mainParamsParser.addParamDef("-templatesDir", "Directorio donde se encuentran los ficheros 'plantilla'", MainParamsParser.PARAM_TYPE_ALFANUMERIC, false);
            mainParamsParser.addParamDef("-targetDir", "Directorio donde dejar los ficheros customizados", MainParamsParser.PARAM_TYPE_ALFANUMERIC, false);
            mainParamsParser.addParamDef("-keepNotMatchingIfs", "Devolver las condiciones if que no se cumplan", MainParamsParser.PARAM_TYPE_BOOLEAN, false);
            mainParamsParser.addParamDef("-workingRootDir", "Directorio raiz de trabajo, debe acabar con el separador de paths.", MainParamsParser.PARAM_TYPE_ALFANUMERIC, false);
            mainParamsParser.addParamDef("-varsRootDir", "Directorio raiz de ficheros de variables, debe acabar con el separador de paths.", MainParamsParser.PARAM_TYPE_ALFANUMERIC, false);
            mainParamsParser.parseParams(args);
            if (mainParamsParser.areValid()) {
                boolean keepNotMatchingIfs;
                String appCode = mainParamsParser.getParam("-appCode");
                String env = mainParamsParser.getParam("-env");
                String exceptionRegExp = mainParamsParser.getParam("-exceptionRegExp");
                String templatesDirPath = mainParamsParser.getParam("-templatesDir");
                String targetDirPath = mainParamsParser.getParam("-targetDir");
                String varsFilePath = mainParamsParser.getParam("-varsFile");
                String workingRootDirPath = mainParamsParser.getParam("-workingRootDir");
                String varsRootDirPath = mainParamsParser.getParam("-varsRootDir");
                HashMap<String, ArrayList<String>> exceptionMap = new HashMap<String, ArrayList<String>>();
                if (exceptionRegExp != null && exceptionRegExp.length() > 0) {
                    String[] exceptionRegExps = exceptionRegExp.split(",");
                    for (int i = 0; i < exceptionRegExps.length; ++i) {
                        String[] parKeyValue = exceptionRegExps[i].split(":");
                        String key = parKeyValue[0];
                        ArrayList<String> appsToExclude = new ArrayList<String>(Arrays.asList(parKeyValue[1].split(";")));
                        exceptionMap.put(key, appsToExclude);
                    }
                }
                boolean bl = mainParamsParser.getParam("-keepNotMatchingIfs") != null ? mainParamsParser.getParam("-keepNotMatchingIfs").equalsIgnoreCase("true") : (keepNotMatchingIfs = false);
                if (appCode != null && env != null && templatesDirPath == null && targetDirPath == null && varsFilePath == null) {
                    String[] envSplitted = env.split(",");
                    for (int j = 0; j < envSplitted.length; ++j) {
                        String[] appCodeSplitted = appCode.split(",");
                        for (int i = 0; i < appCodeSplitted.length; ++i) {
                            String appCodeRoot = "r01";
                            if (appCodeSplitted[i].length() == 4) {
                                appCodeRoot = appCode.substring(0, appCodeSplitted[i].length() - 1);
                            } else if (appCodeSplitted[i].length() == 5) {
                                appCodeRoot = appCode.substring(0, appCodeSplitted[i].length() - 2);
                            }
                            templatesDirPath = !StringUtils.isEmptyString(workingRootDirPath) ? workingRootDirPath + appCodeSplitted[i] + "/" + appCodeSplitted[i] + "Config/template" : "d:/tools_workspaces/eclipse/r01_wl8/" + appCodeSplitted[i] + "Config/template";
                            String[] envSplittedAux = envSplitted[j].split("/");
                            String targetDirPathAux = "";
                            for (int x = 0; x < envSplittedAux.length; ++x) {
                                if (envSplittedAux[x].equalsIgnoreCase("r01")) continue;
                                targetDirPathAux = targetDirPathAux + envSplittedAux[x] + "/";
                                if (envSplittedAux[x].indexOf("loc") == 0) break;
                                if (x != 0) continue;
                                targetDirPathAux = targetDirPathAux + "serapp/";
                            }
                            targetDirPath = !StringUtils.isEmptyString(workingRootDirPath) ? workingRootDirPath + appCodeSplitted[i] + "/" : "d:/tools_workspaces/eclipse/r01_wl8/";
                            targetDirPath = targetDirPath + appCodeSplitted[i] + "Config/" + (targetDirPathAux.indexOf("backend") > 0 ? targetDirPathAux.replaceAll("serapp/", "") : targetDirPathAux) + (envSplitted[j].indexOf("loc") != -1 || targetDirPathAux.indexOf("backend") > 0 ? "" : appCodeSplitted[i]);
                            String[] domainAndEnv = envSplitted[j].split("/");
                            if (domainAndEnv.length == 1) {
                                varsFilePath = !StringUtils.isEmptyString(varsRootDirPath) ? varsRootDirPath : "d:/tools_workspaces/eclipse/r01_wl8/r01mLibs/";
                                varsFilePath = varsFilePath + "_ejie_environment_properties/" + appCodeRoot + "/" + appCodeRoot + ".properties.vars." + envSplitted[j] + ".xml";
                            } else {
                                varsFilePath = !StringUtils.isEmptyString(varsRootDirPath) ? varsRootDirPath : "d:/tools_workspaces/eclipse/r01_wl8/r01mLibs/";
                                varsFilePath = varsFilePath + "_ejie_environment_properties/" + appCodeRoot + "/" + (domainAndEnv[1].equalsIgnoreCase("r01") ? domainAndEnv[0] : envSplitted[j]) + "/" + appCodeRoot + ".properties.vars." + domainAndEnv[0] + ".xml";
                            }
                            R01FLog.to("r01f.test").info("\r\n\r\n\r\n::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::");
                            R01FLog.to("r01f.test").info("Parametros de llamada:");
                            R01FLog.to("r01f.test").info("...-appCode=" + appCodeSplitted[i]);
                            R01FLog.to("r01f.test").info("...-env=" + envSplitted[j]);
                            R01FLog.to("r01f.test").info("...-templatesDir=" + templatesDirPath);
                            R01FLog.to("r01f.test").info("...-targetDir=" + targetDirPath);
                            R01FLog.to("r01f.test").info("...-varsFile=" + varsFilePath);
                            R01FLog.to("r01f.test").info("\r\n\r\n..............................................................");
                            boolean customize = true;
                            for (String pattern : exceptionMap.keySet()) {
                                Pattern p = Pattern.compile(".*" + pattern + ".*");
                                Matcher m = p.matcher(envSplitted[j]);
                                if (!m.matches() || !((List)exceptionMap.get(pattern)).contains(appCodeSplitted[i])) continue;
                                customize = false;
                                break;
                            }
                            if (!customize) continue;
                            XMLPropertiesCustomizerFileProcessor._customizeProperties(keepNotMatchingIfs, appCode, templatesDirPath, targetDirPath, varsFilePath);
                        }
                    }
                } else if (templatesDirPath != null && targetDirPath != null && varsFilePath != null) {
                    XMLPropertiesCustomizerFileProcessor._customizeProperties(keepNotMatchingIfs, appCode, templatesDirPath, targetDirPath, varsFilePath);
                } else {
                    R01FLog.to("r01f.test").info("\r\n\r\n\r\n::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::");
                    R01FLog.to("r01f.test").info("Error en los parametros de llamada. Hay dos formas de utilizaci\u00f3n:");
                    R01FLog.to("r01f.test").info("...-appCode=[codigoAplicacion]");
                    R01FLog.to("r01f.test").info("...-env=[Entorno (loc/softbase_desarrollo/desarrollo_/softbase_pruebas/pruebas_/produccion_)");
                    R01FLog.to("r01f.test").info("...-templatesDir=[directorio con las plantillas] -targetDir=[directorio destino] -varsFile=[fichero de varialbes]");
                    R01FLog.to("r01f.test").info("\r\n\r\n..............................................................");
                    System.exit(0);
                }
            } else {
                R01FLog.to("r01f.test").info("ERROR AL INVOCAR AL PROGRAMA.\r\nFaltan parametros:");
                R01FLog.to("r01f.test").info(mainParamsParser.getParamsUsageMessage());
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to("r01f.test").info("\r\n\r\nElapsed Time: " + (t2 - t1) / 1000L + "sg");
            System.out.println("\r\n\r\nElapsed Time: " + (t2 - t1) / 1000L + "sg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void _customizeProperties(boolean keepNotMatchingIfs, String appCode, String templatesDirPath, String targetDirPath, String varsFilePath) throws Exception {
        XMLPropertiesCustomizerFileProcessor proc;
        File templatesDirFile = new File(templatesDirPath);
        if (!templatesDirFile.exists()) {
            throw new Exception("No existe el directorio " + templatesDirPath + " con las plantillas de los ficheros de propiedades!");
        }
        if (!templatesDirFile.isDirectory()) {
            throw new Exception(templatesDirPath + " NO es un DIRECTORIO!");
        }
        File targetDirFile = new File(targetDirPath);
        if (!targetDirFile.exists()) {
            throw new Exception("No existe el directorio destino " + targetDirFile + " donde se van a dejar las propiedades parametrizadas");
        }
        if (!targetDirFile.isDirectory()) {
            throw new Exception(targetDirFile + " NO es un DIRECTORIO!");
        }
        File varsFile = new File(varsFilePath);
        if (!varsFile.exists()) {
            throw new Exception("No existe el fichero XML con las variables " + varsFilePath);
        }
        if (varsFile.isDirectory()) {
            throw new Exception(varsFile + " NO es un fichero!!!");
        }
        R01FLog.to("r01f.test").info("\r\n\r\n\r\n::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::");
        R01FLog.to("r01f.test").info("Parametrizando los ficheros de propiedades del directorio " + templatesDirPath + "...");
        R01FLog.to("r01f.test").info("...se utilizan las variables del fichero " + varsFilePath);
        R01FLog.to("r01f.test").info("...los ficheros parametrizados resultantes se dejaran en el directorio " + targetDirPath);
        R01FLog.to("r01f.test").info("\r\n\r\n..............................................................");
        XMLPropertiesCustomizer customizer = new XMLPropertiesCustomizer(appCode, keepNotMatchingIfs);
        Properties vars = customizer.parseVarsXMLFile(new FileInputStream(varsFilePath));
        R01FLog.to("r01f.test").info("Valores de las variables:\r\n" + customizer.composeVarsDebugInfo(vars));
        R01FLog.to("r01f.test").info("\r\n\r\n..............................................................");
        R01FLog.to("r01f.test").info("Customizando los ficheros de propiedades:");
        XMLPropertiesCustomizerFileProcessor xMLPropertiesCustomizerFileProcessor = proc = new XMLPropertiesCustomizerFileProcessor();
        xMLPropertiesCustomizerFileProcessor.getClass();
        CustomizerDirWalkerEventListener eventListener = xMLPropertiesCustomizerFileProcessor.new CustomizerDirWalkerEventListener(customizer, vars, targetDirPath);
        DirectoryWalker dirWalk = new DirectoryWalker(templatesDirPath, eventListener);
        while (dirWalk.hasNext()) {
            dirWalk.next();
        }
    }

    private class CustomizerDirWalkerEventListener
    implements DirectoryWalkerEventListener {
        private String _targetDirPath = null;
        private XMLPropertiesCustomizer _propsCustomizer = null;
        private Properties _vars = null;
        private String _currTargetDirPath = null;
        private Stack _prevTargetDirPaths = null;
        private static final String REPOSITORY_PATH_CVS = "CVS";
        private static final String REPOSITORY_PATH_SVN = ".svn";

        public CustomizerDirWalkerEventListener() {
        }

        public CustomizerDirWalkerEventListener(XMLPropertiesCustomizer customizer, Properties vars, String targetDirPath) {
            this._propsCustomizer = customizer;
            this._vars = vars;
            this._currTargetDirPath = this._targetDirPath = targetDirPath;
            this._prevTargetDirPaths = new Stack();
        }

        @Override
        public void enteringDirectory(File theDirectory) {
            if (theDirectory.getAbsolutePath().indexOf(REPOSITORY_PATH_CVS) > 0 || theDirectory.getAbsolutePath().indexOf(REPOSITORY_PATH_SVN) > 0) {
                return;
            }
            this._prevTargetDirPaths.push(this._currTargetDirPath);
            this._currTargetDirPath = this._currTargetDirPath + File.separator + theDirectory.getName();
            String newDirPath = StringUtils.replaceVariableValues(this._currTargetDirPath, '$', (Map)this._vars);
            File newDir = new File(newDirPath);
            if (!newDir.exists()) {
                newDir.mkdir();
            }
        }

        @Override
        public void exitingDirectory(File theDirectory) {
            if (theDirectory.getAbsolutePath().indexOf(REPOSITORY_PATH_CVS) > 0 || theDirectory.getAbsolutePath().indexOf(REPOSITORY_PATH_SVN) > 0) {
                return;
            }
            this._currTargetDirPath = (String)this._prevTargetDirPaths.pop();
        }

        @Override
        public void file(File theFile) {
            try {
                if (theFile.getAbsolutePath().indexOf(REPOSITORY_PATH_CVS) > 0 || theFile.getAbsolutePath().indexOf(REPOSITORY_PATH_SVN) > 0) {
                    return;
                }
                R01FLog.to("r01f.test").info("- fichero: " + theFile.getAbsolutePath() + "\n");
                String currFileCustomized = this._propsCustomizer.customize((Reader)new FileReader(theFile), this._vars);
                R01FLog.to("r01f.test").info(" [OK]");
                String filePath = this._currTargetDirPath + File.separator + theFile.getName();
                if (theFile.getName().equalsIgnoreCase("r01m.logback.properties.xml") && filePath.indexOf("wl11_") == -1) {
                    return;
                }
                filePath = StringUtils.replaceVariableValues(filePath, '$', (Map)this._vars);
                FileUtils.saveFile(new File(filePath), new ByteArrayInputStream(currFileCustomized.getBytes()));
            }
            catch (FileNotFoundException fnfEx) {
                R01FLog.to("r01f.test").info("[error]");
                fnfEx.printStackTrace(System.out);
            }
            catch (IOException ioEx) {
                R01FLog.to("r01f.test").info("[error]");
                ioEx.printStackTrace(System.out);
            }
        }
    }
}

