/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.xmlproperties;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.utils.XMLUtils;
import com.ejie.r01f.xmlproperties.XMLPropertiesException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class XMLPropertiesManager {
    static final String PROPSLOADER_SYSPROP_NAME = "EJIE_PROPERTY_LOADER";
    static final String CLASSPATH_PROPSLOADER = "classPathLoader";
    static final String FILE_PROPSLOADER = "fileLoader";
    static final String FILESEP = System.getProperty("file.separator");
    static final String PACKAGE = "com.ejie.r01f.xmlproperties";
    private static String _propsLoader = XMLPropertiesManager.obtainPropertiesLoader();
    private boolean _isExternalProperties = false;
    private String _propsTagName = "properties";
    private String _propertiesFilesPathPattern;
    private InputStream _file = null;
    private Document _doc;
    private Map _loadedApps = new HashMap(10);
    private Map _propsCache = new HashMap(1000);

    XMLPropertiesManager(String newPropsFilesPathPattern, String newPropsTag) {
        this._propertiesFilesPathPattern = newPropsFilesPathPattern;
        this._propsTagName = newPropsTag;
        this._isExternalProperties = false;
    }

    XMLPropertiesManager(InputStream theFile, String newPropsTag) {
        this._propsTagName = newPropsTag;
        this._file = theFile;
        this._isExternalProperties = true;
    }

    private static final String obtainPropertiesLoader() {
        String warningMsgSep = "*************************************************************************************************";
        String usageMsg = "\r\n\tLos valores validos para el procedimiento de carga de propiedades se pueden especificar de dos formas:\r\n\t\t- System.setProperty(EJIE_PROPERTY_LOADER,[fileLoader|classPathLoader])\r\n\t\t- Establecer la propiedad EJIE_PROPERTY_LOADER en el arranque de la jvm con el parametro: -DEJIE_PROPERTY_LOADER=[fileLoader|classPathLoader]";
        String outPropsLoader = System.getProperty(PROPSLOADER_SYSPROP_NAME);
        if (outPropsLoader == null) {
            Logger.global.warning("\r\n\r\n" + warningMsgSep + "\r\nCARGA DE PROPIEDADES / LITERALES: No se ha especificado valor!" + usageMsg + "\r\n\r\n\tIMPORTANTE!!\r\n\t\tSe toma cargador en base a ficheros en Windows y en base al classPath en UNIX\r\n" + warningMsgSep + "\r\n\r\n");
        } else if (outPropsLoader.equalsIgnoreCase(CLASSPATH_PROPSLOADER)) {
            Logger.global.warning("\r\n\r\n" + warningMsgSep + "\r\nCARGA DE PROPIEDADES / LITERALES:\r\n\tPropertiesLoader en base a CLASSPATH: " + outPropsLoader + usageMsg + "\r\n" + warningMsgSep + "\r\n\r\n");
        } else if (outPropsLoader.equalsIgnoreCase(FILE_PROPSLOADER)) {
            Logger.global.warning("\r\n\r\n" + warningMsgSep + "\r\nCARGA DE PROPIEDADES / LITERALES:\r\n\tPropertiesLoader en base a FICHEROS: " + outPropsLoader + usageMsg + "\r\n" + warningMsgSep + "\r\n\r\n");
        } else {
            Logger.global.severe("\r\n\r\n" + warningMsgSep + "\r\nCARGA DE PROPIEDADES / LITERALES:" + "\r\n\tEl valor " + outPropsLoader + " especificado para la propiedad del sistema " + PROPSLOADER_SYSPROP_NAME + " NO es v\u00e1lido." + usageMsg + "\r\n\r\n\tIMPORTANTE!!\r\n\t\tSe toma cargador en base a ficheros en Windows y en base al classPath en UNIX\r\n" + warningMsgSep + "\r\n\r\n");
            outPropsLoader = null;
        }
        if (outPropsLoader == null) {
            outPropsLoader = System.getProperty("os.name").startsWith("Windows") ? FILE_PROPSLOADER : CLASSPATH_PROPSLOADER;
        }
        return outPropsLoader;
    }

    public static String getPropertiesLoader() {
        return _propsLoader;
    }

    public void setPropertiesLoader(String thePropsLoader) {
        _propsLoader = thePropsLoader;
    }

    public String getPropertiesTagName() {
        return this._propsTagName;
    }

    public void setPropertiesTagName(String thePropsTagName) {
        this._propsTagName = thePropsTagName;
    }

    public String getPropertiesFilesPathPattern() {
        return this._propertiesFilesPathPattern;
    }

    public void setPropertiesFilesPathPattern(String thePropsFilesPathPattern) {
        this._propertiesFilesPathPattern = thePropsFilesPathPattern;
    }

    boolean existProperty(String appCode, String propXPath) {
        Object propValue = this._getPropertyFromCache(appCode, propXPath);
        if (propValue != null) {
            return true;
        }
        return this.getPropertyNode(appCode, propXPath) != null;
    }

    String getProperty(String appCode, String propXPath) {
        if (appCode == null || propXPath == null) {
            throw new IllegalArgumentException("El codigo de aplicacion o el xPath del nodo no son validos");
        }
        String propValue = (String)this._propsCache.get(appCode + "." + propXPath);
        if (propValue != null) {
            return propValue;
        }
        Node node = this.getPropertyNode(appCode, propXPath);
        Node theNode = null;
        if (node == null) {
            Logger.global.info(" [" + propXPath + "] no encontrado");
            return null;
        }
        theNode = node.getFirstChild();
        if (theNode == null) {
            Logger.global.info(" [" + propXPath + "] no tiene datos");
            return null;
        }
        if (!XMLUtils.isTextNode(theNode)) {
            Logger.global.info("El nodo '" + this._propsTagName + "[@appCode='" + appCode + "']/" + propXPath + "' NO es un nodo tipo texto");
            return null;
        }
        Logger.global.info(" [" + propXPath + "] = " + theNode.getNodeValue());
        propValue = theNode.getNodeValue();
        this._putPropertyInCache(appCode, propXPath, propValue);
        return propValue;
    }

    String customize(String appCode, String propXPath, String[] variables) {
        String strProp = this.getProperty(appCode, propXPath);
        if (strProp != null) {
            int prevPos = 0;
            int pos = -1;
            String varName = null;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < variables.length; ++i) {
                varName = "[?" + Integer.toString(i) + "]";
                pos = strProp.indexOf(varName, prevPos);
                if (pos < 0) continue;
                sb.append(strProp.substring(prevPos, pos) + variables[i]);
                prevPos = pos + varName.length();
            }
            sb.append(strProp.substring(prevPos));
            return sb.toString();
        }
        return strProp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node getPropertyNode(String appCode, String propXPath) {
        try {
            this._getAppPropertiesNode(appCode);
            propXPath = propXPath.trim();
            if (propXPath.startsWith("/")) {
                propXPath = propXPath.substring(1);
            }
            Document document = this._doc;
            synchronized (document) {
                Node outNode;
                Method m;
                Class<?> c;
                try {
                    c = Class.forName("org.apache.xpath.XPathAPI");
                }
                catch (ClassNotFoundException ex) {
                    try {
                        c = Class.forName("com.sun.org.apache.xpath.internal.XPathAPI");
                    }
                    catch (ClassNotFoundException ex1) {
                        Logger.global.warning("Error al ejecutar la ruta xPath:" + this._propsTagName + "[@appCode='" + appCode + "']/" + propXPath + ": " + ex1.toString());
                        return null;
                    }
                }
                Class[] claseParametros = new Class[]{Node.class, String.class};
                try {
                    m = c.getDeclaredMethod("selectSingleNode", claseParametros);
                }
                catch (Exception ex) {
                    Logger.global.warning("Error al ejecutar la ruta xPath:" + this._propsTagName + "[@appCode='" + appCode + "']/" + propXPath + ": " + ex.toString());
                    return null;
                }
                Object[] parametros = new Object[]{this._doc.getDocumentElement(), "//" + this._propsTagName + "[@appCode='" + appCode + "']/" + propXPath};
                try {
                    outNode = (Node)m.invoke(null, parametros);
                }
                catch (Exception ex) {
                    Logger.global.warning("Error al ejecutar la ruta xPath:" + this._propsTagName + "[@appCode='" + appCode + "']/" + propXPath + ": " + ex.toString());
                    return null;
                }
                if (outNode == null) {
                    R01FLog.global.warning("NO se ha encontrado el nodo xPath " + this._propsTagName + "[@appCode='" + appCode + "']/" + propXPath + ": Revisa el fichero xmlProperties de la aplicacion " + appCode);
                }
                return outNode;
            }
        }
        catch (Exception tEx) {
            Logger.global.warning("Error al ejecutar la ruta xPath:" + this._propsTagName + "[@appCode='" + appCode + "']/" + propXPath + ": " + tEx.toString());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeIterator getPropertyNodeIterator(String appCode, String propXPath) {
        try {
            this._getAppPropertiesNode(appCode);
            if (propXPath.startsWith("/")) {
                propXPath = propXPath.substring(1);
            }
            Document document = this._doc;
            synchronized (document) {
                NodeIterator outNode;
                Method m;
                Class<?> c;
                try {
                    c = Class.forName("org.apache.xpath.XPathAPI");
                }
                catch (ClassNotFoundException ex) {
                    try {
                        c = Class.forName("com.sun.org.apache.xpath.internal.XPathAPI");
                    }
                    catch (ClassNotFoundException ex1) {
                        Logger.global.warning("Error al ejecutar la ruta xPath:" + this._propsTagName + "[@appCode='" + appCode + "']/" + propXPath + ": " + ex1.toString());
                        return null;
                    }
                }
                Class[] claseParametros = new Class[]{Node.class, String.class};
                try {
                    m = c.getDeclaredMethod("selectNodeIterator", claseParametros);
                }
                catch (Exception ex) {
                    Logger.global.warning("Error al ejecutar la ruta xPath:" + this._propsTagName + "[@appCode='" + appCode + "']/" + propXPath + ": " + ex.toString());
                    return null;
                }
                Object[] parametros = new Object[]{this._doc.getDocumentElement(), "//" + this._propsTagName + "[@appCode='" + appCode + "']/" + propXPath};
                try {
                    outNode = (NodeIterator)m.invoke(null, parametros);
                }
                catch (Exception ex) {
                    Logger.global.warning("Error al ejecutar la ruta xPath:" + this._propsTagName + "[@appCode='" + appCode + "']/" + propXPath + ": " + ex.toString());
                    return null;
                }
                if (outNode == null) {
                    R01FLog.global.warning("NO se ha encontrado el nodo xPath " + this._propsTagName + "[@appCode='" + appCode + "']/" + propXPath + ": Revisa el fichero xmlProperties de la aplicacion " + appCode);
                }
                return outNode;
            }
        }
        catch (Exception tEx) {
            Logger.global.warning("Error al ejecutar la ruta xPath: " + this._propsTagName + "[@appCode='" + appCode + "']/" + propXPath + ": " + tEx.toString());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getPropertyList(String appCode, String propXPath) {
        if (appCode == null || propXPath == null) {
            throw new IllegalArgumentException("El codigo de aplicacion o el xPath del nodo no son validos");
        }
        ArrayList<String> outList = null;
        outList = (ArrayList<String>)this._getPropertyFromCache(appCode, propXPath);
        if (outList != null) {
            return outList;
        }
        Document document = this._doc;
        synchronized (document) {
            NodeIterator nI = this.getPropertyNodeIterator(appCode, propXPath);
            if (nI != null) {
                Node node = null;
                outList = new ArrayList<String>();
                while ((node = nI.nextNode()) != null) {
                    if ((node = node.getFirstChild()) == null || !XMLUtils.isTextNode(node)) continue;
                    outList.add(node.getNodeValue());
                    Logger.global.info("\t[" + propXPath + "] = " + node.getNodeValue());
                }
            } else {
                Logger.global.info(" [" + propXPath + "] no encontrado");
            }
        }
        if (outList != null && outList.size() == 0) {
            Logger.global.info("[" + propXPath + "] no tiene datos");
            return null;
        }
        this._putPropertyInCache(appCode, propXPath, outList);
        return outList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Properties getProperties(String appCode, String propXPath) {
        if (appCode == null || propXPath == null) {
            throw new IllegalArgumentException("El codigo de aplicacion o el xPath del nodo no son validos");
        }
        Properties outProps = null;
        outProps = (Properties)this._getPropertyFromCache(appCode, propXPath);
        if (outProps != null) {
            return outProps;
        }
        Document document = this._doc;
        synchronized (document) {
            Node node = this.getPropertyNode(appCode, propXPath);
            if (node != null) {
                NodeList nodes = node.getChildNodes();
                if (nodes != null) {
                    Node theNode = null;
                    outProps = new Properties();
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        theNode = nodes.item(i);
                        if (XMLUtils.isTextNode(theNode) || theNode.getChildNodes() == null || theNode.getChildNodes().getLength() != 1) continue;
                        Logger.global.info("\t(" + theNode.getNodeName() + ")" + theNode.getFirstChild().getNodeValue());
                        outProps.setProperty(theNode.getNodeName(), theNode.getFirstChild().getNodeValue());
                    }
                }
            } else {
                Logger.global.info("Nodo properties '" + propXPath + "' no encontrado");
            }
            if ((outProps == null || outProps.size() == 0) && node != null) {
                R01FLog.to("r01f.test").info("\r\n\r\n\r\nBUG de API XML: la llamada a getChildNodes() ha devuelto null!!!\r\n\r\n\r\n\n");
                outProps = new Properties();
                for (Node currNode = node.getFirstChild(); currNode != null; currNode = currNode.getNextSibling()) {
                    if (XMLUtils.isTextNode(currNode)) continue;
                    outProps.setProperty(currNode.getNodeName(), currNode.getFirstChild().getNodeValue());
                }
            }
        }
        if (outProps != null && outProps.size() == 0) {
            Logger.global.warning("Nodo properties '" + propXPath + "' NO contiene propiedades!");
        }
        this._putPropertyInCache(appCode, propXPath, outProps);
        return outProps;
    }

    void reload() {
        Logger.global.warning("Forzando recarga de XMLProperties");
        this._loadedApps = new Hashtable(10);
        this._propsCache = new HashMap(1000);
        this._doc = null;
    }

    private Object _getPropertyFromCache(String appCode, String propXPath) {
        String propKey = appCode + "." + propXPath;
        Object propValue = this._propsCache.get(propKey);
        return propValue;
    }

    private void _putPropertyInCache(String appCode, String propXPath, Object propValue) {
        String propKey = appCode + "." + propXPath;
        if (propValue != null) {
            this._propsCache.put(propKey, propValue);
        }
    }

    private Node _getAppPropertiesNode(String appCode) {
        try {
            Node node = (Node)this._loadedApps.get(appCode);
            if (node == null) {
                Logger.global.info("No se habia cargado la aplicacion " + appCode);
                node = this._loadProperties(appCode);
            }
            Logger.global.info("Recuperando nodo de la aplicacion " + appCode);
            return node;
        }
        catch (XMLPropertiesException xpEx) {
            Logger.global.warning("Error al cargar los properties de la aplicacion '" + appCode + "': " + xpEx.toString());
            return null;
        }
    }

    private synchronized Node _loadProperties(String appCode) throws XMLPropertiesException {
        Element root = null;
        if (this._doc == null) {
            Logger.global.info("Creando el nodo raiz de la estructura <com.ejie.r01f.xmlproperties.Properties>");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                this._doc = builder.newDocument();
                root = this._doc.createElement("com.ejie.r01f.xmlproperties.Properties");
                this._doc.appendChild(root);
            }
            catch (ParserConfigurationException pcEx) {
                throw new XMLPropertiesException("Error en la configuraci\u00f3n del parser XML: " + pcEx.toString());
            }
        } else {
            root = this._doc.getDocumentElement();
        }
        if (root == null) {
            Logger.global.warning("Error al obtener el nodo raiz <com.ejie.r01f.xmlproperties.Properties>");
            throw new XMLPropertiesException("Error irrecuperable al obtener el nodo raiz <com.ejie.r01f.xmlproperties.Properties>");
        }
        Logger.global.info("A\u00f1adiendo el nodo <" + this._propsTagName + " appCode='" + appCode + "'> con las propiedades de la aplicacion");
        Document newPropertiesDoc = this._loadAndParseXMLFile(appCode);
        Element element = newPropertiesDoc.getDocumentElement();
        element.setAttribute("appCode", appCode);
        if (element != null) {
            XMLUtils.write(element, null);
            root.appendChild(this._doc.importNode(element, true));
            this._loadedApps.put(appCode, element);
        }
        return element;
    }

    private Document _loadAndParseXMLFile(String appCode) throws XMLPropertiesException {
        String filePath = "";
        if (this._propertiesFilesPathPattern == null && !this._isExternalProperties) {
            throw new XMLPropertiesException("No se ha establecido el patr\u00f3n para encontrar los ficheros de propiedades. Revisa la documentaci\u00f3n de la clase XMLPropertiesManager.java!");
        }
        if (this._propertiesFilesPathPattern != null) {
            filePath = StringUtils.replaceString(this._propertiesFilesPathPattern, "[entityCode]", appCode);
            Logger.global.info("Cargando los datos del nodo de la aplicacion " + appCode + " desde el fichero " + filePath);
        }
        InputStream propsIS = null;
        try {
            propsIS = this._isExternalProperties ? this._file : (_propsLoader.equalsIgnoreCase(CLASSPATH_PROPSLOADER) ? this.getClass().getResourceAsStream(filePath) : new FileInputStream(filePath));
        }
        catch (FileNotFoundException fnfEx) {
            Logger.global.warning("Error al obtener el nodo raiz <com.ejie.r01f.xmlproperties.Properties>");
            throw new XMLPropertiesException("No se encuentra el fichero XML de propiedades: " + filePath + ": " + fnfEx.toString());
        }
        if (propsIS == null) {
            throw new XMLPropertiesException("No se ha podido obtener un inputStream al fichero de propiedades " + filePath + " utilizando el propertiesLoader: " + _propsLoader + " y el patron de propieades " + this._propertiesFilesPathPattern);
        }
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        dfactory.setIgnoringComments(true);
        dfactory.setNamespaceAware(true);
        try {
            Document document = dfactory.newDocumentBuilder().parse(new InputSource(propsIS));
            return document;
        }
        catch (ParserConfigurationException pcEx) {
            throw new XMLPropertiesException("Error en la configuraci\u00f3n del parser XML: " + pcEx.toString());
        }
        catch (SAXException saxEx) {
            throw new XMLPropertiesException("Error en el parseo SAX: " + saxEx.toString());
        }
        catch (IOException ioEx) {
            throw new XMLPropertiesException("Error en el flujo de entrada al parser: " + ioEx.toString());
        }
        finally {
            try {
                propsIS.close();
            }
            catch (Exception ignore) {}
        }
    }

    public String printDebugInfo() {
        return this.toString();
    }

    public String getDebugInfo() {
        return this.toString();
    }

    public String toString() {
        if (this._doc == null) {
            return "";
        }
        return XMLUtils.write(this._doc, null);
    }

    public String appConfigToString(String appCode) {
        if (appCode == null) {
            return "";
        }
        Node appNode = this._getAppPropertiesNode(appCode);
        return appNode == null ? "Error" : XMLUtils.write(appNode, null);
    }
}

