/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.xmlproperties;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01f.xmlproperties.XMLPropertiesManager;
import java.util.List;

public final class XMLLiterals {
    private static final String _LITERALS_PATTERN_SYSPROP_NAME = "EJIE_LITS_PATTERN";
    private static XMLPropertiesManager _xManager;
    private static String _defaultXMLLiteralsDirectory;
    private String _entityCode;
    private String _lang;

    private XMLLiterals() {
    }

    public XMLLiterals(String entityCode, String lang) {
        this._entityCode = entityCode;
        this._lang = lang;
    }

    public String get(String propXPath) {
        if (propXPath.endsWith("/")) {
            propXPath = propXPath.substring(0, propXPath.length() - 1);
        }
        return XMLLiterals.get(this._entityCode, propXPath + "/" + this._lang);
    }

    public static List getList(String entityCode, String propXPath) {
        return _xManager.getPropertyList(entityCode, propXPath);
    }

    public List getList(String propXPath) {
        if (propXPath.endsWith("/")) {
            propXPath = propXPath.substring(0, propXPath.length() - 1);
        }
        return XMLLiterals.getList(this._entityCode, propXPath + "/" + this._lang);
    }

    public String customize(String propXPath, String[] variables) {
        return XMLLiterals.customize(this._entityCode, propXPath + "/" + this._lang, variables);
    }

    public static String get(String entityCode, String propXPath) {
        String strLit = _xManager.getProperty(entityCode, propXPath);
        if (strLit == null) {
            return "";
        }
        return strLit;
    }

    public static String customize(String entityCode, String propXPath, String[] variables) {
        String strLit;
        if (propXPath.endsWith("/")) {
            propXPath = propXPath.substring(0, propXPath.length() - 1);
        }
        if ((strLit = _xManager.getProperty(entityCode, propXPath)) == null) {
            return "";
        }
        int prevPos = 0;
        int pos = -1;
        String varName = null;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < variables.length; ++i) {
            varName = "[?" + Integer.toString(i) + "]";
            pos = strLit.indexOf(varName, prevPos);
            if (pos < 0) continue;
            sb.append(strLit.substring(prevPos, pos) + variables[i]);
            prevPos = pos + varName.length();
        }
        sb.append(strLit.substring(prevPos));
        return sb.toString();
    }

    public static void reload() {
        _xManager.reload();
    }

    public static String getDebugInfo() {
        return _xManager.getDebugInfo();
    }

    public static void main(String[] argv) {
        try {
            XMLLiterals lits = new XMLLiterals("s03a", "es");
            R01FLog.to("r01f.test").info(lits.get("mensajes/relleneForm"));
            R01FLog.to("r01f.test").info(lits.customize("busqueda/cabecera/resultadosConParametros", new String[]{"1"}));
        }
        catch (Throwable t) {
            R01FLog.to("r01f.test").info(t.toString());
            t.printStackTrace(System.out);
        }
        System.exit(0);
    }

    static {
        String warningMsgSep;
        String litsPathPattern = System.getProperty(_LITERALS_PATTERN_SYSPROP_NAME);
        if (_defaultXMLLiteralsDirectory == null) {
            String litDirectory = null;
            litDirectory = XMLProperties.get("r01ft", "defaultXMLLiteralsDirectory/path");
            _defaultXMLLiteralsDirectory = litDirectory == null ? "/html/datos/" : litDirectory;
        }
        if (litsPathPattern == null) {
            warningMsgSep = "*************************************************************************************************";
            String propsLoader = XMLPropertiesManager.getPropertiesLoader();
            if (propsLoader == null || propsLoader.equalsIgnoreCase("fileLoader")) {
                litsPathPattern = System.getProperty("os.name").startsWith("Windows") ? "d:/eAdmin/aplic/[entityCode]" + _defaultXMLLiteralsDirectory + "[entityCode].text.xml" : "/aplic/[entityCode]" + _defaultXMLLiteralsDirectory + "[entityCode].text.xml";
                String warningMsg = "\r\nLa carga de propiedades se hace en base a FileLoader\r\n";
                warningMsg = warningMsg + "NO se ha establecido el patr\u00f3n con el fichero de propiedades!!!!\r\n";
                warningMsg = warningMsg + "se toma la configuracion dependiente del sistema operativo: " + litsPathPattern + "\r\n";
                R01FLog.global.warning(warningMsgSep + warningMsg + warningMsgSep);
            } else if (propsLoader.equalsIgnoreCase("classPathLoader")) {
                litsPathPattern = _defaultXMLLiteralsDirectory + "[entityCode].text.xml";
                String warningMsg = "\r\nLa carga de propiedades se hace en base a classPathLoader\r\n";
                warningMsg = warningMsg + "\r\nNO se ha establecido el patr\u00f3n con el fichero de propiedades!!!!\r\n";
                warningMsg = warningMsg + "se toma la configuracion por defecto: " + litsPathPattern + "\r\n";
                R01FLog.global.warning(warningMsgSep + warningMsg + warningMsgSep);
            }
        }
        warningMsgSep = "*************************************************************************************************";
        String usageMsg = "\r\n\tSe puede establecer el patr\u00f3n para los ficheros de propiedades de dos formas:\r\n\t\t- System.setProperty(EJIE_LITS_PATTERN,pattern utilizando [entityCode] como variable del c\u00f3digo de aplicacion)\r\n\t\t- Establecer la propiedad EJIE_LITS_PATTERN en el arranque de la jvm con el parametro: -DEJIE_LITS_PATTERN=pattern utilizando [entityCode] como variable del c\u00f3digo de aplicacion";
        R01FLog.global.warning("\r\n\r\n" + warningMsgSep + "\r\nPATRON DE CARGA DE PROPIEDADES :" + litsPathPattern + "\r\n" + usageMsg + "\r\n" + warningMsgSep + "\r\n\r\n\r\n");
        _xManager = new XMLPropertiesManager(litsPathPattern, "localeText");
    }
}

