/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.xmlproperties;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xmlproperties.XMLPropertiesManager;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class XMLExternalProperties {
    private XMLPropertiesManager _xManager;

    protected XMLExternalProperties() {
    }

    public XMLExternalProperties(String propsPathPattern) {
        this._xManager = new XMLPropertiesManager(propsPathPattern, "properties");
    }

    public XMLExternalProperties(InputStream theFile) {
        this._xManager = new XMLPropertiesManager(theFile, "properties");
    }

    public boolean existProperty(String appCode, String propXPath) {
        return this._xManager.existProperty(appCode, propXPath);
    }

    public String getProperty(String appCode, String propXPath) {
        return this._xManager.getProperty(appCode, propXPath);
    }

    public String get(String appCode, String propXPath) {
        return this.getProperty(appCode, propXPath);
    }

    public String get(String appCode, String propXPath, String defValue) {
        String outValue = this.get(appCode, propXPath);
        return outValue != null ? outValue : defValue;
    }

    public String customize(String appCode, String propXPath, String[] variables) {
        return this._xManager.customize(appCode, propXPath, variables);
    }

    public String getCustomized(String appCode, String propXPath, String[] variables) {
        return this._xManager.customize(appCode, propXPath, variables);
    }

    public Node getPropertyNode(String appCode, String propXPath) {
        return this._xManager.getPropertyNode(appCode, propXPath);
    }

    public NodeIterator getPropertyNodeIterator(String appCode, String propXPath) {
        return this._xManager.getPropertyNodeIterator(appCode, propXPath);
    }

    public List getPropertyList(String appCode, String propXPath) {
        return this._xManager.getPropertyList(appCode, propXPath);
    }

    public Properties getProperties(String appCode, String propXPath) {
        return this._xManager.getProperties(appCode, propXPath);
    }

    public String getString(String appCode, String propXPath) {
        return this._xManager.getProperty(appCode, propXPath);
    }

    public char getChar(String appCode, String propXPath) {
        String strProp = this._xManager.getProperty(appCode, propXPath);
        if (strProp == null) {
            return '\u0000';
        }
        return strProp.charAt(0);
    }

    public boolean getBoolean(String appCode, String propXPath) {
        String strProp = this._xManager.getProperty(appCode, propXPath);
        if (strProp == null) {
            return false;
        }
        return (strProp = strProp.trim()).equalsIgnoreCase("true");
    }

    public int getInt(String appCode, String propXPath) {
        String strProp = this._xManager.getProperty(appCode, propXPath);
        if (strProp == null) {
            return Integer.MIN_VALUE;
        }
        return Integer.parseInt(strProp);
    }

    public long getLong(String appCode, String propXPath) {
        String strProp = this._xManager.getProperty(appCode, propXPath);
        if (strProp == null) {
            return Long.MIN_VALUE;
        }
        return Long.parseLong(strProp);
    }

    public double getDouble(String appCode, String propXPath) {
        String strProp = this._xManager.getProperty(appCode, propXPath);
        if (strProp == null) {
            return Double.MIN_VALUE;
        }
        return Double.parseDouble(strProp);
    }

    public float getFloat(String appCode, String propXPath) {
        String strProp = this._xManager.getProperty(appCode, propXPath);
        if (strProp == null) {
            return Float.MIN_VALUE;
        }
        return Float.parseFloat(strProp);
    }

    public void reload() {
        this._xManager.reload();
    }

    public String getDebugInfo() {
        return this._xManager.getDebugInfo();
    }

    public static void main(String[] args) {
        try {
            long t1 = System.currentTimeMillis();
            int testTimes = 1;
            for (int times = 0; times < testTimes; ++times) {
                XMLExternalProperties extProps = new XMLExternalProperties("/config/[entityCode]/[entityCode].businessDelegate.properties.xml");
                R01FLog.to("r01f.test").info("=======================XMLProperties============================");
                R01FLog.to("r01f.test").info("--->p03.elemento: " + extProps.getProperty("p03", "elemento/valor"));
                R01FLog.to("r01f.test").info("--->r01.elemento: " + extProps.getProperty("r01", "elemento/valor"));
                R01FLog.to("r01f.test").info("\r\n--->p03.lista:");
                List lista3 = extProps.getPropertyList("p03", "lista/elemento");
                if (lista3 != null) {
                    Iterator it = lista3.iterator();
                    while (it.hasNext()) {
                        System.out.print((String)it.next() + "\r\n");
                    }
                }
                R01FLog.to("r01f.test").info("\r\n--->r01.lista:");
                List lista1 = extProps.getPropertyList("r01", "lista/elemento");
                if (lista1 != null) {
                    Iterator it = lista1.iterator();
                    while (it.hasNext()) {
                        System.out.print((String)it.next() + "\r\n");
                    }
                }
                R01FLog.to("r01f.test").info("\r\n--->p03.properties:");
                Properties props3 = extProps.getProperties("p03", "props");
                if (props3 != null) {
                    for (Map.Entry<Object, Object> me : props3.entrySet()) {
                        System.out.print((String)me.getKey() + ":" + (String)me.getValue() + "\r\n");
                    }
                }
                R01FLog.to("r01f.test").info("\r\n--->r01.properties:");
                Properties props1 = extProps.getProperties("r01", "props");
                if (props1 != null) {
                    for (Map.Entry<Object, Object> me : props1.entrySet()) {
                        System.out.print((String)me.getKey() + ":" + (String)me.getValue() + "\r\n");
                    }
                }
                R01FLog.to("r01f.test").info("\r\n--->r01.database:");
                Properties props4 = extProps.getProperties("r01", "database/connection[@name='uidGenerator']");
                if (props4 != null) {
                    for (Map.Entry<Object, Object> me : props4.entrySet()) {
                        System.out.print((String)me.getKey() + ":" + (String)me.getValue() + "\r\n");
                    }
                }
                R01FLog.to("r01f.test").info("\r\n\r\n\r\n----------------------------------------------------");
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to("r01f.test").info("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t1) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

