/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.xml.utils;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xml.utils.XMLSerializerHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLUtils {
    public static String write(Document doc, String outEncoding) {
        if (doc == null) {
            return null;
        }
        return XMLUtils.write(doc.getDocumentElement(), outEncoding);
    }

    public static String write(Node beginNode, String outEncoding) {
        if (beginNode == null) {
            return null;
        }
        try {
            return XMLSerializerHelper.getOuterXML(beginNode, outEncoding);
        }
        catch (TransformerException tEx) {
            return "Error al pasar el nodo DOM a String XML: " + tEx.toString();
        }
    }

    public static boolean isTextNode(Node n) {
        if (n == null) {
            return false;
        }
        short nodeType = n.getNodeType();
        return nodeType == 4 || nodeType == 3;
    }

    public static String getTagFormatedXML(String nonTagFormatedXML, String outEncoding) throws TransformerException {
        Document doc = null;
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        dfactory.setIgnoringComments(true);
        if (nonTagFormatedXML.indexOf("<?xml version='1.0' encoding='ISO-8859-1'?>") > -1) {
            nonTagFormatedXML = nonTagFormatedXML.substring("<?xml version='1.0' encoding='ISO-8859-1'?>".length());
        }
        dfactory.setNamespaceAware(true);
        try {
            InputSource is = new InputSource(new ByteArrayInputStream(("<?xml version='1.0' encoding='ISO-8859-1'?>" + nonTagFormatedXML).getBytes()));
            doc = dfactory.newDocumentBuilder().parse(is);
        }
        catch (ParserConfigurationException pcEx) {
            throw new TransformerException("Error en la configuracin del parser XML: " + pcEx.toString());
        }
        catch (SAXException saxEx) {
            throw new TransformerException("Error en el parseo SAX: " + saxEx.toString());
        }
        catch (IOException ioEx) {
            throw new TransformerException("Error en el parseo SAX: " + ioEx.toString());
        }
        String salida = XMLUtils.write(doc, outEncoding);
        String salidaOut = salida.substring("<?xml version='1.0' encoding='UTF-8'?>".length());
        salidaOut = salidaOut.substring(salidaOut.indexOf("<"));
        return salidaOut;
    }

    public static void main(String[] args) {
        try {
            long t1 = System.currentTimeMillis();
            int testTimes = 1;
            for (int times = 0; times < testTimes; ++times) {
                String peticionPagoXML = "<peticionPago><expedienteAsociado></expedienteAsociado><entidadSIPCA></entidadSIPCA><imagenes><imagen id='1'><url><![CDATA[http://www.ej-gv.net/mipago/images/p72EJGVbilingueSmall.gif]]></url></imagen></imagenes><importe>1.11</importe><gastoGV>false</gastoGV><emisor><codigoPostal>010001</codigoPostal><nombreCastellano>Gobierno Vasco - Juventud y Acci\u00f3n Comunitaria</nombreCastellano><nombreEuskera>Eusko Jaurlaritza - Juventud y Acci\u00f3n Comunitaria</nombreEuskera><calle>Calle</calle><municipio>Municipio</municipio><cif>04833001</cif><territorio>Territorio</territorio><codigo>04833001-501</codigo></emisor><descripcion><castellano>Juventud</castellano><euskera>Juventud</euskera></descripcion><presentacion><instance>1</instance><conformidad>true</conformidad><idioma>ES</idioma><entidadesFinancieras><entidadFinanciera def='false' id='2095'/><entidadFinanciera def='false' id='2101'/><entidadFinanciera def='false' id='2097'/></entidadesFinancieras><mediosPago><medioPago def='false' id='02'/></mediosPago></presentacion><exentoPago>false</exentoPago><conceptosPeticionPago><conceptoPeticionPago><ivaRepercutido>false</ivaRepercutido><castellano>Juventud</castellano><tipoIVA>0.0</tipoIVA><importe>1.11</importe><baseImponible>0.0</baseImponible><numeroLinea>1</numeroLinea><euskera>Juventud</euskera></conceptoPeticionPago></conceptosPeticionPago><identificacion>111111</identificacion><modoPago>0</modoPago><referencia>0000000000047</referencia><informarSIPCA>false</informarSIPCA><mensajes><mensaje><castellano>El pago de esta liquidaci\u00f3n se acredita mediante validaci\u00f3n mec\u00e1nica o justificante del ingreso de la Entidad Financiera colaboradora</castellano><euskera>Kitapen honen ordainketa balioztatze mekanikoaren bitartez egiaztatzen da, edota Finantza-erakunde laguntzaileak egindako diru sarreraren ziurtagiriaren bidez</euskera></mensaje></mensajes><aplicacion codigo='p72'><castellano>E_Pasarela de Pagos</castellano><euskera>Pasarela de Pagos</euskera><imagen id='1'><url><![CDATA[http://www.ej-gv.net/mipago/images/p72EJGVbilingueSmall.gif]]></url></imagen><responsable>Alex Lara (EJIE)</responsable></aplicacion><fechaLimitePago>11/11/2011</fechaLimitePago><protocolo><urlVuelta><![CDATA[http://www.ej-gv.net]]></urlVuelta><urlValidacion><![CDATA[http://www.ej-gv.net/p72/p72ppaServlet?module=if]]></urlValidacion><pagoID>048330015010000000000047111111111</pagoID><urlResultado><![CDATA[http://www.ej-gv.net/p72/p72ppaServlet?module=if]]></urlResultado></protocolo></peticionPago>";
                R01FLog.to("r01f.test").info(XMLUtils.getTagFormatedXML(peticionPagoXML, null));
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to("r01f.test").info("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t1) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

