/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.xml.utils;

import com.ejie.r01f.file.ResourcesLoader;
import com.ejie.r01f.log.R01FLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XMLTransformerHelper {
    public static void applyXSLtoXML(InputStream xmlIs, InputStream xslIs, Properties transformerParams, OutputStream xmlOut) throws TransformerException {
        StreamSource xslSrc = new StreamSource(xslIs);
        StreamSource xmlSrc = new StreamSource(xmlIs);
        StreamResult xmlDst = new StreamResult(xmlOut);
        try {
            TransformerFactory tranformerFactory = TransformerFactory.newInstance();
            Transformer transformer = tranformerFactory.newTransformer(xslSrc);
            if (transformerParams != null) {
                for (Map.Entry<Object, Object> me : transformerParams.entrySet()) {
                    transformer.setParameter((String)me.getKey(), (String)me.getValue());
                }
            }
            transformer.transform(xmlSrc, xmlDst);
        }
        catch (TransformerConfigurationException tfCfgEx) {
            tfCfgEx.printStackTrace(System.out);
            throw new TransformerException(tfCfgEx);
        }
        catch (TransformerFactoryConfigurationError tfCfgErr) {
            tfCfgErr.printStackTrace(System.out);
            throw new TransformerException(tfCfgErr);
        }
        finally {
            try {
                if (xmlSrc != null && xmlSrc.getInputStream() != null) {
                    xmlSrc.getInputStream().close();
                }
                if (xslSrc != null && xslSrc.getInputStream() != null) {
                    xslSrc.getInputStream().close();
                }
                if (xmlDst != null && xmlDst.getOutputStream() != null) {
                    xmlDst.getOutputStream().flush();
                    xmlDst.getOutputStream().close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
        }
    }

    public static void main(String[] args) {
        try {
            long t1 = System.currentTimeMillis();
            int testTimes = 1;
            for (int times = 0; times < testTimes; ++times) {
                String xslDecorator = "D:/tools/workspaces/r01/r01hClasses/html/AVComun/SearchResult/xsl/r01gFullTextSearchResult.xsl";
                String xml = "<?xml version='1.0' encoding='ISO-8859-1' ?><autnresponse xmlns:autn='http://schemas.autonomy.com/aci/'><action>QUERY</action><response>SUCCESS</response><responsedata><autn:numhits>10</autn:numhits><autn:totalhits>632</autn:totalhits><autn:hit><autn:reference>/.iwmnt/euskadi/main/r01_ehu_des/WORKAREA/wr01_ehu1/memoria/memoria_profesorado/es_mem_prof/adjuntos/Memoria_Academica_Curso_2004-05.pdf</autn:reference>   <autn:section>9</autn:section>  <autn:weight>88.15</autn:weight>        <autn:links>GOBIERNO</autn:links>   <autn:database>gestion_euskadi_db</autn:database>       <autn:title>Memoria 2004-2005</autn:title></autn:hit><autn:hit>     <autn:reference>/.iwmnt/euskadi/main/r01_ehu_des/WORKAREA/wr01_ehu1/organo/ccqss_organos_gobierno/es_organos/organos_de_gobierno.html</autn:reference>      <autn:section>0</autn:section>  <autn:weight>83.82</autn:weight>        <autn:links>GOBIERNO</autn:links>   <autn:database>gestion_euskadi_db</autn:database>       <autn:title>\u00d3RGANOS DE GOBIERNO El Gobierno de la Facultad en cuanto ...</autn:title></autn:hit><autn:hit>  <autn:reference>/.iwmnt/euskadi/main/r01_ehu_des/WORKAREA/wr01_ehu1/normativa/vg_consejosocial_reglamento_re/eu_regla/adjuntos/LOU21dic2001.pdf</autn:reference>    <autn:section>20</autn:section> <autn:weight>83.82</autn:weight>    <autn:links>GOBIERNO</autn:links>       <autn:database>gestion_euskadi_db</autn:database>       <autn:title>Page 1 463 El Pleno del Congreso de los Diputados, ...</autn:title></autn:hit><autn:hit>        <autn:reference>/.iwmnt/euskadi/main/r01_ehu_des/WORKAREA/wr01_ehu1/normativa/vg_consejosocial_reglamento_re/es_regla/adjuntos/LOU21dic2001.pdf</autn:reference>    <autn:section>20</autn:section>     <autn:weight>83.82</autn:weight>        <autn:links>GOBIERNO</autn:links>       <autn:database>gestion_euskadi_db</autn:database>   <autn:title>Page 1 463 El Pleno del Congreso de los Diputados, ...</autn:title></autn:hit><autn:hit>    <autn:reference>/.iwmnt/euskadi/main/r01_ehu_des/WORKAREA/wr01_ehu1/memoria/memoria_profesorado/es_mem_prof/adjuntos/Memoria_Academica_Curso_2004-05.pdf</autn:reference>       <autn:section>8</autn:section>  <autn:weight>82.29</autn:weight>        <autn:links>GOBIERNO</autn:links>   <autn:database>gestion_euskadi_db</autn:database>       <autn:title>Memoria 2004-2005</autn:title></autn:hit><autn:hit> <autn:reference>http://www.euskadi.ejiedes.eus/contenidos/contratacion/k282006/eu_k282006/adjuntos/PLEGU TEKNIKOA ERDERAZ.doc</autn:reference>  <autn:section>3</autn:section>  <autn:weight>80.89</autn:weight>        <autn:links>GOBIERNO</autn:links>       <autn:database>euskadi_db</autn:database>   <autn:title>Lehiaketa Publikoa, esparru sozioekonomiko pribatuko jarduera-eremuetan ohikoak diren euskarazko eta elebidun testu eta agiri-dokumentuen banku telematikoa sortzeko.</autn:title></autn:hit><autn:hit> <autn:reference>http://www.euskadi.ejiedes.eus/contenidos/contratacion/km_2006_080/eu_2006_080/adjuntos/PBT.DOC</autn:reference>    <autn:section>3</autn:section>      <autn:weight>80.89</autn:weight>        <autn:links>GOBIERNO</autn:links>       <autn:database>euskadi_db</autn:database>   <autn:title>Bilboko Bizkaia Plaza eraikinean segurtasun eta kontrol-sistemak eskuratu eta instalatzea</autn:title></autn:hit><autn:hit>     <autn:reference>http://www.euskadi.ejiedes.eus/contenidos/contratacion/13a_06_mejoracalidad_aire/eu_15035/adjuntos/tecnicas13a_06.doc</autn:reference>      <autn:section>4</autn:section>  <autn:weight>80.89</autn:weight>        <autn:links>GOBIERNO</autn:links>   <autn:database>euskadi_db</autn:database>       <autn:title>PLIEGO DE PRESCRIPCIONES T\u00c9CNICAS PARA LA ELABORACI\u00d3N DE PLANES DE ...</autn:title></autn:hit><autn:hit>        <autn:reference>http://www.euskadi.ejiedes.eus/contenidos/contratacion/13a_06_mejoracalidad_aire/es_15035/adjuntos/tecnicas13a_06.doc</autn:reference>      <autn:section>4</autn:section>  <autn:weight>80.89</autn:weight>    <autn:links>GOBIERNO</autn:links>       <autn:database>euskadi_db</autn:database>       <autn:title>PLIEGO DE PRESCRIPCIONES T\u00c9CNICAS PARA LA ELABORACI\u00d3N DE PLANES DE ...</autn:title></autn:hit><autn:hit>        <autn:reference>/.iwmnt/euskadi/main/r01_ehu_des/WORKAREA/wr01_ehu1/informacion/vg_consejosocial_presentacion_/es_presen/presen_orga.html</autn:reference>  <autn:section>0</autn:section>      <autn:weight>80.89</autn:weight>        <autn:links>GOBIERNO</autn:links>       <autn:database>gestion_euskadi_db</autn:database>   <autn:title>\u00d3RGANOS DE GOBIERNO RECTOR CONSEJO DE DIRECCI\u00d3N JUNTA DE GOBIERNO ...</autn:title></autn:hit><autn:warning>The language type provided has not been set in configuration, and so the default will have been used</autn:warning><autn:warning>At least one of the fields on which a combine operation has been requested does not exist</autn:warning></responsedata></autnresponse>";
                Properties props = new Properties();
                props.setProperty("contentsPageUrl", "/url de la pagina/");
                props.setProperty("language", "es");
                props.setProperty("queryText", "gobierno");
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                XMLTransformerHelper.applyXSLtoXML(new ByteArrayInputStream(xml.getBytes()), ResourcesLoader.getResourceFileAsStream(xslDecorator), props, out);
                R01FLog.to("r01f.test").info(new String(out.toByteArray()));
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to("r01f.test").info("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t1) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

