/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.xml.utils;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xml.utils.XMLParserHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLSerializerHelper {
    public static String getOuterXML(Node node, String outEncoding) throws TransformerException {
        return XMLSerializerHelper.getXML(node, outEncoding);
    }

    public static String getInnerXML(Node node, String outEncoding) throws TransformerException {
        StringBuffer innerXml = new StringBuffer();
        if (node.hasChildNodes()) {
            NodeList childNodes = node.getChildNodes();
            int i = childNodes.getLength();
            for (int c = 0; c < i; ++c) {
                innerXml.append(XMLSerializerHelper.getOuterXML(childNodes.item(c), outEncoding));
            }
            return innerXml.toString();
        }
        return "";
    }

    public static String getXML(Node node, String outEncoding) throws TransformerException {
        if (node == null) {
            return null;
        }
        try {
            TransformerFactory fac = TransformerFactory.newInstance();
            Transformer tf = fac.newTransformer();
            Properties tfProps = new Properties();
            if (outEncoding != null) {
                tfProps.setProperty("encoding", outEncoding);
            }
            tfProps.setProperty("indent", "yes");
            tf.setOutputProperties(tfProps);
            tf.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource src = new DOMSource(node);
            StringWriter w = new StringWriter();
            StreamResult rslt = new StreamResult(w);
            tf.transform(src, rslt);
            return w.toString();
        }
        catch (TransformerFactoryConfigurationError tfCfgEx) {
            throw new TransformerException(tfCfgEx);
        }
        catch (TransformerConfigurationException tfCfgEx) {
            throw new TransformerException(tfCfgEx);
        }
        catch (IllegalArgumentException illArgEx) {
            throw new TransformerException(illArgEx);
        }
    }

    public static void main(String[] args) {
        try {
            for (int i = 0; i < 1; ++i) {
                String xml = "<?xmlasd ><nodo><sub1 attr='1'><sub2><sub3><sub4><![CDATA[as<da<sa>sdf>dfsdfa]]></sub4></sub3>asdfasdf</sub2></sub1></nodo>";
                Document xmlDoc = XMLParserHelper.parseXML((InputStream)new ByteArrayInputStream(xml.getBytes()), null);
                R01FLog.to("r01f.test").info(XMLSerializerHelper.getXML(xmlDoc, null));
            }
        }
        catch (Exception ex) {
            R01FLog.to("r01f.test").info("Exception!!!" + ex);
        }
    }
}

