/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.xml.marshalling;

import com.ejie.r01f.xml.marshalling.ObjsFromXMLBuilder;
import com.ejie.r01f.xml.marshalling.XMLFromObjsBuilder;
import com.ejie.r01f.xml.marshalling.XOMap;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.xml.sax.SAXException;

public class XOMarshaller
implements Serializable {
    private static final long serialVersionUID = -683404380473220906L;
    XOMap _map;

    public XOMarshaller() {
    }

    public XOMarshaller(XOMap newMap) {
        this();
        this._map = newMap;
    }

    public XOMarshaller(String xmlMap) throws XOMarshallerException {
        this();
        if (xmlMap == null) {
            throw new IllegalArgumentException("El xml con el mapeo xml <> objetos es nulo");
        }
        try {
            this._map = new XOMap(xmlMap);
        }
        catch (SAXException saxEx) {
            throw new XOMarshallerException(saxEx.toString());
        }
    }

    public XOMarshaller(File mapFile) throws XOMarshallerException {
        if (mapFile == null) {
            throw new IllegalArgumentException("El fichero xml con el mapeo xml <> objetos es nulo");
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(mapFile);
            this._map = new XOMap(fis);
        }
        catch (FileNotFoundException fnfEx) {
            throw new XOMarshallerException("El fichero xml con el mapeo xml <> objetos no existe");
        }
        catch (SAXException saxEx) {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.out);
                }
            }
            throw new XOMarshallerException(saxEx.toString());
        }
    }

    public XOMarshaller(InputStream mapIs) throws XOMarshallerException {
        if (mapIs == null) {
            throw new IllegalArgumentException("El IS a la definici\u00f3n de la transformaci\u00f3n xml <> objetos es nulo");
        }
        try {
            this._map = new XOMap(mapIs);
        }
        catch (SAXException saxEx) {
            throw new XOMarshallerException(saxEx.toString());
        }
    }

    public Object unmarshall(String xml) throws XOMarshallerException {
        return this.getObject(xml);
    }

    public String marshall(Object obj) throws XOMarshallerException {
        return this.getXML(obj);
    }

    public String getXML(Object obj) throws XOMarshallerException {
        XMLFromObjsBuilder xmlBuilder = new XMLFromObjsBuilder(this._map);
        if (xmlBuilder != null) {
            return xmlBuilder.toXML(obj);
        }
        return "<?xml version='1.0' encoding='ISO-8859-1'?><error/>";
    }

    public Object getObject(String xml) throws XOMarshallerException {
        if (xml == null) {
            return null;
        }
        if (!this._isXMLHeaderDirectivePresent(xml)) {
            xml = "<?xml version='1.0' encoding='ISO-8859-1'?>" + xml;
        }
        return this.getObject(new ByteArrayInputStream(xml.getBytes()));
    }

    public Object getObject(File file) throws XOMarshallerException {
        if (file == null) {
            return null;
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            return this.getObject(fis);
        }
        catch (FileNotFoundException fnfEx) {
            throw new XOMarshallerException(fnfEx.toString());
        }
    }

    public Object getObject(InputStream is) throws XOMarshallerException {
        ObjsFromXMLBuilder objsBuilder = new ObjsFromXMLBuilder(this._map);
        if (objsBuilder != null) {
            return objsBuilder.getObject(is);
        }
        return null;
    }

    public XOMap getMap() {
        return this._map;
    }

    private boolean _isXMLHeaderDirectivePresent(String xml) {
        boolean headerPresent = false;
        if (xml.startsWith("<?xml version='1.0' encoding='ISO-8859-1'?>")) {
            headerPresent = true;
        } else if (xml.startsWith("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>")) {
            headerPresent = true;
        } else if (xml.startsWith("<?xml version=\"1.0\" encoding='UTF-8'?>")) {
            headerPresent = true;
        } else if (xml.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>")) {
            headerPresent = true;
        }
        return headerPresent;
    }
}

