/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.xml.marshalling;

import com.ejie.r01f.xml.marshalling.ClassMap;
import com.ejie.r01f.xml.marshalling.MemberMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XOMap
implements Serializable {
    private static final long serialVersionUID = 417007530672726223L;
    private String _encoding;
    private Map _objClasses;
    private Map _xmlClasses;
    public static final int DATATYPE_null = 0;
    public static final int DATATYPE_String = 1;
    public static final int DATATYPE_Integer = 2;
    public static final int DATATYPE_int = 3;
    public static final int DATATYPE_Long = 4;
    public static final int DATATYPE_long = 5;
    public static final int DATATYPE_Double = 6;
    public static final int DATATYPE_double = 7;
    public static final int DATATYPE_Float = 8;
    public static final int DATATYPE_float = 9;
    public static final int DATATYPE_Boolean = 10;
    public static final int DATATYPE_boolean = 11;
    public static final int DATATYPE_Date = 12;
    public static final int DATATYPE_SQLDate = 13;
    public static final int DATATYPE_Object = 14;
    public static final int DATATYPE_Collection = 15;
    public static final int DATATYPE_XML = 16;
    public static final String[] DATATYPES_DESCS = new String[]{"null", "String", "Integer", "int", "Long", "long", "Double", "double", "Float", "float", "Boolean", "boolean", "Date", "SQLDate", "Object", "Collection", "XML"};
    public static final int COLLECTION_NO_COLLECTION = -1;
    public static final int COLLECTION_ARRAY = 0;
    public static final int COLLECTION_HASHTABLE = 1;
    public static final int COLLECTION_HASHMAP = 2;
    public static final int COLLECTION_XMLMAP = 3;
    public static final int COLLECTION_STATEMAP = 4;
    public static final int COLLECTION_MAP = 5;
    public static final int COLLECTION_VECTOR = 6;
    public static final int COLLECTION_ARRAYLIST = 7;
    public static final int COLLECTION_LIST = 8;
    public static final int COLLECTION_LINKEDHASHMAP = 9;
    public static final String[] COLLECTION_DESCS = new String[]{"Array", "Hashtable", "HashMap", "XMLMap", "StateMap", "Map", "Vector", "ArrayList", "List", "LinkedHashMap"};
    public static final int RELATION_COMPOSITION = 0;
    public static final int RELATION_AGGREGATION = 1;
    public static final int RELATION_NO_RELATION = -1;
    public static final String[] RELATION_DESCS = new String[]{"composition", "aggregation"};

    public XOMap() {
    }

    public XOMap(InputStream is) throws SAXException {
        this();
        this.loadFromXML(is);
    }

    public XOMap(String inXMLStr) throws SAXException {
        this();
        this.loadFromXML(new ByteArrayInputStream(inXMLStr.getBytes()));
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String theEncoding) {
        this._encoding = theEncoding;
    }

    public void loadFromXML(InputStream is) throws SAXException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            XOMapLoader loader = new XOMapLoader();
            saxParser.parse(is, (DefaultHandler)loader);
            this._encoding = loader.encoding;
            this._objClasses = loader.loadedObjClasses;
            this._xmlClasses = loader.loadedXMLClasses;
        }
        catch (ParserConfigurationException pcEx) {
            throw new SAXException("Error en la configuraci\u00f3n del parser: " + pcEx.toString(), pcEx);
        }
        catch (IOException ioEx) {
            throw new SAXException("Error de IO " + ioEx.toString(), ioEx);
        }
    }

    public Collection getClasses() {
        if (this._objClasses == null) {
            return null;
        }
        return this._objClasses.values();
    }

    public ClassMap getClassFromXMLTag(String tagName) {
        if (this._xmlClasses == null) {
            return null;
        }
        return (ClassMap)this._xmlClasses.get(tagName);
    }

    public ClassMap getClassFromClassName(String className) {
        if (this._objClasses == null) {
            return null;
        }
        return (ClassMap)this._objClasses.get(className);
    }

    public void setClassMap(ClassMap newClassMap) {
        if (newClassMap != null && newClassMap.name != null && newClassMap._tagName != null) {
            if (this._objClasses == null) {
                this._objClasses = new HashMap();
            }
            this._objClasses.put(newClassMap.name, newClassMap);
            this._xmlClasses.put(newClassMap._tagName, newClassMap);
        }
    }

    public String toString() {
        if (this._objClasses != null) {
            StringBuffer sb = new StringBuffer();
            Iterator it = this._objClasses.values().iterator();
            while (it.hasNext()) {
                sb.append(((ClassMap)it.next()).toXML());
                sb.append("\r\n");
            }
            return sb.toString();
        }
        return "";
    }

    class XOMapLoader
    extends DefaultHandler {
        private static final String CLASSES = "classes";
        private static final String ENCODING = "encoding";
        private static final String CLASS = "class";
        private static final String PACKAGE = "package";
        private static final String USEACCESSORS = "useAccessors";
        private static final String OIDACCESSORMETHOD = "oidAccessorMethod";
        private static final String LOADER = "customMarshaller";
        private static final String NAME = "name";
        private static final String MEMBER = "member";
        private static final String DATATYPE = "dataType";
        private static final String COLLECTION = "collection";
        private static final String RELATION = "relation";
        private static final String CREATEMETHOD = "createMethod";
        private static final String ISOID = "isOID";
        private static final String FROMATTRIBUTE = "fromAttribute";
        private static final String FROMELEMENT = "fromElement";
        private static final String OFELEMENTS = "ofElements";
        private static final String ISCDATA = "isCDATA";
        private static final String ISTRANSIENT = "isTransient";
        public String encoding;
        public Map loadedObjClasses;
        public Map loadedXMLClasses;
        private Stack _tagStack = null;
        private Stack _objsStack = null;

        XOMapLoader() {
        }

        @Override
        public void startDocument() {
            this._tagStack = new Stack();
            this._objsStack = new Stack();
        }

        @Override
        public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
            String eName = lName;
            if ("".equals(eName)) {
                eName = qName;
            }
            this._tagStack.push(eName);
            if (eName.equalsIgnoreCase(CLASSES)) {
                this.loadedObjClasses = new HashMap();
                this.loadedXMLClasses = new HashMap();
                if (attrs != null && attrs.getValue(ENCODING) != null) {
                    this.encoding = attrs.getValue(ENCODING);
                }
            } else if (eName.equalsIgnoreCase(CLASS)) {
                ClassMap newClass = new ClassMap();
                Object _collection = null;
                if (attrs != null) {
                    if (attrs.getValue(NAME) != null) {
                        newClass.name = attrs.getValue(NAME);
                    }
                    if (attrs.getValue(PACKAGE) != null) {
                        newClass.packageName = attrs.getValue(PACKAGE);
                    }
                    if (attrs.getValue(FROMELEMENT) != null) {
                        newClass._tagName = attrs.getValue(FROMELEMENT);
                    }
                    if (attrs.getValue(USEACCESSORS) != null) {
                        boolean bl = newClass.useAccessors = attrs.getValue(USEACCESSORS).equalsIgnoreCase("true");
                    }
                    if (attrs.getValue(OIDACCESSORMETHOD) != null) {
                        newClass.oidAccessorMethod = attrs.getValue(OIDACCESSORMETHOD);
                    }
                }
                this._objsStack.push(newClass);
            } else if (eName.equalsIgnoreCase(MEMBER)) {
                ClassMap currClass;
                String _name = null;
                String _dataType = null;
                String _collection = null;
                String _relation = null;
                Object _association = null;
                Object _getMethod = null;
                Object _setMethod = null;
                String _createMethod = null;
                String _isOID = null;
                String _isTransient = null;
                Object _compare = null;
                boolean _isXMLAttribute = false;
                String _isCDATA = null;
                String _xmlSourceTag = null;
                MemberMap newMember = new MemberMap();
                if (attrs != null) {
                    int i;
                    _name = attrs.getValue(NAME);
                    if (_name != null) {
                        newMember.name = _name;
                    }
                    if ((_dataType = attrs.getValue(DATATYPE)) != null) {
                        int i2;
                        _dataType = _dataType.trim();
                        boolean dataTypeFound = false;
                        for (i2 = 0; i2 < DATATYPES_DESCS.length; ++i2) {
                            if (DATATYPES_DESCS[i2].equals(_dataType)) {
                                newMember.dataType = i2;
                                newMember.dataTypeName = DATATYPES_DESCS[i2];
                                dataTypeFound = true;
                                break;
                            }
                            if (dataTypeFound) continue;
                            if (_dataType.startsWith(DATATYPES_DESCS[12])) {
                                newMember.dataType = 12;
                                if (!this._checkDateFormat(_dataType)) {
                                    throw new SAXException("Los tipos Date se definen como Date(format), donde format es el formato de la fecha, por ejemplo: dd/MM/yyyy [HH:mm:ss:SSS] o ddMMyy");
                                }
                                newMember.dataTypeName = _dataType;
                                dataTypeFound = true;
                                break;
                            }
                            if (!_dataType.startsWith(DATATYPES_DESCS[13])) continue;
                            newMember.dataType = 13;
                            if (!this._checkDateFormat(_dataType)) {
                                throw new SAXException("Los tipos SQLDate se definen como SQLDate(format), donde format es el formato de la fecha, por ejemplo: dd/MM/yyyy [HH:mm:ss:SSS] o ddMMyy");
                            }
                            newMember.dataTypeName = _dataType;
                            dataTypeFound = true;
                            break;
                        }
                        if (!dataTypeFound) {
                            for (i2 = 0; i2 < COLLECTION_DESCS.length; ++i2) {
                                if (!COLLECTION_DESCS[i2].equals(_dataType)) continue;
                                newMember.dataType = 15;
                                newMember.collection = i2;
                                newMember.collectionName = COLLECTION_DESCS[i2];
                                _dataType = DATATYPES_DESCS[15];
                                dataTypeFound = true;
                                break;
                            }
                        }
                        if (!dataTypeFound) {
                            newMember.dataType = 14;
                            newMember.dataTypeName = _dataType;
                        }
                    }
                    if ((_collection = attrs.getValue(COLLECTION)) != null) {
                        for (i = 0; i < COLLECTION_DESCS.length; ++i) {
                            if (!COLLECTION_DESCS[i].equals(_collection)) continue;
                            newMember.collection = i;
                            newMember.collectionName = COLLECTION_DESCS[i];
                            break;
                        }
                        if (newMember.collection == -1) {
                            throw new SAXException("Error en el documento de mapeo: El tipo de colecci\u00f3n '" + _collection + "' no esta soportado");
                        }
                    }
                    if ((_relation = attrs.getValue(RELATION)) != null) {
                        for (i = 0; i < RELATION_DESCS.length; ++i) {
                            if (!RELATION_DESCS[i].equals(_relation)) continue;
                            newMember.relation = i;
                            newMember.relationName = RELATION_DESCS[i];
                            break;
                        }
                        if (newMember.relation == -1) {
                            throw new SAXException("Error en el documento de mapeo: El tipo de relacion '" + _relation + "' no esta soportado");
                        }
                    }
                    if ((_createMethod = attrs.getValue(CREATEMETHOD)) != null) {
                        newMember.createMethod = _createMethod;
                    }
                    newMember.isTransient = (_isTransient = attrs.getValue(ISTRANSIENT)) != null ? _isTransient.equals("true") : false;
                    _isOID = attrs.getValue(ISOID);
                    newMember.isOID = _isOID != null ? _isOID.equals("true") : false;
                    _xmlSourceTag = attrs.getValue(FROMATTRIBUTE);
                    if (_xmlSourceTag != null) {
                        _isXMLAttribute = true;
                    } else {
                        _xmlSourceTag = attrs.getValue(FROMELEMENT);
                        if (_xmlSourceTag != null) {
                            _isXMLAttribute = false;
                        }
                    }
                    if (!_isXMLAttribute && (_isCDATA = attrs.getValue(ISCDATA)) != null) {
                        if (_isCDATA.equals("true")) {
                            newMember.isCDATA = true;
                        } else if (_isCDATA.equals("false")) {
                            newMember.isCDATA = false;
                        }
                    }
                    if (newMember.collection == 0 || newMember.collection == 7 || newMember.collection == 6 || newMember.collection == 8) {
                        newMember.tagNameOfCollectionElement = attrs.getValue(OFELEMENTS);
                    }
                    if (_isXMLAttribute && newMember.collection != -1) {
                        throw new SAXException("Si un miembro se mapea como atributo NO puede ser una coleccion");
                    }
                }
                newMember.declaringClassMap = currClass = (ClassMap)this._objsStack.peek();
                if (currClass.members == null) {
                    currClass.members = new HashMap<String, MemberMap>();
                    currClass._xmlAttrMembers = new HashMap<String, MemberMap>();
                    currClass._xmlElemMembers = new HashMap<String, MemberMap>();
                }
                currClass.members.put(newMember.name, newMember);
                if (_isXMLAttribute) {
                    if (currClass._xmlAttrMembers.put(_xmlSourceTag, newMember) != null) {
                        throw new SAXException("El miembro tipo atributo " + _xmlSourceTag + " esta duplicado en la clase " + currClass.name);
                    }
                } else if (currClass._xmlElemMembers.put(_xmlSourceTag, newMember) != null) {
                    throw new SAXException("El miembro tipo elemento " + _xmlSourceTag + " esta duplicado en la clase " + currClass.name);
                }
            } else {
                throw new SAXException("Error en la configuracion del documento de mapeo: Hay un elemento que no es 'CLASS' o 'MEMBER'");
            }
        }

        @Override
        public void characters(char[] buf, int offset, int len) {
        }

        @Override
        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            String eName = sName;
            if ("".equals(eName)) {
                eName = qName;
            }
            this._tagStack.pop();
            if (eName.equalsIgnoreCase(CLASS)) {
                ClassMap currClass = (ClassMap)this._objsStack.pop();
                if (this.loadedObjClasses.put(currClass.name, currClass) != null) {
                    throw new SAXException("La clase " + currClass.name + " est\u00e1 duplicada en el documento de mapeo, revisalo");
                }
                if (this.loadedXMLClasses.put(currClass._tagName, currClass) != null) {
                    throw new SAXException("El tag en el cual se define la clase " + currClass.name + "(" + currClass._tagName + "), tambi\u00e9n define otra clase, revisa el documento de mapeo");
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
            this._tagStack = null;
            for (ClassMap currClass : this.loadedObjClasses.values()) {
                if (currClass.members == null) continue;
                for (MemberMap currMember : currClass.members.values()) {
                    if (currMember.dataType != 14) continue;
                    currMember.classMap = (ClassMap)this.loadedObjClasses.get(currMember.dataTypeName);
                    if (currMember.dataTypeName.equalsIgnoreCase(DATATYPES_DESCS[14]) || currMember.classMap != null) continue;
                    throw new SAXException("No se ha definido la clase " + currMember.dataTypeName + " en el documento de mapeo. El miembro " + currMember.name + " de la clase " + currClass.name + " es de este tipo. Revisa el documento de mapeo");
                }
            }
        }

        private boolean _checkDateFormat(String dateDef) {
            int p1 = dateDef.indexOf("(");
            int p2 = dateDef.indexOf(")");
            return p1 >= 0 && p2 >= 0 && p1 <= p2 && p2 == dateDef.length() - 1;
        }
    }
}

