/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.xml.marshalling;

import com.ejie.r01f.file.ResourcesLoader;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xml.marshalling.TestObj;
import com.ejie.r01f.xml.marshalling.XOMap;
import com.ejie.r01f.xml.marshalling.XOMarshaller;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;

public class XOManager {
    private static Map _marshallers = null;

    public static XOMarshaller getInstance(String mapFileName) throws XOMarshallerException {
        XOMarshaller outMarshaller = null;
        if (mapFileName == null) {
            throw new XOMarshallerException("El nombre del fichero de mapeo suministrado es nulo, no se puede obtener una instancia...");
        }
        if (_marshallers != null) {
            outMarshaller = (XOMarshaller)_marshallers.get(mapFileName);
        } else {
            _marshallers = new Hashtable();
        }
        if (outMarshaller == null) {
            try {
                InputStream mapFileIS = ResourcesLoader.getResourceFileAsStream(mapFileName);
                outMarshaller = new XOMarshaller(mapFileIS);
                _marshallers.put(mapFileName, outMarshaller);
            }
            catch (FileNotFoundException fnfEx) {
                throw new XOMarshallerException("NO se encuentra el fichero de mapeo xml<->objetos en la ruta " + mapFileName);
            }
        }
        return outMarshaller;
    }

    public static XOMap getXOMap(String mapFileName) throws XOMarshallerException {
        XOMarshaller xoMarshaller = XOManager.getInstance(mapFileName);
        return xoMarshaller.getMap();
    }

    public static void reset() {
        _marshallers = null;
    }

    public static Object getObject(String mapFileName, String objectXML) throws XOMarshallerException {
        return XOManager.getInstance(mapFileName).getObject(objectXML);
    }

    public static Object getObject(String mapFileName, InputStream objectXML) throws XOMarshallerException {
        return XOManager.getInstance(mapFileName).getObject(objectXML);
    }

    public static Object getObject(InputStream mapIS, InputStream objectXML) throws XOMarshallerException {
        XOMarshaller marshaller = new XOMarshaller(mapIS);
        return marshaller.getObject(objectXML);
    }

    public static Object getObject(InputStream mapIS, String objectXML) throws XOMarshallerException {
        XOMarshaller marshaller = new XOMarshaller(mapIS);
        return marshaller.getObject(objectXML);
    }

    public static Object getObject(XOMarshaller marshaller, InputStream objectXML) throws XOMarshallerException {
        return marshaller.getObject(objectXML);
    }

    public static Object getObject(XOMarshaller marshaller, String objectXML) throws XOMarshallerException {
        return marshaller.getObject(objectXML);
    }

    public static String getXML(String mapFileName, Object obj) throws XOMarshallerException {
        return XOManager.getInstance(mapFileName).getXML(obj);
    }

    public static String getXML(XOMarshaller marshaller, Object obj) throws XOMarshallerException {
        return marshaller.getXML(obj);
    }

    public static String getXMLIgnoringExceptions(String mapFileName, Object obj) {
        try {
            return XOManager.getXML(mapFileName, obj);
        }
        catch (XOMarshallerException ignore) {
            ignore.printStackTrace(System.out);
            return "";
        }
    }

    public static void main(String[] args) {
        try {
            String mapFileName = "d:/eAdmin/aplic/r01f/html/datos/r01fTestXOMappingFile.xml";
            TestObj testObj = new TestObj();
            testObj.member1 = "Hola";
            testObj.member2 = 1000L;
            testObj.member3 = new String[]{"1", "2", "3"};
            testObj.member4 = "<properties><value>1</value><value>2</value></properties>";
            long t1 = System.currentTimeMillis();
            int testTimes = 1;
            for (int times = 0; times < testTimes; ++times) {
                String xml = XOManager.getXML(mapFileName, (Object)testObj);
                R01FLog.to("r01f.test").info(xml);
                testObj = (TestObj)XOManager.getObject(mapFileName, xml);
                R01FLog.to("r01f.test").info(testObj.member1);
                R01FLog.to("r01f.test").info(Long.toString(testObj.member2));
                R01FLog.to("r01f.test").info(testObj.member3.toString());
                R01FLog.to("r01f.test").info(testObj.member3[1].toString());
                R01FLog.to("r01f.test").info(testObj.member4);
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to("r01f.test").info("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t1) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

