/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.xml.marshalling;

import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.xml.marshalling.ClassMap;
import com.ejie.r01f.xml.marshalling.MemberMap;
import com.ejie.r01f.xml.marshalling.XOMap;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlbuilder.XMLNode;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

class XMLFromObjsBuilder {
    private XOMap _map;

    public XMLFromObjsBuilder() {
    }

    public XMLFromObjsBuilder(XOMap map) {
        this();
        this._map = map;
    }

    public XMLFromObjsBuilder(InputStream mapIS) throws SAXException {
        this();
        if (mapIS != null) {
            XOMap orW = new XOMap();
            orW.loadFromXML(mapIS);
            this._map = orW;
        }
    }

    public void setORMap(XOMap map) {
        this._map = map;
    }

    public XOMap getORMap() {
        return this._map;
    }

    public String toXML(Object obj) throws XOMarshallerException {
        if (ReflectionUtils.isArray(obj.getClass())) {
            return this._generateXMLForArrayObject(null, (Object[])obj, null).toString();
        }
        ClassMap objClassDef = this._map.getClassFromClassName(this._getClassName(obj.getClass().getName()));
        return this._generateXML(null, obj, objClassDef).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private XMLNode _generateXML(String inTagName, Object inObj, ClassMap inObjClassDef) throws XOMarshallerException {
        if (inObjClassDef == null) {
            throw new XOMarshallerException("El objeto de mapeo no es valido \u00bfes correcto el fichero de mapeo?");
        }
        XMLNode objNode = new XMLNode();
        MemberMap member = null;
        String memberName = null;
        Object memberValue = null;
        try {
            if (inTagName == null) {
                objNode.setNodeName(inObjClassDef._tagName);
            } else {
                objNode.setNodeName(inTagName);
            }
            for (Map.Entry<String, MemberMap> me : inObjClassDef._xmlAttrMembers.entrySet()) {
                String attrName = me.getKey();
                member = me.getValue();
                memberName = member.name;
                memberValue = ReflectionUtils.getMemberValue(inObj, memberName, inObjClassDef.useAccessors);
                if (memberValue == null) continue;
                if (memberValue instanceof Integer) {
                    objNode.addAttribute(attrName, ((Integer)memberValue).toString());
                    continue;
                }
                if (memberValue instanceof Long) {
                    objNode.addAttribute(attrName, ((Long)memberValue).toString());
                    continue;
                }
                if (memberValue instanceof Double) {
                    objNode.addAttribute(attrName, ((Double)memberValue).toString());
                    continue;
                }
                if (memberValue instanceof Float) {
                    objNode.addAttribute(attrName, ((Float)memberValue).toString());
                    continue;
                }
                if (memberValue instanceof Boolean) {
                    objNode.addAttribute(attrName, ((Boolean)memberValue).toString());
                    continue;
                }
                if (memberValue instanceof Date || memberValue instanceof java.sql.Date) {
                    int p1 = member.dataTypeName.indexOf("(");
                    int p2 = member.dataTypeName.indexOf(")");
                    String dateFormat = member.dataTypeName.substring(p1 + 1, p2);
                    objNode.addAttribute(attrName, DateUtils.getDateFormated((Date)memberValue, dateFormat));
                    continue;
                }
                objNode.addAttribute(attrName, (String)memberValue);
            }
            for (Map.Entry<String, MemberMap> me : inObjClassDef._xmlElemMembers.entrySet()) {
                String tagName;
                XMLNode listNode;
                String elemName = me.getKey();
                member = me.getValue();
                memberName = member.name;
                memberValue = ReflectionUtils.getMemberValue(inObj, memberName, inObjClassDef.useAccessors);
                if (memberValue == null) continue;
                if (memberValue.getClass().isArray()) {
                    Object[] array = (Object[])memberValue;
                    if (array.length <= 0) continue;
                    listNode = new XMLNode(elemName);
                    for (int i = 0; i < array.length; ++i) {
                        Object currObj = array[i];
                        if (currObj == null) continue;
                        XMLNode childNode = null;
                        ClassMap currObjClassDef = this._map.getClassFromClassName(this._getClassName(currObj.getClass().getName()));
                        if (currObjClassDef == null) {
                            if (!(currObj instanceof String)) throw new XOMarshallerException("El elemento del array " + memberName + " no es del tipo esperado.");
                            tagName = member.tagNameOfCollectionElement != null ? member.tagNameOfCollectionElement : "arrayElement";
                            childNode = new XMLNode(tagName, this._formatMemberValue(currObj, member), false);
                        } else {
                            childNode = this._generateXML(null, currObj, currObjClassDef);
                        }
                        if (childNode.isEmpty()) continue;
                        listNode.addSubNode(childNode);
                    }
                    if (listNode.isEmpty()) continue;
                    objNode.addSubNode(listNode);
                    continue;
                }
                if (memberValue instanceof List) {
                    List list = (List)memberValue;
                    if (list.size() <= 0) continue;
                    listNode = new XMLNode(elemName);
                    for (Object currObj : list) {
                        if (currObj == null) continue;
                        ClassMap currObjClassDef = this._map.getClassFromClassName(this._getClassName(currObj.getClass().getName()));
                        XMLNode childNode = null;
                        if (currObjClassDef == null) {
                            if (!(currObj instanceof String)) throw new XOMarshallerException("El elemento de la lista " + memberName + " no es del tipo esperado.");
                            tagName = member.tagNameOfCollectionElement != null ? member.tagNameOfCollectionElement : "listElement";
                            childNode = new XMLNode(tagName, this._formatMemberValue(currObj, member), member.isCDATA);
                        } else {
                            childNode = this._generateXML(null, currObj, currObjClassDef);
                        }
                        if (childNode.isEmpty()) continue;
                        listNode.addSubNode(childNode);
                    }
                    if (listNode.isEmpty()) continue;
                    objNode.addSubNode(listNode);
                    continue;
                }
                if (memberValue instanceof Map) {
                    Map map = (Map)memberValue;
                    if (map.size() <= 0) continue;
                    XMLNode mapNode = new XMLNode(elemName);
                    for (Map.Entry me2 : map.entrySet()) {
                        Object currKey = me2.getKey();
                        Object currObj = me2.getValue();
                        if (currObj == null) continue;
                        XMLNode childNode = null;
                        ClassMap currObjClassDef = this._map.getClassFromClassName(this._getClassName(currObj.getClass().getName()));
                        childNode = currObjClassDef == null ? new XMLNode((String)currKey, currObj.toString(), member.isCDATA) : this._generateXML(null, currObj, currObjClassDef);
                        if (childNode.isEmpty()) continue;
                        mapNode.addSubNode(childNode);
                    }
                    if (mapNode.isEmpty()) continue;
                    objNode.addSubNode(mapNode);
                    continue;
                }
                ClassMap memberObjClassDef = member.classMap;
                if (memberObjClassDef != null) {
                    XMLNode childNode = this._generateXML(elemName, memberValue, memberObjClassDef);
                    if (childNode.isEmpty()) continue;
                    objNode.addSubNode(childNode);
                    continue;
                }
                if (elemName.equalsIgnoreCase(inObjClassDef._tagName)) {
                    if (member.isCDATA) {
                        objNode.setCDATA(true);
                    }
                    objNode.setNodeValue(this._formatMemberValue(memberValue, member));
                    continue;
                }
                objNode.addSubNode(new XMLNode(elemName, this._formatMemberValue(memberValue, member), member.isCDATA));
            }
            return objNode;
        }
        catch (ReflectionException refEx) {
            throw new XOMarshallerException("Error al acceder al valor de la variable miembro '" + memberName + "' de la clase '" + inObjClassDef.name + "'", (Exception)refEx);
        }
    }

    private XMLNode _generateXMLForArrayObject(String inTagName, Object[] inObj, ClassMap inObjClassDef) throws XOMarshallerException {
        XMLNode objNode = new XMLNode();
        objNode.setNodeName("array");
        objNode.addAttribute("dataType", inObj[0].getClass().getName());
        XMLNode elementNode = new XMLNode("element");
        Object memberValue = null;
        for (int i = 0; i < inObj.length; ++i) {
            memberValue = inObj[i];
            if (memberValue == null) continue;
            if (memberValue instanceof Integer) {
                elementNode.setNodeValue(((Integer)memberValue).toString());
            } else if (memberValue instanceof Long) {
                elementNode.setNodeValue(((Long)memberValue).toString());
            } else if (memberValue instanceof Double) {
                elementNode.setNodeValue(((Double)memberValue).toString());
            } else if (memberValue instanceof Float) {
                elementNode.setNodeValue(((Float)memberValue).toString());
            } else if (memberValue instanceof Boolean) {
                elementNode.setNodeValue(((Boolean)memberValue).toString());
            } else if (memberValue instanceof String) {
                elementNode.setNodeValue(memberValue.toString());
            } else {
                ClassMap objClassDef = this._map.getClassFromClassName(this._getClassName(inObj[0].getClass().getName()));
                XMLNode subNode = this._generateXML(null, memberValue, objClassDef);
                elementNode.addSubNode(subNode);
            }
            objNode.addSubNode(elementNode);
        }
        return objNode;
    }

    private String _getClassName(String fullClassName) {
        int pos = fullClassName.lastIndexOf(46);
        return fullClassName.substring(pos + 1);
    }

    private String _formatMemberValue(Object memberValue, MemberMap member) {
        String val = null;
        if (memberValue instanceof Integer) {
            val = ((Integer)memberValue).toString();
        } else if (memberValue instanceof Long) {
            val = ((Long)memberValue).toString();
        } else if (memberValue instanceof Double) {
            val = ((Double)memberValue).toString();
        } else if (memberValue instanceof Float) {
            val = ((Float)memberValue).toString();
        } else if (memberValue instanceof Boolean) {
            val = ((Boolean)memberValue).toString();
        } else if (memberValue instanceof Date || memberValue instanceof java.sql.Date) {
            String dateFormat = "dd/MM/yyyy";
            if (member != null) {
                int p1 = member.dataTypeName.indexOf("(");
                int p2 = member.dataTypeName.indexOf(")");
                if (p1 > 0 && p2 > p1) {
                    dateFormat = member.dataTypeName.substring(p1 + 1, p2);
                }
            }
            val = DateUtils.getDateFormated((Date)memberValue, dateFormat);
        } else {
            val = (String)memberValue;
        }
        return val;
    }
}

