/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.xml.marshalling;

import com.ejie.r01f.xml.marshalling.MemberMap;
import com.ejie.r01f.xmlbuilder.XMLNode;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ClassMap
implements Serializable {
    private static final long serialVersionUID = -1645163286393938376L;
    public String name;
    public String packageName;
    public boolean useAccessors;
    public Map<String, MemberMap> members;
    public String oidAccessorMethod;
    String _tagName;
    Map<String, MemberMap> _xmlAttrMembers;
    Map<String, MemberMap> _xmlElemMembers;

    public ClassMap() {
    }

    public ClassMap(String newPackageName) {
        this();
        this.packageName = newPackageName;
    }

    public MemberMap getMemberFromXMLAttribute(String xmlAttrName) {
        if (this._xmlAttrMembers == null) {
            return null;
        }
        return this._xmlAttrMembers.get(xmlAttrName);
    }

    public MemberMap getMemberFromXMLElement(String xmlElemName) {
        if (this._xmlElemMembers == null) {
            return null;
        }
        return this._xmlElemMembers.get(xmlElemName);
    }

    public MemberMap getOIDMember() {
        if (this.members == null) {
            return null;
        }
        for (MemberMap currMember : this.members.values()) {
            if (!currMember.isOID) continue;
            return currMember;
        }
        return null;
    }

    public String getOidAccessorMethodName() {
        return this.oidAccessorMethod;
    }

    public MemberMap getMember(String memberName) {
        if (this.members == null) {
            return null;
        }
        return this.members.get(memberName);
    }

    public void addElementMember(MemberMap newMember, String memberTagName) {
        if (newMember != null && newMember.name != null && memberTagName != null) {
            if (this._xmlElemMembers == null) {
                this._xmlElemMembers = new HashMap<String, MemberMap>();
            }
            if (this.members == null) {
                this.members = new HashMap<String, MemberMap>();
            }
            this.members.put(newMember.name, newMember);
            this._xmlElemMembers.put(memberTagName, newMember);
        }
    }

    public void addAttrtMember(MemberMap newMember, String memberTagName) {
        if (newMember != null && newMember.name != null && memberTagName != null) {
            if (this._xmlAttrMembers == null) {
                this._xmlAttrMembers = new HashMap<String, MemberMap>();
            }
            if (this.members == null) {
                this.members = new HashMap<String, MemberMap>();
            }
            this.members.put(newMember.name, newMember);
            this._xmlAttrMembers.put(memberTagName, newMember);
        }
    }

    public String toXML() {
        XMLNode memberNode;
        MemberMap currMember;
        XMLNode classNode = new XMLNode("class");
        classNode.addAttribute("name", this.name);
        classNode.addAttribute("package", this.packageName);
        classNode.addAttribute("fromElement", this._tagName);
        classNode.addAttribute("useAccessors", this.useAccessors ? "true" : "false");
        classNode.addAttribute("oidAccessorMethod", this.oidAccessorMethod == null ? "null" : this.oidAccessorMethod);
        if (this._xmlAttrMembers != null) {
            for (Map.Entry<String, MemberMap> me : this._xmlAttrMembers.entrySet()) {
                currMember = me.getValue();
                String currAttrName = me.getKey();
                memberNode = new XMLNode("member");
                memberNode.addAttribute("name", currMember.name);
                memberNode.addAttribute("dataType", currMember.dataTypeName);
                if (currMember.isOID) {
                    memberNode.addAttribute("isOID", "true");
                }
                memberNode.addAttribute("fromAttribute", currAttrName);
                classNode.addSubNode(memberNode);
            }
        }
        if (this._xmlElemMembers != null) {
            for (Map.Entry<String, MemberMap> me : this._xmlElemMembers.entrySet()) {
                currMember = me.getValue();
                String currElemName = me.getKey();
                memberNode = new XMLNode("member");
                memberNode.addAttribute("name", currMember.name);
                memberNode.addAttribute("dataType", currMember.dataTypeName);
                memberNode.addAttribute("collection", currMember.collectionName);
                if (currMember.isOID) {
                    memberNode.addAttribute("isOID", "true");
                }
                memberNode.addAttribute("fromElement", currElemName);
                classNode.addSubNode(memberNode);
            }
        }
        return classNode.toString();
    }
}

