/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.xlnets;

import com.ejie.r01f.util.StringBilingue;
import com.ejie.r01f.xlnets.R01FBaseXLNetsObject;
import com.ejie.r01f.xlnets.R01FXLNetsAutorizacion;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class R01FXLNetsItemSeguridad
extends R01FBaseXLNetsObject {
    private static final String UID = "parametro[@id='n38uidobjseguridad']/valor[1]/text()";
    private static final String CN = "parametro[@id='cn']/valor[1]/text()";
    private static final String PATH_EJECUTABLE = "parametro[@id='n38path-ejecutable']/valor[1]/text()";
    private static final String DESCRIPCION_ES = "parametro[@id='n38cadescripcion']/valor[1]/text()";
    private static final String DESCRIPCION_EU = "parametro[@id='n38eudescripcion']/valor[1]/text()";
    private static final String URL = "parametro[@id='url']/valor[1]/text()";
    private static final String TIPO = "parametro[@id='n38tipo']/valor[1]/text()";
    private static final String SUBTIPO = "parametro[@id='n38subtipo']/valor[1]/text()";
    private static final String AUTORIZACIONES = "elemento[@subtipo='n38autorizacion']";
    private static final String ACCIONES = "parametro[@id='n38acciones']/valor";
    private static final String PERFILES = "parametro[@id='n38perfiles']/valor";

    public R01FXLNetsItemSeguridad(Node itemSeguridadNode) {
        super(itemSeguridadNode);
    }

    public String getUID() {
        return this._extractValue(UID);
    }

    public String getCN() {
        return this._extractValue(CN);
    }

    public String getPathEjecutable() {
        return this._extractValue(PATH_EJECUTABLE);
    }

    public StringBilingue getDescripcion() {
        return new StringBilingue(this._extractValue(DESCRIPCION_ES), this._extractValue(DESCRIPCION_EU));
    }

    public String getTipo() {
        return this._extractValue(TIPO);
    }

    public String getSubTipo() {
        return this._extractValue(SUBTIPO);
    }

    public String[] getAcciones() {
        return this._extractMultipleValue(ACCIONES);
    }

    public String[] getPerfiles() {
        return this._extractMultipleValue(PERFILES);
    }

    public R01FXLNetsAutorizacion[] getAutorizaciones() {
        R01FXLNetsAutorizacion[] outAuths = null;
        NodeList nl = this._executeXPathForNodeList(AUTORIZACIONES);
        if (nl != null) {
            outAuths = new R01FXLNetsAutorizacion[nl.getLength()];
            for (int i = 0; i < nl.getLength(); ++i) {
                outAuths[i] = new R01FXLNetsAutorizacion(nl.item(i));
            }
        }
        return outAuths;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("");
        sb.append("UID=" + this.getUID() + "\r\n");
        sb.append("CN=" + this.getCN() + "\r\n");
        sb.append("Descripcion=" + this.getDescripcion() + "\r\n");
        sb.append("Tipo=" + this.getTipo() + "\r\n");
        sb.append("SubTipo=" + this.getSubTipo() + "\r\n");
        sb.append("Path-Ejecutable=" + this.getPathEjecutable() + "\r\n");
        sb.append("Acciones=");
        String[] acciones = this.getAcciones();
        if (acciones != null) {
            for (int i = 0; i < acciones.length; ++i) {
                sb.append("[" + acciones[i] + "]");
            }
        }
        sb.append("\r\n");
        sb.append("Perfiles=");
        String[] perfiles = this.getPerfiles();
        if (perfiles != null) {
            for (int i = 0; i < perfiles.length; ++i) {
                sb.append("[" + perfiles[i] + "]");
            }
        }
        sb.append("\r\n");
        sb.append("*** Autorizaciones ***\r\n");
        R01FXLNetsAutorizacion[] autorizaciones = this.getAutorizaciones();
        if (autorizaciones != null) {
            for (int i = 0; i < autorizaciones.length; ++i) {
                sb.append(autorizaciones[i]);
            }
        }
        sb.append("\r\n");
        return sb.toString();
    }
}

