/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.util.timing;

import com.ejie.r01f.log.R01FLog;

public final class R01FStopWatch {
    private long fStart;
    private long fStop;
    private boolean fIsRunning;
    private boolean fHasBeenUsedOnce;

    public void start() {
        if (this.fIsRunning) {
            throw new IllegalStateException("Must stop before calling start again.");
        }
        this.fStart = System.currentTimeMillis();
        this.fStop = 0L;
        this.fIsRunning = true;
        this.fHasBeenUsedOnce = true;
    }

    public void stop() {
        if (!this.fIsRunning) {
            throw new IllegalStateException("Cannot stop if not currently running.");
        }
        this.fStop = System.currentTimeMillis();
        this.fIsRunning = false;
    }

    public String toString() {
        this.validateIsReadable();
        StringBuffer result = new StringBuffer();
        result.append(this.fStop - this.fStart);
        result.append(" ms");
        return result.toString();
    }

    public long toValue() {
        this.validateIsReadable();
        return this.fStop - this.fStart;
    }

    private void validateIsReadable() {
        if (this.fIsRunning) {
            String message = "Cannot read a stopwatch which is still running.";
            throw new IllegalStateException(message);
        }
        if (!this.fHasBeenUsedOnce) {
            String message = "Cannot read a stopwatch which has never been started.";
            throw new IllegalStateException(message);
        }
    }

    public static void main(String[] arguments) {
        R01FStopWatch stopwatch = new R01FStopWatch();
        stopwatch.start();
        StringBuffer messageOne = new StringBuffer();
        int numIterations = 5000;
        for (int idx = 0; idx < numIterations; ++idx) {
            messageOne.append("blah");
        }
        stopwatch.stop();
        R01FLog.to("r01f.test").info("The reading for String Buffer is: " + stopwatch);
        stopwatch.start();
        String messageTwo = null;
        for (int idx = 0; idx < numIterations; ++idx) {
            messageTwo = messageTwo + "blah";
        }
        stopwatch.stop();
        if (stopwatch.toValue() > 5L) {
            R01FLog.to("r01f.test").info("The reading is high: " + stopwatch);
        } else {
            R01FLog.to("r01f.test").info("The reading is low: " + stopwatch);
        }
    }
}

