/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.util.multimedia;

import com.ejie.r01f.log.R01FLog;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;

public class FLVHeader {
    private String duration;
    private double width;
    private double height;
    private double audioDataRate;
    private double videoDataRate;
    private double fileSize;
    private String createdDate;
    private String mimeType;
    private double frameRate;

    public boolean parseHeader(InputStream is) {
        boolean inputIsSWF = false;
        inputIsSWF = this.doParseHeader(is);
        return inputIsSWF;
    }

    private boolean doParseHeader(InputStream fis) {
        byte[] temp = new byte[128];
        try {
            fis.read(temp);
            double durationTemp = this.getDouble(temp, "duration");
            DecimalFormat f = new DecimalFormat("00");
            this.setDuration(f.format((int)durationTemp / 60) + ":" + f.format((int)durationTemp % 60));
            this.setWidth(this.getDouble(temp, "width"));
            this.setHeight(this.getDouble(temp, "height"));
            this.setAudioDataRate(this.getDouble(temp, "audiodatarate"));
            this.setVideoDataRate(this.getDouble(temp, "videodatarate"));
            this.setFileSize(this.getDouble(temp, "filesize"));
            this.setCreatedDate(this.getString(temp, "creationdate"));
            this.setMimeType(this.getString(temp, "mimetype"));
            this.setFrameRate(this.getDouble(temp, "framerate"));
        }
        catch (IOException ex) {
            R01FLog.to("r01f.util").severe("Error al leer el InputStream del fichero *.flv " + ex.getMessage());
            return false;
        }
        catch (Exception ex) {
            R01FLog.to("r01f.util").severe("Error al extraer los datos de la cabecera del fichero *.flv " + ex.getMessage());
            return false;
        }
        return true;
    }

    private double getDouble(byte[] bytes, String property) {
        String metaData = new String(bytes);
        int offset = metaData.indexOf(property);
        if (offset != -1) {
            return ByteBuffer.wrap(this.getBytes(bytes, offset + property.length() + 1, 8)).getDouble();
        }
        return -1.0;
    }

    private String getString(byte[] bytes, String property) {
        String metaData = new String(bytes);
        int offset = metaData.indexOf(property);
        if (offset != -1) {
            return new String(this.getBytes(bytes, offset + property.length() + 3, 24));
        }
        return null;
    }

    private byte[] getBytes(byte[] bytes, int offset, int length) {
        byte[] requiredBytes = new byte[length];
        int i = offset;
        for (int j = 0; j < length; ++j) {
            requiredBytes[j] = bytes[i];
            ++i;
        }
        return requiredBytes;
    }

    public void setCreatedDate(String newCreatedDate) {
        this.createdDate = newCreatedDate;
    }

    public String getCreatedDate() {
        return this.createdDate;
    }

    public void setMimeType(String newMimeType) {
        this.mimeType = newMimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setWidth(double newWidth) {
        this.width = newWidth;
    }

    public double getWidth() {
        return this.width;
    }

    public void setHeight(double newHeight) {
        this.height = newHeight;
    }

    public double getHeight() {
        return this.height;
    }

    public void setAudioDataRate(double newAudioDataRate) {
        this.audioDataRate = newAudioDataRate;
    }

    public double getAudioDataRate() {
        return this.audioDataRate;
    }

    public void setVideoDataRate(double newVideoDataRate) {
        this.videoDataRate = newVideoDataRate;
    }

    public double getVideoDataRate() {
        return this.videoDataRate;
    }

    public void setFileSize(double newFileSize) {
        this.fileSize = newFileSize;
    }

    public double getFileSize() {
        return this.fileSize;
    }

    public void setFrameRate(double newFrameRate) {
        this.frameRate = newFrameRate;
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public void setDuration(String newDuration) {
        this.duration = newDuration;
    }

    public String getDuration() {
        return this.duration;
    }
}

