/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.util.encoders;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public abstract class CharacterEncoder {
    protected transient PrintStream pStream;

    abstract int bytesPerAtom();

    abstract int bytesPerLine();

    void encodeBufferPrefix(OutputStream outputstream) throws IOException {
        this.pStream = new PrintStream(outputstream);
    }

    void encodeBufferSuffix(OutputStream outputstream) throws IOException {
    }

    void encodeLinePrefix(OutputStream outputstream, int i) throws IOException {
    }

    void encodeLineSuffix(OutputStream outputstream) throws IOException {
        this.pStream.println();
    }

    abstract void encodeAtom(OutputStream var1, byte[] var2, int var3, int var4) throws IOException;

    protected int readFully(InputStream inputstream, byte[] abyte0) throws IOException {
        for (int i = 0; i < abyte0.length; ++i) {
            int j = inputstream.read();
            if (j == -1) {
                return i;
            }
            abyte0[i] = (byte)j;
        }
        return abyte0.length;
    }

    public void encodeBuffer(InputStream inputstream, OutputStream outputstream) throws IOException {
        int j;
        byte[] abyte0 = new byte[this.bytesPerLine()];
        this.encodeBufferPrefix(outputstream);
        while ((j = this.readFully(inputstream, abyte0)) != -1) {
            this.encodeLinePrefix(outputstream, j);
            for (int i = 0; i < j; i += this.bytesPerAtom()) {
                if (i + this.bytesPerAtom() <= j) {
                    this.encodeAtom(outputstream, abyte0, i, this.bytesPerAtom());
                    continue;
                }
                this.encodeAtom(outputstream, abyte0, i, j - i);
            }
            this.encodeLineSuffix(outputstream);
            if (j >= this.bytesPerLine()) continue;
        }
        this.encodeBufferSuffix(outputstream);
    }

    public void encodeBuffer(byte[] abyte0, OutputStream outputstream) throws IOException {
        ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(abyte0);
        this.encodeBuffer(bytearrayinputstream, outputstream);
    }

    public String encodeBuffer(byte[] abyte0) {
        String s;
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(abyte0);
        try {
            this.encodeBuffer(bytearrayinputstream, (OutputStream)bytearrayoutputstream);
        }
        catch (Exception exception) {
            throw new Error("ChracterEncoder::encodeBuffer internal error");
        }
        try {
            s = bytearrayoutputstream.toString("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedencodingexception) {
            throw new Error("CharacterEncoder::encodeBuffer internal error(2)");
        }
        return s;
    }
}

