/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.util;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class XSSSCanner {
    private String _defaultXSSPattern = "<script|%3Cscript|&lt;script|javascript";
    private String _SPECIAL_CHARS = ".*%(([^A-Fa-f0-9]+|.{1}[^A-Fa-f0-9]+).*|.?$)";
    private String _XSSPattern = null;
    private boolean ACTIVATE = false;
    private boolean DEBUG = true;

    public XSSSCanner() {
        try {
            this._XSSPattern = XMLProperties.get("r01ft", "xssScanner/regexp");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this._XSSPattern == null) {
            this._XSSPattern = this._defaultXSSPattern;
        }
        try {
            this.ACTIVATE = new Boolean(XMLProperties.get("r01ft", "xssScanner/activate"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.DEBUG = new Boolean(XMLProperties.get("r01ft", "xssScanner/debug"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void scanRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.ACTIVATE) {
            String qs = request.getQueryString();
            if (this.DEBUG) {
                R01FLog.to("r01f.xssScanner").info("Escaneando QUERYSTRING...");
            }
            if (qs != null && (qs.matches(this._SPECIAL_CHARS) || this.hasAnyXSS(URLDecoder.decode(qs)))) {
                if (this.DEBUG) {
                    R01FLog.to("r01f.xssScanner").warning(">>>>>>>>>>>> ENCONTRADO PATR\u00d3N xss en QUERYSTRING :" + qs);
                }
                response.sendError(403, "[0] Forbidden");
            } else {
                for (String paramName : request.getParameterMap().keySet()) {
                    String paramValue = request.getParameter(paramName);
                    if (this.DEBUG) {
                        R01FLog.to("r01f.xssScanner").info("Escaneando par\u00e1metro :" + paramName);
                    }
                    if (this.hasAnyXSS(paramValue)) {
                        if (this.DEBUG) {
                            R01FLog.to("r01f.xssScanner").warning(">>>>>>>>>>>> ENCONTRADO PATR\u00d3N xss en el Par\u00e1metro :" + paramName + "==>" + paramValue);
                        }
                        response.sendError(403, "[1] Forbidden");
                        continue;
                    }
                    if (!this.DEBUG) continue;
                    R01FLog.to("r01f.xssScanner").info("..OK");
                }
            }
        }
    }

    public boolean hasAnyXSS(String value) {
        String valueLowerCase = value.toLowerCase();
        Pattern theXSSPattern = Pattern.compile(this._XSSPattern);
        Matcher matcher = theXSSPattern.matcher(valueLowerCase);
        return matcher.find();
    }

    public static void main(String[] argv) {
        XSSSCanner scanner = new XSSSCanner();
        String tst00 = "<script>%";
        String tst01 = "<script>%1";
        String tst02 = "<script>%F";
        String tst03 = "<script>%G";
        String tst04 = "<script>%1F";
        String tst05 = "<script>%1G";
        String tst06 = "<script>%FF";
        String tst07 = "<script>%G1";
        String tst08 = "%<script>";
        String tst09 = "%1<script>";
        String tst10 = "%1F<script>";
        String tst11 = "%1G<script>";
        String tst12 = "%FF<script>";
        String tst13 = "%G1<script>";
        String er = ".*%(([^A-Fa-f0-9]+|.{1}[^A-Fa-f0-9]+).*|.?$)";
        System.out.println("REGEX: \"" + er + "\"");
        System.out.println(tst00 + (tst00.matches(er) ? "" : " NO") + " matches");
        System.out.println(tst01 + (tst01.matches(er) ? "" : " NO") + " matches");
        System.out.println(tst02 + (tst02.matches(er) ? "" : " NO") + " matches");
        System.out.println(tst03 + (tst03.matches(er) ? "" : " NO") + " matches");
        System.out.println(tst04 + (tst04.matches(er) ? "" : " NO") + " matches");
        System.out.println(tst05 + (tst05.matches(er) ? "" : " NO") + " matches");
        System.out.println(tst06 + (tst06.matches(er) ? "" : " NO") + " matches");
        System.out.println(tst07 + (tst07.matches(er) ? "" : " NO") + " matches");
        System.out.println(tst08 + (tst08.matches(er) ? "" : " NO") + " matches");
        System.out.println(tst09 + (tst09.matches(er) ? "" : " NO") + " matches");
        System.out.println(tst10 + (tst10.matches(er) ? "" : " NO") + " matches");
        System.out.println(tst11 + (tst11.matches(er) ? "" : " NO") + " matches");
        System.out.println(tst12 + (tst12.matches(er) ? "" : " NO") + " matches");
        System.out.println(tst13 + (tst13.matches(er) ? "" : " NO") + " matches");
    }
}

