/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.util;

import com.ejie.r01f.xmlbuilder.XMLNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMap
implements Map {
    private transient Map _map;

    public XMap() {
        this._map = new HashMap();
    }

    public XMap(InputStream is) {
        if (is == null) {
            return;
        }
        try {
            this._map = this.loadFromXML(is);
        }
        catch (SAXException saxEx) {
            this._map = null;
            throw new IllegalArgumentException(saxEx.getMessage());
        }
    }

    public XMap(String inXMLStr) {
        if (inXMLStr == null) {
            return;
        }
        try {
            this._map = this.loadFromXML(new ByteArrayInputStream(inXMLStr.getBytes()));
        }
        catch (SAXException saxEx) {
            this._map = null;
            throw new IllegalArgumentException(saxEx.getMessage());
        }
    }

    public String toString() {
        return this.toXML();
    }

    public String toXML() {
        XMLNode mapNode = new XMLNode("Map");
        if (this._map == null) {
            return mapNode.toString();
        }
        for (Map.Entry me : this._map.entrySet()) {
            XMLNode currNode = new XMLNode((String)me.getKey(), (String)me.getValue());
            mapNode.addSubNode(currNode);
        }
        return mapNode.toString();
    }

    public Map loadFromXML(InputStream is) throws SAXException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            XMLMapLoader loader = new XMLMapLoader();
            saxParser.parse(is, (DefaultHandler)loader);
            return loader.loadedMap;
        }
        catch (ParserConfigurationException pcEx) {
            throw new SAXException("Error en la configuraci\u00f3n del parser: " + pcEx.getMessage());
        }
        catch (IOException ioEx) {
            throw new SAXException("Error de IO " + ioEx.getMessage());
        }
    }

    @Override
    public void clear() {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        this._map.clear();
    }

    @Override
    public boolean containsKey(Object obj) {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        return this._map.containsKey(obj);
    }

    @Override
    public boolean containsValue(Object obj) {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        return this._map.containsValue(obj);
    }

    public Set entrySet() {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        return this._map.entrySet();
    }

    @Override
    public boolean equals(Object obj) {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        return ((Object)this._map).equals(obj);
    }

    public Object get(Object obj) {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        return this._map.get(obj);
    }

    @Override
    public int hashCode() {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        return ((Object)this._map).hashCode();
    }

    @Override
    public boolean isEmpty() {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        return this._map.isEmpty();
    }

    public Set keySet() {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        return this._map.keySet();
    }

    public Object put(Object key, Object obj) {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        return this._map.put(key, obj);
    }

    public void putAll(Map map) {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        this._map.putAll(map);
    }

    public Object remove(Object obj) {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        return this._map.remove(obj);
    }

    @Override
    public int size() {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        return this._map.size();
    }

    public Collection values() {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        return this._map.values();
    }

    private class XMLMapLoader
    extends DefaultHandler {
        public transient Map loadedMap;
        private static final String MAP_TAG_NAME = "map";
        private transient String _currNodeName = null;
        private transient String _currNodeValue = null;
        private transient int _level = 0;

        @Override
        public void startDocument() {
        }

        @Override
        public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
            this._currNodeName = lName;
            if ("".equals(this._currNodeName)) {
                this._currNodeName = qName;
            }
            if (this._currNodeName.equalsIgnoreCase(MAP_TAG_NAME)) {
                this._currNodeName = null;
                this.loadedMap = new HashMap();
                return;
            }
            ++this._level;
            if (this._level == 2) {
                throw new SAXException("El documento XML no tiene el formato adecuado para importar un Mapa");
            }
        }

        @Override
        public void characters(char[] buf, int offset, int len) {
            this._currNodeValue = this._currNodeValue == null ? new String(buf, offset, len) : this._currNodeValue + new String(buf, offset, len);
        }

        @Override
        public void endElement(String namespaceURI, String sName, String qName) {
            if (this._currNodeName != null) {
                if (this._currNodeValue == null) {
                    this._currNodeValue = "";
                }
                this.loadedMap.put(this._currNodeName, this._currNodeValue);
                --this._level;
                this._currNodeName = null;
                this._currNodeValue = null;
            }
        }

        @Override
        public void endDocument() {
        }
    }
}

