/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.util;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.util.TestMapObj;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class StringUtilsTest
extends TestCase {
    public StringUtilsTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testReplaceVariableValuesStringCharMap() {
        String result;
        Properties vars = new Properties();
        vars.put("val1", "");
        vars.put("val2", "aa");
        String cadenaToReplace = "Cambiar $val1$ y tambien $val2$ y tambien $val3$";
        try {
            result = StringUtils.replaceVariableValues(cadenaToReplace, '$', (Map)vars);
            StringUtilsTest.assertEquals((String)"Cambiar  y tambien aa y tambien $val3$", (String)result);
        }
        catch (Exception e) {
            StringUtilsTest.fail((String)("Error en el replace.Error:" + e.getMessage()));
        }
        vars.put("val3", "otro");
        try {
            result = StringUtils.replaceVariableValues(cadenaToReplace, '$', (Map)vars);
            StringUtilsTest.assertEquals((String)"Cambiar  y tambien aa y tambien otro", (String)result);
        }
        catch (Exception e) {
            StringUtilsTest.fail((String)("Error en el replace.Error:" + e.getMessage()));
        }
    }

    public void testIsEmptyString() {
        StringUtilsTest.assertTrue((boolean)StringUtils.isEmptyString(""));
        StringUtilsTest.assertTrue((boolean)StringUtils.isEmptyString(" "));
        StringUtilsTest.assertTrue((boolean)StringUtils.isEmptyString(null));
        StringUtilsTest.assertFalse((boolean)StringUtils.isEmptyString(" no es vacia "));
    }

    public void testIsEmptyStringBuffer() {
        StringUtilsTest.assertTrue((boolean)StringUtils.isEmptyStringBuffer(new StringBuffer("")));
        StringUtilsTest.assertTrue((boolean)StringUtils.isEmptyStringBuffer(new StringBuffer(" ")));
        StringUtilsTest.assertTrue((boolean)StringUtils.isEmptyString(null));
        StringUtilsTest.assertFalse((boolean)StringUtils.isEmptyStringBuffer(new StringBuffer(" no es vacia ")));
    }

    public void testSortListLocale() {
        ArrayList<String> unordered = new ArrayList<String>();
        unordered.add("\u00f1apa");
        unordered.add("java");
        unordered.add("especial");
        try {
            StringUtilsTest.assertEquals((String)StringUtils.sortListLocale(unordered, "es").toString(), (String)"[especial, java, \u00f1apa]");
        }
        catch (AssertionFailedError err) {
            StringUtilsTest.fail((String)"Error al ordenar una lista de cadenas por oeden alfab\u00e9tico en castellano");
        }
    }

    public void testMapObjectsToString() {
        HashMap<String, TestMapObj> testMap = new HashMap<String, TestMapObj>();
        testMap.put("obj1", new TestMapObj("obj1", "val1", 1, true));
        testMap.put("obj2", new TestMapObj("obj2", "val2", 2, false));
        try {
            StringUtilsTest.assertEquals((String)StringUtils.mapObjectsToString(testMap), (String)"(obj1;val1,1,true),(obj2;val2,2,false)");
        }
        catch (AssertionFailedError err) {
            StringUtilsTest.assertEquals((String)StringUtils.mapObjectsToString(testMap), (String)"(obj2;val2,2,false),(obj1;val1,1,true)");
        }
    }
}

