/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.util;

import com.ejie.r01f.log.R01FLog;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class R01FPager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List pages = new ArrayList();
    private int pageSize = 10;
    private int blockSize = 5;
    private int numElementos;
    private int paginaActual = 1;

    public R01FPager() throws IllegalArgumentException {
    }

    public R01FPager(int inPageSize) throws IllegalArgumentException {
        this();
        if (inPageSize <= 0) {
            throw new IllegalArgumentException("El numero de elementos en la pagina no puede ser menor que cero");
        }
        this.pageSize = inPageSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setBlockSize(int newBlockSize) {
        if (newBlockSize < 0) {
            throw new IllegalArgumentException("El tama\u00f1o del bloque no puede ser menor que cero");
        }
        this.blockSize = newBlockSize;
    }

    public int[] getCurrentBlockPageNumbers() {
        int i;
        double dblPaginas = this.pages.size();
        int numeroBloques = new Double(Math.ceil(dblPaginas / (double)this.blockSize)).intValue();
        int bloqueActual = new Double((this.paginaActual - 1) / this.blockSize + 1).intValue();
        int currentBlockSize = this.blockSize;
        if (bloqueActual == numeroBloques) {
            currentBlockSize = this.pages.size() - (numeroBloques - 1) * this.blockSize;
        }
        int[] blockPages = new int[currentBlockSize];
        int j = 0;
        for (i = 1; i <= blockPages.length; ++i) {
            blockPages[i - 1] = i;
        }
        i = (bloqueActual - 1) * this.blockSize + 1;
        while (i <= bloqueActual * this.blockSize && i <= this.pages.size()) {
            blockPages[j++] = i++;
        }
        return blockPages;
    }

    public Object getCurrentPageElement() {
        return this.pages.get(this.paginaActual - 1);
    }

    public Object getNextPageElement() {
        if (this.paginaActual < this.pages.size()) {
            return this.pages.get(this.paginaActual);
        }
        return null;
    }

    public Object getPrevPageElement() {
        if (this.paginaActual > 1) {
            return this.pages.get(this.paginaActual - 1 - 1);
        }
        return null;
    }

    public Object getPageElement(int inPage) throws IllegalArgumentException {
        if (inPage < 0 || inPage > this.pages.size()) {
            throw new IllegalArgumentException("P\u00e1gina ilegal");
        }
        return this.pages.get(inPage);
    }

    public int getPageFirstElementNumber() {
        if (this.paginaActual == 1) {
            return 1;
        }
        return this.paginaActual * this.pageSize - this.pageSize + 1;
    }

    public int getPageLastElementNumber() {
        if (this.paginaActual == this.pages.size()) {
            return this.numElementos;
        }
        return this.paginaActual * this.pageSize;
    }

    public int getCurrentPageNumber() {
        return this.paginaActual;
    }

    public int getElementCount() {
        return this.numElementos;
    }

    public void setElementCount(int elementCount) throws IllegalArgumentException {
        if (elementCount < 0) {
            throw new IllegalArgumentException("El numero de elementos no puede ser menor que cero");
        }
        for (int i = 1; i <= elementCount; ++i) {
            this.addPageElement(new Integer(i));
        }
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public void goToNextPage() {
        if (this.paginaActual == this.pages.size()) {
            return;
        }
        ++this.paginaActual;
    }

    public void goToPage(int newPage) throws IllegalArgumentException {
        if (newPage < 0 || newPage > this.pages.size()) {
            throw new IllegalArgumentException("P\u00e1gina ilegal");
        }
        this.paginaActual = newPage;
    }

    public void goToPrevPage() {
        if (this.paginaActual == 1) {
            return;
        }
        --this.paginaActual;
    }

    public void addPageElement(Object value) {
        if (this.pages == null) {
            this.pages = new ArrayList();
        }
        if (this.numElementos % this.pageSize == 0) {
            R01FLog.getLogger("r01f.search").info("-------> Primer registro de la pagina de busqueda: " + value.toString());
            this.pages.add(value);
        }
        ++this.numElementos;
    }

    public static void main(String[] args) {
        R01FPager pager = new R01FPager(4);
        pager.setBlockSize(5);
        pager.setElementCount(2345);
        R01FLog.to("r01f.test").info(Integer.toString(pager.getPageCount()));
        R01FLog.to("r01f.test").info(pager.getCurrentPageElement().toString());
        pager.goToPage(2);
        R01FLog.to("r01f.test").info(pager.getCurrentPageElement().toString());
        R01FLog.to("r01f.test").info(Integer.toString(pager.numElementos));
    }
}

