/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.util;

import com.ejie.r01f.log.R01FLog;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Pager
implements Serializable {
    private static final long serialVersionUID = -4966151337012633456L;
    private List _pages = new ArrayList();
    private int _pageSize = 10;
    private int _blockSize = 5;
    private int _numElementos;
    private int _currPage = 1;

    public Pager() throws IllegalArgumentException {
    }

    public Pager(int newPageSize) {
        this();
        if (newPageSize <= 0) {
            throw new IllegalArgumentException("El numero de elementos en la pagina no puede ser menor que cero");
        }
        this._pageSize = newPageSize;
    }

    public Pager(int newPageSize, int newBlockSize) throws IllegalArgumentException {
        this();
        if (newPageSize <= 0 || newBlockSize <= 0) {
            throw new IllegalArgumentException("El numero de elementos en la pagina o el tama\u00f1o del bloque de p\u00e1ginas de la barra de navegaci\u00f3n, no puede ser menor que cero");
        }
        this._pageSize = newPageSize;
        this._blockSize = newBlockSize;
    }

    public void addPageElement(Object elementOid) {
        if (this._pages == null) {
            this._pages = new ArrayList();
        }
        if (this._numElementos % this._pageSize == 0) {
            R01FLog.to("r01f.search").info("OID del primer registro de la pagina " + this._pages.size() + ": " + elementOid.toString());
            this._pages.add(elementOid);
        }
        ++this._numElementos;
    }

    public int getPageSize() {
        return this._pageSize;
    }

    public void setPageSize(int thePageSize) {
        if (thePageSize < 0) {
            throw new IllegalArgumentException("El tama\u00f1o de la p\u00e1gina ha de ser mayor que cero");
        }
        this._pageSize = thePageSize;
    }

    public int getBlockSize() {
        return this._blockSize;
    }

    public void setBlockSize(int theBlockSize) {
        if (theBlockSize < 0) {
            throw new IllegalArgumentException("El tama\u00f1o del bloque no puede ser menor que cero");
        }
        this._blockSize = theBlockSize;
    }

    public int[] getCurrentBlockPageNumbers() {
        int i;
        int numeroBloques = this.getBlockCount();
        int bloqueActual = this.getCurrentBlockNumber();
        int currentBlockSize = this._blockSize;
        if (bloqueActual == numeroBloques) {
            currentBlockSize = this._pages.size() - (numeroBloques - 1) * this._blockSize;
        }
        int[] blockPages = new int[currentBlockSize];
        int j = 0;
        for (i = 1; i <= blockPages.length; ++i) {
            blockPages[i - 1] = i;
        }
        i = (bloqueActual - 1) * this._blockSize + 1;
        while (i <= bloqueActual * this._blockSize && i <= this._pages.size()) {
            blockPages[j++] = i++;
        }
        return blockPages;
    }

    public int getCurrentBlockNumber() {
        int bloqueActual = new Double((this._currPage - 1) / this._blockSize + 1).intValue();
        return bloqueActual;
    }

    public int getBlockCount() {
        double dblPaginas = this._pages.size();
        int numeroBloques = new Double(Math.ceil(dblPaginas / (double)this._blockSize)).intValue();
        return numeroBloques;
    }

    public Object getCurrentPageFirstElement() {
        return this._pages.get(this._currPage - 1);
    }

    public Object getCurrentPageLastElement() {
        return this.getNextPageFirstElement();
    }

    public Object getNextPageFirstElement() {
        if (this._currPage < this._pages.size()) {
            return this._pages.get(this._currPage);
        }
        return new Integer(this._numElementos);
    }

    public Object getPrevPageFirstElement() {
        if (this._currPage > 1) {
            return this._pages.get(this._currPage - 1);
        }
        return null;
    }

    public Object getPageFirstElement(int inPage) throws IllegalArgumentException {
        if (inPage < 0 || inPage > this._pages.size()) {
            throw new IllegalArgumentException("P\u00e1gina ilegal");
        }
        return this._pages.get(inPage);
    }

    public int getCurrentPageElementNumber() {
        return this._currPage;
    }

    public int getFirstPageElementNumber() {
        return 1;
    }

    public int getLastPageElementNumber() {
        return this._pages.size();
    }

    public int getCurrentPageFirstElementNumber() {
        if (this._currPage == this.getFirstPageElementNumber()) {
            return 1;
        }
        return this._currPage * this._pageSize - this._pageSize + 1;
    }

    public int getCurrentPageLastElementNumber() {
        if (this._currPage == this.getLastPageElementNumber()) {
            return this.getLastPageElementNumber();
        }
        return this._currPage * this._pageSize;
    }

    public int getCurrentPageNextElementNumber() {
        int currPageNum = this.getCurrentPageElementNumber();
        if (currPageNum == this.getLastPageElementNumber()) {
            return currPageNum;
        }
        return currPageNum + 1;
    }

    public int getCurrentPagePrevElementNumber() {
        int currPageNum = this.getCurrentPageElementNumber();
        if (currPageNum == 1) {
            return 1;
        }
        return currPageNum - 1;
    }

    public int getPreviousPageLastElementNumber() {
        int currPageFirstElementNum = this.getCurrentPageFirstElementNumber();
        if (currPageFirstElementNum == 1) {
            return 1;
        }
        return currPageFirstElementNum - 1;
    }

    public int getNextPageFirstElementNumber() {
        int currPageLastElementNum = this.getCurrentPageLastElementNumber();
        if (currPageLastElementNum == this.getLastPageElementNumber()) {
            return currPageLastElementNum;
        }
        return currPageLastElementNum + 1;
    }

    public int getPrevBlockLastElementNumber() {
        int[] currentBlockPageNums = this.getCurrentBlockPageNumbers();
        if (currentBlockPageNums[0] == 1) {
            return 1;
        }
        return currentBlockPageNums[0] - 1;
    }

    public int getNextBlockFirstElementNumber() {
        int[] currentBlockPageNums = this.getCurrentBlockPageNumbers();
        if (currentBlockPageNums[currentBlockPageNums.length - 1] == this._pages.size()) {
            return currentBlockPageNums[currentBlockPageNums.length - 1];
        }
        return currentBlockPageNums[currentBlockPageNums.length - 1] + 1;
    }

    public int getElementCount() {
        return this._numElementos;
    }

    public void setElementCount(int elementCount) throws IllegalArgumentException {
        if (elementCount < 0) {
            throw new IllegalArgumentException("El numero de elementos no puede ser menor que cero");
        }
        this._numElementos = elementCount;
    }

    public int getPageCount() {
        return this._pages.size();
    }

    public void goToFirstPage() {
        this._currPage = 1;
    }

    public void gotoPrevBlockLastPage() {
        this._currPage = this.getPrevBlockLastElementNumber();
    }

    public void goToPrevPage() {
        if (this._currPage == 1) {
            return;
        }
        --this._currPage;
    }

    public void goToPage(int newPage) throws IllegalArgumentException {
        if (newPage < 0 || newPage > this._pages.size()) {
            throw new IllegalArgumentException("P\u00e1gina ilegal");
        }
        this._currPage = newPage;
    }

    public void goToNextPage() {
        if (this._currPage == this._pages.size()) {
            return;
        }
        ++this._currPage;
    }

    public void gotoNextBlockFirstPage() {
        this._currPage = this.getNextBlockFirstElementNumber();
    }

    public void goToLastPage() {
        this._currPage = this._pages.size();
    }
}

