/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.util;

import com.ejie.r01f.log.R01FLog;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MainParamsParser {
    static String PARAM_NAME_SEED = "r01fMainParser";
    public static int PARAM_TYPE_GENERAL = 0;
    public static int PARAM_TYPE_ALFANUMERIC = 1;
    public static int PARAM_TYPE_NUMERIC = 2;
    public static int PARAM_TYPE_BOOLEAN = 3;
    Map _params = null;
    boolean _paramsParsed = false;

    public void addParamDef(String name, String description, int type, boolean mandatory) {
        if (this._params == null) {
            this._params = new HashMap();
        }
        this._params.put(name, new Param(name, description, type, mandatory));
    }

    public void removeParamDef(String name) {
        if (this._params == null) {
            return;
        }
        this._params.remove(name);
    }

    public String getParam(String name) {
        if (!this._paramsParsed) {
            throw new IllegalStateException("ERROR: No se ha llamado a parseParams(args)!!!");
        }
        if (this._params == null) {
            return null;
        }
        if (this._params.get(name) == null) {
            return null;
        }
        Param param = (Param)this._params.get(name);
        return param.value;
    }

    public Map parseParams(String[] args) throws IllegalArgumentException {
        if (this._params == null && args == null) {
            return null;
        }
        if (this._params == null && args != null || this._params != null && args == null) {
            throw new IllegalArgumentException("Llamada ilegal para el parseo de parametros de entrada del Main!!!!");
        }
        String argsString = " ";
        for (int i = 0; i < args.length; ++i) {
            argsString = argsString + PARAM_NAME_SEED + args[i];
            argsString = argsString + " ";
        }
        HashMap<String, String> outArgs = new HashMap<String, String>();
        Param currParam2 = null;
        String paramValue = null;
        for (Param currParam2 : this._params.values()) {
            paramValue = this._parseParam(currParam2.regExpr, argsString);
            outArgs.put(currParam2.name, paramValue);
            currParam2.value = paramValue;
        }
        this._paramsParsed = true;
        return outArgs;
    }

    public boolean areValid() {
        if (!this._paramsParsed) {
            throw new IllegalStateException("ERROR: No se ha llamado a parseParams(args)!!!");
        }
        if (this._params == null) {
            return true;
        }
        Param currParam2 = null;
        for (Param currParam2 : this._params.values()) {
            if (currParam2.value != null || !currParam2.mandatory) continue;
            return false;
        }
        return true;
    }

    public String getParamsUsageMessage() {
        if (this._params == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer("");
        Param currParam2 = null;
        for (Param currParam2 : this._params.values()) {
            String strType = "type unknown";
            if (currParam2.type == PARAM_TYPE_ALFANUMERIC) {
                strType = "alfanumeric";
            } else if (currParam2.type == PARAM_TYPE_NUMERIC) {
                strType = "numeric";
            } else if (currParam2.type == PARAM_TYPE_GENERAL) {
                strType = "general";
            } else if (currParam2.type == PARAM_TYPE_BOOLEAN) {
                strType = "boolean";
            }
            sb.append("\t" + currParam2.name + (currParam2.description == null ? "" : "=[" + currParam2.description + "]") + " (" + strType + (currParam2.mandatory ? " mandatory" : "") + ")\r\n");
        }
        return sb.toString();
    }

    public String toString() {
        if (this._params != null) {
            StringBuffer sb = new StringBuffer("");
            Param currParam2 = null;
            for (Param currParam2 : this._params.values()) {
                sb.append(currParam2.toString() + "\r\n");
            }
            return sb.toString();
        }
        return "Not defined!!!";
    }

    private String _parseParam(String pattern, String argsString) {
        int idx;
        Pattern p = Pattern.compile(pattern, 128);
        Matcher m = p.matcher(argsString);
        String outStr = null;
        if (m.matches() && (idx = (outStr = m.group(1)).indexOf(PARAM_NAME_SEED)) > 0) {
            outStr = outStr.substring(0, idx - 1);
        }
        return outStr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        try {
            int i = 0;
            while (i < 1) {
                String[] argsSim = new String[]{"-param1=([\\\\_/:.a-zA-Z0-9]*)", "-param2=hola/b\\:asdf:.ac", "-param3=123", "-param4=([\\\\_/:.a-z^^A-Z0-9]*)Main", "-param5=true"};
                MainParamsParser mainParams = new MainParamsParser();
                mainParams.addParamDef("-param1", "Parametro 1", PARAM_TYPE_GENERAL, false);
                mainParams.addParamDef("-param2", "Parametro 2", PARAM_TYPE_ALFANUMERIC, false);
                mainParams.addParamDef("-param3", "Parametro 3", PARAM_TYPE_NUMERIC, true);
                mainParams.addParamDef("-param4", "Parametro 4", PARAM_TYPE_GENERAL, false);
                mainParams.addParamDef("-param5", "Parametro 5", PARAM_TYPE_BOOLEAN, true);
                Map outParams = mainParams.parseParams(argsSim);
                if (mainParams.areValid()) {
                    R01FLog.to("r01f.test").info("Param1 = '" + mainParams.getParam("-param1") + "'");
                    R01FLog.to("r01f.test").info("Param2 = '" + mainParams.getParam("-param2") + "'");
                    R01FLog.to("r01f.test").info("Param3 = '" + mainParams.getParam("-param3") + "'");
                    R01FLog.to("r01f.test").info("Param4 = '" + mainParams.getParam("-param4") + "'");
                    R01FLog.to("r01f.test").info("Param5 = '" + mainParams.getParam("-param5") + "'");
                    R01FLog.to("r01f.test").info(" \r\n\r\n");
                    for (Map.Entry me : outParams.entrySet()) {
                        R01FLog.to("r01f.test").info(me.getKey() + "=" + me.getValue());
                    }
                } else {
                    R01FLog.to("r01f.test").info("Usage:\r\n" + mainParams.getParamsUsageMessage());
                }
                ++i;
            }
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            R01FLog.to("r01f.test").info(ex.toString());
        }
    }

    private class Param {
        String ALFANUMERIC_PATTERN = "([\\\\_/:.a-zA-Z0-9]*)";
        String NUMERIC_PATTERN = "([0-9]*)";
        String GENERAL_PATTERN = "(.*)(?=(" + PARAM_NAME_SEED + ")|\\s)";
        String BOOLEAN_PATTERN = "(true|false)";
        String name = null;
        String internalName = null;
        String description = null;
        boolean mandatory = false;
        int type;
        String regExpr = null;
        String value = null;

        public Param(String newName, String newDescription, int newType, boolean newMandatory) {
            this.type = newType;
            this.name = newName;
            this.internalName = PARAM_NAME_SEED + this.name;
            this.regExpr = this.type == PARAM_TYPE_ALFANUMERIC ? ".*\\s" + this.internalName + "=" + this.ALFANUMERIC_PATTERN + "\\s.*" : (this.type == PARAM_TYPE_NUMERIC ? ".*\\s" + this.internalName + "=" + this.NUMERIC_PATTERN + "\\s.*" : (this.type == PARAM_TYPE_BOOLEAN ? ".*\\s" + this.internalName + "=" + this.BOOLEAN_PATTERN + "\\s.*" : ".*\\s" + this.internalName + "=" + this.GENERAL_PATTERN + ".*"));
            this.description = newDescription;
            this.mandatory = newMandatory;
        }

        public String toString() {
            String strType = "type unknown";
            if (this.type == PARAM_TYPE_ALFANUMERIC) {
                strType = "alfanumeric";
            } else if (this.type == PARAM_TYPE_NUMERIC) {
                strType = "numeric";
            } else if (this.type == PARAM_TYPE_GENERAL) {
                strType = "general";
            } else if (this.type == PARAM_TYPE_BOOLEAN) {
                strType = "boolean";
            }
            return "Param: " + (this.name == null ? "null" : this.name) + " = " + (this.value == null ? "null" : this.value) + " >> " + (this.description == null ? "null" : this.description);
        }
    }
}

