/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.util;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class FifoMap
extends HashMap {
    private static final long serialVersionUID = -2597699745153725878L;
    List keysOrdered;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;

    public FifoMap() {
        this.keysOrdered = new ArrayList();
    }

    public FifoMap(Map inMap) {
        this.putAll(inMap);
    }

    @Override
    public Set keySet() {
        AbstractSet keySet = null;
        keySet = new AbstractSet(){

            @Override
            public Iterator iterator() {
                return new FifoMapIterator(0);
            }

            @Override
            public int size() {
                return FifoMap.this.size();
            }

            @Override
            public boolean contains(Object inKey) {
                return FifoMap.this.containsKey(inKey);
            }

            @Override
            public boolean remove(Object inKey) {
                return FifoMap.this.remove(inKey) != null;
            }

            @Override
            public void clear() {
                FifoMap.this.clear();
            }
        };
        return keySet;
    }

    @Override
    public Set entrySet() {
        AbstractSet entrySet = null;
        entrySet = new AbstractSet(){

            @Override
            public Iterator iterator() {
                return new FifoMapIterator(2);
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry me = (Map.Entry)o;
                return FifoMap.this.get(me.getKey()) != null;
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry me = (Map.Entry)o;
                return FifoMap.this.remove(me.getKey()) != null;
            }

            @Override
            public int size() {
                return FifoMap.this.size();
            }

            @Override
            public void clear() {
                FifoMap.this.clear();
            }
        };
        return entrySet;
    }

    @Override
    public Collection values() {
        ArrayList outValues = new ArrayList(this.size());
        Iterator it = this.keysOrdered.iterator();
        while (it.hasNext()) {
            outValues.add(this.get(it.next()));
        }
        return outValues;
    }

    @Override
    public Object put(Object newKey, Object newValue) {
        int index = this.keysOrdered.indexOf(newKey);
        Object retObj = null;
        if (index > 0) {
            retObj = this.get(newKey);
            super.put(newKey, newValue);
            return retObj;
        }
        this.keysOrdered.add(newKey);
        super.put(newKey, newValue);
        return null;
    }

    @Override
    public void putAll(Map m) {
        for (Map.Entry me : m.entrySet()) {
            this.put(me.getKey(), me.getValue());
        }
    }

    public void putAllKeys(Set keys) {
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Object currKey = it.next();
            this.put(it.next(), (Object)null);
        }
    }

    @Override
    public Object remove(Object inKey) {
        int idx = this.keysOrdered.indexOf(inKey);
        if (idx >= 0) {
            Object retObj = this.get(inKey);
            super.remove(inKey);
            this.keysOrdered.remove(idx);
            return retObj;
        }
        return null;
    }

    @Override
    public void clear() {
        super.clear();
        this.keysOrdered.clear();
    }

    static class Entry
    implements Map.Entry {
        private Object key;
        private Object value;

        Entry(Object newKey, Object newValue) {
            this.key = newKey;
            this.value = newValue;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object newValue) {
            Object oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            boolean keyEq;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            boolean bl = this.key == null ? e.getKey() == null : (keyEq = this.key.equals(e.getKey()));
            boolean valEq = this.value == null ? e.getValue() == null : this.value.equals(e.getValue());
            return keyEq && valEq;
        }

        @Override
        public int hashCode() {
            int keyHash = this.key == null ? 0 : this.key.hashCode();
            int valueHash = this.value == null ? 0 : this.value.hashCode();
            return keyHash ^ valueHash;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private class FifoMapIterator
    implements Iterator {
        private int type;
        private int iteratorPosition = 0;
        private int iteratorLastReturned = -1;

        FifoMapIterator(int newType) {
            this.type = newType;
        }

        @Override
        public boolean hasNext() {
            boolean retValue = false;
            retValue = this.iteratorPosition <= FifoMap.this.size() - 1;
            return retValue;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("FifoMapIterator:next(): No hay mas elementos");
            }
            Entry retObj = null;
            Object key = FifoMap.this.keysOrdered.get(this.iteratorPosition);
            Object value = FifoMap.this.get(key);
            switch (this.type) {
                case 0: {
                    retObj = (Entry)key;
                    break;
                }
                case 1: {
                    retObj = (Entry)value;
                    break;
                }
                case 2: {
                    retObj = new Entry(key, value);
                }
            }
            this.iteratorLastReturned = this.iteratorPosition++;
            return retObj;
        }

        @Override
        public void remove() {
            if (this.iteratorLastReturned == -1) {
                throw new IllegalStateException("FifoMap:Iterator:Remove(): No hay elementos para eliminar");
            }
            FifoMap.this.remove(FifoMap.this.keysOrdered.get(this.iteratorLastReturned));
            this.iteratorPosition = this.iteratorLastReturned;
            this.iteratorLastReturned = -1;
        }
    }
}

