/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.util;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.util.CodeAndValueObj;
import com.ejie.r01f.util.CollectionConverterException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class CollectionUtils {
    public static Map.Entry getSingleElementFromMap(Map theMap) {
        if (theMap == null) {
            return null;
        }
        Map.Entry outEntry = null;
        Iterator it = theMap.entrySet().iterator();
        if (it.hasNext()) {
            outEntry = it.next();
        }
        return outEntry;
    }

    public static Object[] obtainArraysCommonElements(Object[] arrays, Comparator comparatorImpl) {
        if (arrays != null && arrays.length > 0) {
            ArrayList<Object> outCommonElements = new ArrayList<Object>();
            int currArrayMinLength = Integer.MAX_VALUE;
            int currSmallestArray = -1;
            for (int i = 0; i < arrays.length; ++i) {
                if (((Object[])arrays[i]).length >= currArrayMinLength) continue;
                currArrayMinLength = ((Object[])arrays[i]).length;
                currSmallestArray = i;
            }
            Object[] currArray = null;
            boolean elementFoundInThisArray = false;
            boolean elementFoundInAllArrays = false;
            for (int i = 0; i < ((Object[])arrays[currSmallestArray]).length; ++i) {
                elementFoundInAllArrays = true;
                for (int j = 0; j < arrays.length; ++j) {
                    if (j == currSmallestArray) continue;
                    currArray = (Object[])arrays[j];
                    elementFoundInThisArray = false;
                    for (int k = 0; k < currArray.length; ++k) {
                        try {
                            int comparisionResult = comparatorImpl.compare(currArray[k], ((Object[])arrays[currSmallestArray])[i]);
                            if (comparisionResult != 0) continue;
                            elementFoundInThisArray = true;
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace(System.out);
                        }
                    }
                    if (elementFoundInThisArray) continue;
                    elementFoundInAllArrays = false;
                    break;
                }
                if (!elementFoundInAllArrays) continue;
                outCommonElements.add(((Object[])arrays[currSmallestArray])[i]);
            }
            if (outCommonElements.size() == 0) {
                return null;
            }
            return outCommonElements.toArray(new Object[outCommonElements.size()]);
        }
        return null;
    }

    public static List strArrayToList(String[] strArray) {
        if (strArray == null) {
            return null;
        }
        if (strArray.length == 0) {
            return new Vector();
        }
        Vector<String> outList = new Vector<String>(strArray.length);
        for (int i = 0; i < strArray.length; ++i) {
            outList.add(strArray[i]);
        }
        return outList;
    }

    public static List convertObjectArrayIntoList(Object[] inArray, String listImplName) throws CollectionConverterException {
        if (listImplName == null) {
            throw new CollectionConverterException("No se ha pasado el nombre completo (con paquete) de la implementacion de lista que se desea!!");
        }
        if (inArray == null) {
            return null;
        }
        List outList = null;
        try {
            outList = (List)ReflectionUtils.getObjectInstance(listImplName);
        }
        catch (ReflectionException ex) {
            throw new CollectionConverterException("No se puede obtener una instancia de la lista tipo " + listImplName);
        }
        for (int i = 0; i < inArray.length; ++i) {
            outList.add(inArray[i]);
        }
        return outList;
    }

    public static Map convertArrayIntoMap(Object theArray, String oidMemberName, boolean useAccessors) throws CollectionConverterException {
        String theOidMemberName = oidMemberName;
        if (theOidMemberName == null) {
            theOidMemberName = "key";
        }
        HashMap<Object, Object> outMap = null;
        if (theArray != null) {
            if (!ReflectionUtils.isArray(theArray.getClass())) {
                throw new CollectionConverterException("No se puede convertir el array a mapa ya que el objeto suministrado NO es un array!!");
            }
            outMap = new HashMap<Object, Object>();
            Object currObj = null;
            Object currObjOid = null;
            try {
                for (int i = 0; i < Array.getLength(theArray); ++i) {
                    currObj = Array.get(theArray, i);
                    currObjOid = ReflectionUtils.getMemberValue(currObj, theOidMemberName, useAccessors);
                    outMap.put(currObjOid, currObj);
                }
            }
            catch (ReflectionException refEx) {
                throw new CollectionConverterException("Error al acceder al miembro oid '" + theOidMemberName + "' en un objeto de la coleccion de tipo " + currObj.getClass().getName() + ": " + refEx.getMessage(), (Exception)refEx);
            }
        }
        return outMap;
    }

    public static Map convertListIntoMap(List theList, String oidMemberName, boolean useAccessors) throws CollectionConverterException {
        String theOidMemberName = oidMemberName;
        if (theOidMemberName == null) {
            theOidMemberName = "key";
        }
        HashMap<Object, Object> outMap = null;
        if (theList != null && theOidMemberName != null) {
            outMap = new HashMap<Object, Object>();
            Object currObj2 = null;
            Object currObjOid = null;
            try {
                for (Object currObj2 : theList) {
                    currObjOid = ReflectionUtils.getMemberValue(currObj2, theOidMemberName, useAccessors);
                    outMap.put(currObjOid, currObj2);
                }
            }
            catch (ReflectionException refEx) {
                throw new CollectionConverterException("Error al acceder al miembro oid '" + theOidMemberName + "' en un objeto de la coleccion de tipo " + currObj2.getClass().getName() + ": " + refEx.getMessage(), (Exception)refEx);
            }
        }
        return outMap;
    }

    public static Collection[] obtainChangesInMap(Map mapInState1, Map mapInState2) {
        return CollectionUtils.obtainChangesInMap(false, mapInState1, mapInState2);
    }

    public static Collection[] obtainChangesInMap(boolean strict, Map mapInState1, Map mapInState2) {
        Collection<Object> addedObjects = null;
        Collection<Object> deletedObjects = null;
        ArrayList<Object> existentObjects = null;
        if (mapInState1 == null && mapInState2 == null) {
            return null;
        }
        if (mapInState1 == null && mapInState2 != null) {
            R01FLog.to("r01f.util").info("\t\t\tel mapa en el estado inicial esta vacio... todos los objetos son nuevos");
            addedObjects = mapInState2.keySet();
            return new Collection[]{addedObjects, null, null};
        }
        if (mapInState1 != null && mapInState2 == null) {
            R01FLog.to("r01f.util").info("\t\t\tel mapa en el estado final esta vacio... se han borrado todos los objetos");
            deletedObjects = mapInState1.keySet();
            return new Collection[]{null, deletedObjects, null};
        }
        Object currKey2 = null;
        for (Object currKey2 : mapInState1.keySet()) {
            if (mapInState2.containsKey(currKey2)) {
                R01FLog.to("r01f.util").info("\t\t\tel elemento de clave " + currKey2 + " existe en los dos mapas");
                if (strict && !mapInState2.get(currKey2).getClass().equals(mapInState1.get(currKey2).getClass())) {
                    R01FLog.to("r01f.util").info("\t\t\t\tse ignoran los objetos de clave " + currKey2 + " ya que son de tipos diferentes: state1=" + mapInState1.get(currKey2).getClass() + " - state2=" + mapInState2.get(currKey2).getClass());
                    continue;
                }
                if (existentObjects == null) {
                    existentObjects = new ArrayList<Object>();
                }
                existentObjects.add(currKey2);
                continue;
            }
            R01FLog.to("r01f.util").info("\t\t\tel elemento de clave " + currKey2 + " NO existe en el mapa en el estado 2: se ha borrado!");
            if (deletedObjects == null) {
                deletedObjects = new ArrayList();
            }
            deletedObjects.add(currKey2);
        }
        for (Object currKey2 : mapInState2.keySet()) {
            if (mapInState1.containsKey(currKey2)) continue;
            R01FLog.to("r01f.util").info("\t\t\tel elemento de clave " + currKey2 + " NO existe en el mapa en el estado 1: es nuevo!");
            if (addedObjects == null) {
                addedObjects = new ArrayList();
            }
            addedObjects.add(currKey2);
        }
        return new Collection[]{addedObjects, deletedObjects, existentObjects};
    }

    static String printChangesInMapDebugInfo(Collection[] changes) {
        Iterator it;
        StringBuffer sb = new StringBuffer("");
        sb.append("Cambios en el mapa:\r\n");
        sb.append("\t-Elementos A\u00f1adidos:\r\n");
        if (changes[0] != null) {
            it = changes[0].iterator();
            while (it.hasNext()) {
                sb.append("\t\t" + it.next() + "\r\n");
            }
        }
        sb.append("\t-Elementos borrados:\r\n");
        if (changes[1] != null) {
            it = changes[1].iterator();
            while (it.hasNext()) {
                sb.append("\t\t" + it.next() + "\r\n");
            }
        }
        sb.append("\t-Elementos ya existentes\r\n");
        if (changes[2] != null) {
            it = changes[2].iterator();
            while (it.hasNext()) {
                sb.append("\t\t" + it.next() + "\r\n");
            }
        }
        return sb.toString();
    }

    public static void copyProperties(Properties src_prop, Properties dest_prop) {
        if (src_prop != null && dest_prop != null && !src_prop.isEmpty()) {
            Enumeration<?> propertyNames = src_prop.propertyNames();
            while (propertyNames.hasMoreElements()) {
                Object key = propertyNames.nextElement();
                dest_prop.put(key, src_prop.get(key));
            }
        }
    }

    public static void main(String[] args) {
        try {
            boolean test1 = false;
            boolean test2 = true;
            long t1 = System.currentTimeMillis();
            for (int i = 0; i < 100; ++i) {
                if (test1) {
                    ArrayList<CodeAndValueObj> theList = new ArrayList<CodeAndValueObj>();
                    for (int j = 0; j < 10; ++j) {
                        CodeAndValueObj currObj = new CodeAndValueObj(Integer.toString(j), "Name-" + Integer.toString(j));
                        theList.add(currObj);
                    }
                    Map outMap = CollectionUtils.convertListIntoMap(theList, "_code", false);
                    Map.Entry me2 = null;
                    for (Map.Entry me2 : outMap.entrySet()) {
                        R01FLog.to("r01f.test").info(me2.getKey() + "--->" + me2.getValue());
                    }
                }
                if (!test2) continue;
                HashMap<String, CodeAndValueObj> map1 = new HashMap<String, CodeAndValueObj>();
                HashMap<String, CodeAndValueObj> map2 = new HashMap<String, CodeAndValueObj>();
                for (int j = 0; j < 10; ++j) {
                    CodeAndValueObj currObj1 = new CodeAndValueObj(Integer.toString(j), "Name-" + Integer.toString(j));
                    CodeAndValueObj currObj2 = new CodeAndValueObj(Integer.toString(j), "Name-" + Integer.toString(j));
                    map1.put(Integer.toString(j), currObj1);
                    map2.put(Integer.toString(j), currObj2);
                }
                CodeAndValueObj newObj11 = new CodeAndValueObj("11", "New-11");
                CodeAndValueObj newObj12 = new CodeAndValueObj("12", "New-12");
                map2.put("11", newObj11);
                map2.put("12", newObj12);
                map2.remove("9");
                map2.remove("1");
                R01FLog.to("r01f.test").info("--->Test set builded!!");
                Collection[] changes = CollectionUtils.obtainChangesInMap(map1, map2);
                R01FLog.to("r01f.test").info("--->Changes in map obtained!!");
                R01FLog.to("r01f.test").info(CollectionUtils.printChangesInMapDebugInfo(changes));
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to("r01f.test").info("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t2) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

