/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.util;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xmlbuilder.XMLNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BrokenRules
extends ArrayList {
    private static final long serialVersionUID = 2955357472834059423L;

    public BrokenRules() {
    }

    public BrokenRules(Collection brokenRules) {
        this.addAll(brokenRules);
    }

    public BrokenRules(InputStream is) {
        if (is == null) {
            return;
        }
        try {
            Collection loadedBrokenRules = this.loadFromXML(is);
            this.addAll(loadedBrokenRules);
        }
        catch (SAXException saxEx) {
            throw new IllegalArgumentException(saxEx.toString());
        }
    }

    public BrokenRules(String inXMLStr) {
        if (inXMLStr == null) {
            return;
        }
        try {
            Collection loadedBrokenRules = this.loadFromXML(new ByteArrayInputStream(inXMLStr.getBytes()));
            this.addAll(loadedBrokenRules);
        }
        catch (SAXException saxEx) {
            throw new IllegalArgumentException(saxEx.toString());
        }
    }

    public Collection loadFromXML(InputStream is) throws SAXException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            BrokenRulesParser brokenRulesParser = new BrokenRulesParser();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(is, (DefaultHandler)brokenRulesParser);
            return brokenRulesParser.outBrokenRules;
        }
        catch (ParserConfigurationException pcEx) {
            throw new SAXException("Error en la configuraci\u00f3n del parser:\r\n" + pcEx.getMessage());
        }
        catch (IOException ioEx) {
            throw new SAXException("Error de IO:\r\n" + ioEx.getMessage());
        }
    }

    @Override
    public boolean add(Object newBrokenRule) {
        if (newBrokenRule instanceof String) {
            return super.add(new BrokenRule((String)newBrokenRule));
        }
        if (newBrokenRule instanceof BrokenRule) {
            return super.add(newBrokenRule);
        }
        throw new IllegalArgumentException("A la clase BrokenRules solo se pueden a\u00f1adir Strings o objetos BrokenRule");
    }

    @Override
    public void add(int index, Object newBrokenRule) {
        if (newBrokenRule instanceof String) {
            super.add(index, new BrokenRule((String)newBrokenRule));
        } else if (newBrokenRule instanceof BrokenRule) {
            super.add(index, newBrokenRule);
        } else {
            throw new IllegalArgumentException("A la clase BrokenRules solo se pueden a\u00f1adir Strings o objetos BrokenRule");
        }
    }

    @Override
    public boolean addAll(Collection brokenRules) {
        Iterator it = brokenRules.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
        return brokenRules.size() > 0;
    }

    @Override
    public boolean addAll(int fromIndex, Collection brokenRules) {
        int i = fromIndex;
        Iterator it = brokenRules.iterator();
        while (it.hasNext()) {
            this.add(i, it.next());
            ++i;
        }
        return brokenRules.size() > 0;
    }

    @Override
    public Object set(int index, Object brokenRule) {
        if (brokenRule instanceof String) {
            return super.set(index, new BrokenRule((String)brokenRule));
        }
        if (brokenRule instanceof BrokenRule) {
            return super.set(index, brokenRule);
        }
        throw new IllegalArgumentException("A la clase BrokenRules solo se pueden a\u00f1adir Strings o objetos BrokenRule");
    }

    public boolean addBrokenRule(int newErrorCode, String newCastellano) {
        return this.add(new BrokenRule(newErrorCode, newCastellano));
    }

    public boolean addBrokenRule(int newErrorCode, String newCastellano, String newEuskera) {
        return this.add(new BrokenRule(newErrorCode, newCastellano, newEuskera));
    }

    public String toXML() {
        XMLNode rulesNode = new XMLNode("brokenRules");
        for (BrokenRule currBrokenRule : this) {
            rulesNode.addSubNode(currBrokenRule.getXMLNode());
        }
        return rulesNode.toString();
    }

    public static void main(String[] argv) {
        String XML = "<?xml version='1.0' encoding='ISO-8859-1'?><brokenRules><brokenRule code='2'><castellano>El dato 'referencia' del objeto PeticionPago es obligatorio y debe tener 13 caracteres</castellano></brokenRule><brokenRule code='3'><castellano>La 'identificacion' del objeto PeticionPago es obligatorio y debe tener al menos 6 caracteres</castellano></brokenRule><brokenRule code='6'><castellano>Cuando el sufijo es mayor de 500, la identificacion es la fecha limite de pago, pero en este caso NO tiene el formato correcto 'dmmaa'</castellano></brokenRule></brokenRules>";
        BrokenRules rules = new BrokenRules(XML);
        for (BrokenRule rule : rules) {
            R01FLog.to("r01f.test").info(rule.toString());
        }
    }

    private class BrokenRulesParser
    extends DefaultHandler {
        private static final String BROKENRULES_TAG_NAME = "brokenRules";
        private static final String BROKENRULE_TAG_NAME = "brokenRule";
        private static final String BROKENRULE_CODE_ATTR_NAME = "code";
        private static final String BROKENRULE_CASTELLANO_TAG_NAME = "castellano";
        private static final String BROKENRULE_EUSKERA_TAG_NAME = "euskera";
        BrokenRules outBrokenRules = null;
        private BrokenRule currRule = null;
        private String currNodeName = null;
        private StringBuffer chars = null;

        @Override
        public void startDocument() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
            String eName = lName;
            if ("".equals(eName)) {
                eName = qName;
            }
            this.currNodeName = eName;
            this.chars = null;
            if (this.currNodeName.equalsIgnoreCase(BROKENRULES_TAG_NAME)) {
                this.outBrokenRules = new BrokenRules();
                return;
            } else if (this.currNodeName.equalsIgnoreCase(BROKENRULE_TAG_NAME)) {
                this.currRule = new BrokenRule();
                if (attrs == null || attrs.getLength() <= 0) throw new SAXException("Error en la definici\u00f3n de la regla rota... no se ha definido el codigo");
                String cod = attrs.getValue(BROKENRULE_CODE_ATTR_NAME);
                if (cod == null) {
                    throw new SAXException("Error en la definici\u00f3n de la regla rota: El c\u00f3digo es nulo");
                }
                try {
                    this.currRule.errorCode = Integer.parseInt(cod);
                    return;
                }
                catch (NumberFormatException nfEx) {
                    throw new SAXException("Error en la definici\u00f3n de la regla rota: El c\u00f3digo no es numerico");
                }
            } else if (this.currNodeName.equalsIgnoreCase(BROKENRULE_CASTELLANO_TAG_NAME)) {
                this.chars = new StringBuffer();
                return;
            } else {
                if (!this.currNodeName.equalsIgnoreCase(BROKENRULE_EUSKERA_TAG_NAME)) return;
                this.chars = new StringBuffer();
            }
        }

        @Override
        public void characters(char[] buf, int offset, int len) {
            String s = new String(buf, offset, len);
            if (this.currNodeName.equalsIgnoreCase(BROKENRULE_CASTELLANO_TAG_NAME) || this.currNodeName.equalsIgnoreCase(BROKENRULE_EUSKERA_TAG_NAME)) {
                this.chars.append(s);
            }
        }

        @Override
        public void endElement(String namespaceURI, String sName, String qName) {
            String eName = sName;
            if ("".equals(eName)) {
                eName = qName;
            }
            if (eName.equalsIgnoreCase(BROKENRULE_CASTELLANO_TAG_NAME)) {
                this.currRule.castellano = this.chars.toString().trim();
            } else if (eName.equalsIgnoreCase(BROKENRULE_EUSKERA_TAG_NAME)) {
                this.currRule.euskera = this.chars.toString().trim();
            } else if (eName.equalsIgnoreCase(BROKENRULE_TAG_NAME)) {
                this.outBrokenRules.add(this.currRule);
            }
        }

        @Override
        public void endDocument() {
        }
    }

    public class BrokenRule {
        public int errorCode;
        public String castellano;
        public String euskera;

        public BrokenRule() {
        }

        public BrokenRule(String newCastellano) {
            this.castellano = newCastellano;
        }

        public BrokenRule(int newErrorCode, String newCastellano) {
            this.errorCode = newErrorCode;
            this.castellano = newCastellano;
        }

        public BrokenRule(int newErrorCode, String newCastellano, String newEuskera) {
            this.errorCode = newErrorCode;
            this.castellano = newCastellano;
            this.euskera = newEuskera;
        }

        public String toString() {
            return "#" + this.errorCode + "# >> " + (this.castellano == null ? "" : this.castellano) + " :: " + (this.euskera == null ? "" : this.euskera);
        }

        public String toXML() {
            return this.getXMLNode().toString();
        }

        public XMLNode getXMLNode() {
            XMLNode ruleNode = new XMLNode("brokenRule");
            ruleNode.addAttribute("code", Integer.toString(this.errorCode));
            if (this.castellano != null && this.castellano.length() > 0) {
                XMLNode castellanoNode = new XMLNode("castellano", this.castellano);
                ruleNode.addSubNode(castellanoNode);
            } else if (this.euskera != null && this.euskera.length() > 0) {
                XMLNode euskeraNode = new XMLNode("euskera", this.euskera);
                ruleNode.addSubNode(euskeraNode);
            }
            return ruleNode;
        }
    }
}

