/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.util;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.BaseBitMap;
import com.ejie.r01f.util.StringUtils;
import java.io.Serializable;

public class BaseStringBitMap
extends BaseBitMap
implements Serializable {
    private static final long serialVersionUID = 3905899957176162570L;
    private int _bitMapStringLength = 0;

    public BaseStringBitMap() {
        this.setBitMap(null);
    }

    public BaseStringBitMap(String newBitMap) throws NumberFormatException {
        this.setBitMap(newBitMap);
        this._bitMapStringLength = newBitMap == null ? 31 : newBitMap.length();
    }

    public String setBitMap(String theBitMap) throws NumberFormatException {
        String prevBitMapStr = this.getBitMapString();
        String fixedBitMap = StringUtils.rPadWithChar(theBitMap, '0', 31);
        super.setBitMap(Integer.parseInt(fixedBitMap, 2));
        return prevBitMapStr;
    }

    public String getBitMapString() {
        String bitMapStr = this.toString();
        return bitMapStr.substring(0, this._bitMapStringLength);
    }

    public void incorporateBitMapInfo(BaseStringBitMap otherFlags) {
        String otherFlagsStr = otherFlags.getBitMapString();
        if (otherFlagsStr.length() > this._bitMapStringLength) {
            this._bitMapStringLength = otherFlagsStr.length();
        }
        super.incorporateBitMapInfo(otherFlags);
    }

    public static void main(String[] args) {
        try {
            long t1 = System.currentTimeMillis();
            int testTimes = 1;
            for (int times = 0; times < testTimes; ++times) {
                BaseStringBitMap bbm = new BaseStringBitMap(null);
                R01FLog.to("r01f.test").info(bbm.composeDebugInfo());
                String map = "1111111";
                R01FLog.to("r01f.test").info("\r\n\r\n\r\n>>>Establecer " + map);
                bbm = new BaseStringBitMap(map);
                R01FLog.to("r01f.test").info(bbm.composeDebugInfo());
                R01FLog.to("r01f.test").info("0 >" + bbm.getBit(0));
                R01FLog.to("r01f.test").info("1 >" + bbm.getBit(1));
                R01FLog.to("r01f.test").info("2 >" + bbm.getBit(2));
                R01FLog.to("r01f.test").info("30>" + bbm.getBit(30));
                String newMap = "001";
                R01FLog.to("r01f.test").info("\r\n\r\n\r\n>>> Cambiar de " + bbm.setBitMap(newMap) + " a " + newMap);
                R01FLog.to("r01f.test").info(bbm.composeDebugInfo());
                R01FLog.to("r01f.test").info("0 >" + bbm.getBit(0));
                R01FLog.to("r01f.test").info("1 >" + bbm.getBit(1));
                R01FLog.to("r01f.test").info("2 >" + bbm.getBit(2));
                R01FLog.to("r01f.test").info("30>" + bbm.getBit(30));
                String otherMap = "1111111110000000000000000000001";
                R01FLog.to("r01f.test").info("\r\n\r\n\r\n>>> Incorporar " + otherMap + " a " + bbm.getBitMapString());
                bbm.incorporateBitMapInfo(new BaseStringBitMap(otherMap));
                R01FLog.to("r01f.test").info(bbm.composeDebugInfo());
                R01FLog.to("r01f.test").info("0 >" + bbm.getBit(0));
                R01FLog.to("r01f.test").info("1 >" + bbm.getBit(1));
                R01FLog.to("r01f.test").info("2 >" + bbm.getBit(2));
                R01FLog.to("r01f.test").info("30>" + bbm.getBit(30));
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to("r01f.test").info("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t1) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

