/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.textsearch;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.log.SimpleFileLogger;
import com.ejie.r01f.textsearch.DirectoryTextSearch;
import com.ejie.r01f.textsearch.FilteredFileTextSearch;
import com.ejie.r01f.textsearch.PatternMatchSearch;
import com.ejie.r01f.textsearch.TextSearchLogger;
import com.ejie.r01f.util.MainParamsParser;
import java.util.HashMap;

public class TestSearch {
    public static void main(String[] args) {
        try {
            MainParamsParser params = new MainParamsParser();
            params.addParamDef("-patternRegExp", "Expresion regular para buscar links", MainParamsParser.PARAM_TYPE_GENERAL, true);
            params.addParamDef("-logFile", "Fichero de log", MainParamsParser.PARAM_TYPE_ALFANUMERIC, false);
            params.parseParams(args);
            if (params.areValid()) {
                SimpleFileLogger logger = new SimpleFileLogger(params.getParam("-logFile"));
                logger.start();
                TextSearchLogger eventListener = new TextSearchLogger(logger);
                HashMap context = new HashMap();
                PatternMatchSearch textSearch = null;
                textSearch = new PatternMatchSearch(params.getParam("-patternRegExp"), eventListener);
                params.addParamDef("-srcFile", "Fichero de origen", MainParamsParser.PARAM_TYPE_ALFANUMERIC, true);
                params.parseParams(args);
                if (params.areValid()) {
                    R01FLog.to("r01f.test").info("CASO 1: Un \u00fanico fichero....");
                    R01FLog.to("r01f.test").info(params.toString());
                    FilteredFileTextSearch fileTextSearch = new FilteredFileTextSearch("<", ">", eventListener);
                    fileTextSearch.doSearch(context, params.getParam("-srcFile"), textSearch);
                } else {
                    params.removeParamDef("-srcFile");
                    params.addParamDef("-dir", "Directorio", MainParamsParser.PARAM_TYPE_ALFANUMERIC, true);
                    params.addParamDef("-fileFilterExpr", "Expresion que han de verificar los nombres de los ficheros", MainParamsParser.PARAM_TYPE_GENERAL, false);
                    params.parseParams(args);
                    if (params.areValid()) {
                        R01FLog.to("r01f.test").info("CASO 2: Un directorio....");
                        R01FLog.to("r01f.test").info(params.toString());
                        DirectoryTextSearch dirReplacer = new DirectoryTextSearch(eventListener);
                        dirReplacer.doReplace(context, params.getParam("-dir"), params.getParam("-fileFilterExpr"), textSearch, new FilteredFileTextSearch("<", ">", eventListener));
                    } else {
                        R01FLog.to("r01f.test").info("ERROR EN LOS PARAMETROS DE ENTRADA!!!!");
                        R01FLog.to("r01f.test").info(TestSearch._composeHelpMsg());
                    }
                }
                logger.stop();
                R01FLog.to("r01f.test").info("FIN!!!!!");
            } else {
                R01FLog.to("r01f.test").info("ERROR EN LOS PARAMETROS DE ENTRADA!!!!");
                R01FLog.to("r01f.test").info(TestSearch._composeHelpMsg());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            R01FLog.to("r01f.test").info("Exception!!!" + ex.toString());
        }
    }

    private static String _composeHelpMsg() {
        StringBuffer sb = new StringBuffer("");
        MainParamsParser params = new MainParamsParser();
        params.addParamDef("-patternRegExp", "Expresion regular para buscar el texto del enlace", MainParamsParser.PARAM_TYPE_GENERAL, true);
        params.addParamDef("-logFile", "Fichero de log", MainParamsParser.PARAM_TYPE_ALFANUMERIC, false);
        sb.append("Utilizacion:\r\n");
        sb.append("-----------------------------------------------------\r\n");
        sb.append("Para remplazar texto en un unico fichero: \r\n");
        params.addParamDef("-srcFile", "Fichero de origen", MainParamsParser.PARAM_TYPE_ALFANUMERIC, true);
        sb.append(params.getParamsUsageMessage());
        sb.append("\r\n\r\n");
        sb.append("Para remplazar texto en varios ficheros en una estructura de directorios:\r\n");
        params.removeParamDef("-srcFile");
        params.addParamDef("-dir", "Directorio", MainParamsParser.PARAM_TYPE_ALFANUMERIC, true);
        params.addParamDef("-fileFilterExpr", "Expresion que han de verificar los nombres de los ficheros", MainParamsParser.PARAM_TYPE_GENERAL, false);
        sb.append(params.getParamsUsageMessage());
        return sb.toString();
    }
}

