/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.textsearch;

import com.ejie.r01f.io.filters.DirectiveFilterReader;
import com.ejie.r01f.io.filters.DirectiveListener;
import com.ejie.r01f.textsearch.FileTextSearch;
import com.ejie.r01f.textsearch.TextSearch;
import com.ejie.r01f.textsearch.TextSearchEventListener;
import java.io.FileReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;

public class FilteredFileTextSearch
implements DirectiveListener,
FileTextSearch {
    private String _directiveBeginningDelimiter = null;
    private String _directiveEndingDelimiter = null;
    private TextSearch _textSearch = null;
    private TextSearchEventListener _eventListener = null;
    private Map _context = null;

    public FilteredFileTextSearch(String beginningDelimiter, String endingDelimiter) {
        this._directiveBeginningDelimiter = beginningDelimiter;
        this._directiveEndingDelimiter = endingDelimiter;
    }

    public FilteredFileTextSearch(String beginningDelimiter, String endingDelimiter, TextSearchEventListener eventListener) {
        this(beginningDelimiter, endingDelimiter);
        this._eventListener = eventListener;
    }

    @Override
    public char[] processDirective(String directiveText, long index) {
        this._textSearch.doSearch(this._context, directiveText);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSearch(Map context, String srcFile, TextSearch textSearch) throws IOException {
        InputStreamReader reader = null;
        FilterReader fileFilterReader = null;
        try {
            this._context = context;
            this._textSearch = textSearch;
            this._context.put("currentFile", srcFile);
            if (this._eventListener != null) {
                this._eventListener.beforeFileProcesed(this._context, srcFile);
            }
            if ((reader = new FileReader(srcFile)) == null) {
                throw new IOException("No se ha podido abrir el fichero origen!!!\r\n");
            }
            fileFilterReader = new DirectiveFilterReader(reader);
            ((DirectiveFilterReader)fileFilterReader).addListener(this, this._directiveBeginningDelimiter, this._directiveEndingDelimiter);
            int c = 0;
            while ((c = ((DirectiveFilterReader)fileFilterReader).read()) > 0) {
            }
            if (this._eventListener != null) {
                this._eventListener.fileProcesed(this._context, srcFile);
            }
        }
        finally {
            if (fileFilterReader != null) {
                fileFilterReader.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }
}

