/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.taglibs.xtags;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.taglibs.util.ResponseUtils;
import com.ejie.r01f.taglibs.xtags.objects.TabData;
import com.ejie.r01f.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public class TabsTag
extends TagSupport {
    private static final long serialVersionUID = -2766430330716694537L;
    private String _name = "r01Tabs";
    private String _menuPosition = "Left";
    List tabs;

    public void release() {
        super.release();
        this._name = "r01Tabs";
        this._menuPosition = "Left";
        this.tabs = null;
    }

    public int doStartTag() {
        R01FLog.to("r01f.xTags").info("Abriendo XTag:Tabs");
        this.tabs = new ArrayList();
        return 1;
    }

    public int doEndTag() throws JspException {
        R01FLog.to("r01f.xTags").info("Cerrando XTag:Tabs");
        ResponseUtils.write(this.pageContext, this._composeHtml());
        this.tabs = null;
        return 6;
    }

    private String _composeHtml() {
        StringBuffer sb = new StringBuffer();
        sb.append("<div id='tabs" + StringUtils.capitalizeFirstLetter(this._name) + "'>\r\n");
        sb.append("<table align='center' width='100%'>\r\n");
        if (this._menuPosition.equalsIgnoreCase("Left")) {
            sb.append("\t<tr valign='top'>\r\n");
            sb.append(this._composeMenuHtml());
            sb.append(this._composeTabsHtml());
            sb.append("\t</tr>\r\n");
        } else if (this._menuPosition.equalsIgnoreCase("Right")) {
            sb.append("\t<tr valign='top'>\r\n");
            sb.append(this._composeTabsHtml());
            sb.append(this._composeMenuHtml());
            sb.append("\t</tr>\r\n");
        } else if (this._menuPosition.equalsIgnoreCase("Top")) {
            sb.append("\t<tr valign='top'>\r\n");
            sb.append(this._composeMenuHtml());
            sb.append("<\t</tr>\r\n");
            sb.append("\t<tr valign='top'>\r\n");
            sb.append(this._composeTabsHtml());
            sb.append("\t</tr>\r\n");
        } else if (this._menuPosition.equalsIgnoreCase("Bottom")) {
            sb.append("\t<tr valign='top'>\r\n");
            sb.append(this._composeTabsHtml());
            sb.append("\t</tr>\r\n");
            sb.append("\t<tr valign='top'>\r\n");
            sb.append(this._composeMenuHtml());
            sb.append("\t</tr>\r\n");
        }
        sb.append("\t</table>\r\n");
        sb.append("</div>\r\n");
        sb.append(this._composeJavaScript());
        return sb.toString();
    }

    private String _composeMenuHtml() {
        StringBuffer sb = new StringBuffer();
        String menuWidth = "10%";
        if (this._menuPosition.equalsIgnoreCase("Top") || this._menuPosition.equalsIgnoreCase("Bottom")) {
            menuWidth = "100%";
        }
        sb.append("<td width='" + menuWidth + "'>\r\n");
        sb.append("\t<table width='100px' class='r01TabsMenuBox'>\r\n");
        for (TabData currTabData : this.tabs) {
            String tabMenuId = "menu" + StringUtils.capitalizeFirstLetter(this._name) + StringUtils.capitalizeFirstLetter(currTabData.name);
            sb.append("\t\t<tr align='left' ><td><a id='" + tabMenuId + "' class='r01TabsMenuOptHigh' href='#' onClick='oTabs" + StringUtils.capitalizeFirstLetter(this._name) + ".selectTab(\"" + StringUtils.capitalizeFirstLetter(currTabData.name) + "\")'>" + currTabData.menuText + "</a></td></tr>\r\n");
        }
        sb.append("\t</table>\r\n");
        sb.append("</td>\r\n");
        return sb.toString();
    }

    private String _composeTabsHtml() {
        StringBuffer sb = new StringBuffer();
        sb.append("<td width='100%'>\r\n");
        sb.append("\t<table width='100%'>\r\n");
        for (TabData currTabData : this.tabs) {
            String tabRowId = "tab" + StringUtils.capitalizeFirstLetter(this._name) + StringUtils.capitalizeFirstLetter(currTabData.name);
            sb.append("\t\t<tr id='" + tabRowId + "'><td>" + currTabData.tabHtml + "</td></tr>\r\n");
        }
        sb.append("\t</table>\r\n");
        sb.append("</td>\r\n");
        return sb.toString();
    }

    private String _composeJavaScript() {
        StringBuffer paramsSb = new StringBuffer();
        paramsSb.append("'" + StringUtils.capitalizeFirstLetter(this._name) + "'");
        paramsSb.append(",");
        Iterator it = this.tabs.iterator();
        while (it.hasNext()) {
            TabData currTabData = (TabData)it.next();
            paramsSb.append("'" + StringUtils.capitalizeFirstLetter(currTabData.name) + "'");
            if (!it.hasNext()) continue;
            paramsSb.append(",");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<script>\r\n");
        String objName = "oTabs" + StringUtils.capitalizeFirstLetter(this._name);
        sb.append("\tvar " + objName + " = new Tabs(" + paramsSb.toString() + ");\r\n");
        if (this.tabs.size() > 0) {
            sb.append("\t" + objName + ".selectTab('" + StringUtils.capitalizeFirstLetter(((TabData)this.tabs.get((int)0)).name) + "');\r\n");
        }
        sb.append("</script>\r\n");
        return sb.toString();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String x) {
        this._name = x;
    }

    public String getMenuPosition() {
        return this._menuPosition;
    }

    public void setMenuPosition(String x) {
        if (x == null) {
            this._menuPosition = "Left";
            return;
        }
        this._menuPosition = x.equalsIgnoreCase("Top") || x.equalsIgnoreCase("Bottom") || x.equalsIgnoreCase("Left") || x.equalsIgnoreCase("Right") ? x : "Left";
    }
}

