/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.taglibs.xtags;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.rpcdispatcher.search.Search;
import com.ejie.r01f.rpcdispatcher.search.SearchParameter;
import com.ejie.r01f.taglibs.util.ResponseUtils;
import com.ejie.r01f.taglibs.util.TagLibsUtils;
import com.ejie.r01f.taglibs.xtags.objects.SearchCellData;
import com.ejie.r01f.taglibs.xtags.objects.SearchRowData;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLLiterals;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;

public class SearchTag
extends TagSupport {
    private static final long serialVersionUID = 1L;
    private String _name = "buscador";
    private String _rpcExecName = "busqueda";
    private String _searchID = "busqueda01";
    private Search _buscador;
    private String _codAplic = "r01ft";
    private String _language = "es";
    private boolean _showHeader = true;
    List rows;
    SearchRowData rowHeader;

    public void release() {
        super.release();
        this._name = "buscador";
        this._rpcExecName = "busqueda";
        this._buscador = null;
        this._codAplic = "r01ft";
        this._language = "cast";
        this._showHeader = true;
    }

    public int doStartTag() {
        R01FLog.to("r01f.xTags").info("Abriendo XTAG:Search");
        return 1;
    }

    public int doEndTag() throws JspException {
        R01FLog.to("r01f.xTags").info("Cerrando XTAG:Search");
        if (this.rows == null) {
            throw new JspTagException("No se han definido filas (tag 'searchRow') en el tag 'search'. Revisa el codigo fuente");
        }
        if (this.rows.size() == 0) {
            throw new JspTagException("No se han definido filas (tag 'searchRow') en el tag 'search'. Revisa el codigo fuente");
        }
        ResponseUtils.write(this.pageContext, this._composeHTML());
        return 6;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String x) {
        this._name = x;
    }

    public Search getBuscador() {
        return this._buscador;
    }

    public void setBuscador(Search x) {
        this._buscador = x;
    }

    public String getRpcExecName() {
        return this._rpcExecName;
    }

    public void setRpcExecName(String x) {
        this._rpcExecName = x;
    }

    public String getSearchID() {
        return this._searchID;
    }

    public void setSearchID(String x) {
        this._searchID = x;
    }

    public String getCodigoAplicacion() {
        return this._codAplic;
    }

    public void setCodigoAplicacion(String x) {
        this._codAplic = x;
    }

    public boolean showHeader() {
        return this._showHeader;
    }

    public void setShowHeader(boolean x) {
        this._showHeader = x;
    }

    public String getLanguage() {
        return this._language;
    }

    public void setLanguage(String x) {
        this._language = x;
    }

    private String _composeHTML() {
        StringBuffer sb = new StringBuffer();
        String searchObjVarName = "oSrch" + StringUtils.capitalizeFirstLetter(this._name);
        sb.append("\r\n");
        sb.append("<script>\r\n");
        sb.append("\t// Objeto que maneja los eventos de la busqueda..\r\n");
        sb.append("\tvar " + searchObjVarName + " = new SearchNav(oRpcForm,'" + this._rpcExecName + "','" + this._searchID + "');\r\n");
        sb.append("</script>\r\n");
        sb.append("<table class='r01Default'>\r\n");
        if (this._showHeader) {
            sb.append("<tr><td><!-- Cabecera con la descripci\u00f3n de la b\u00fasqueda -->\r\n");
            sb.append(this._composeHeaderHTML());
            sb.append("</td></tr>\r\n");
        }
        if (this._buscador != null && this._buscador.resultados != null) {
            sb.append("<tr><td><!-- Barra de navegaci\u00f3n por las p\u00e1ginas encontradas -->\r\n");
            sb.append(this._composeNavBarHTML());
            sb.append("</td></tr>\r\n");
            sb.append("<tr><td><!-- Resultados de la b\u00fasqueda -->\r\n");
            sb.append(this._composeSearchResultsHTML());
            sb.append("</td></tr>\r\n");
            sb.append("<tr><td><!-- Barra de navegaci\u00f3n por las p\u00e1ginas encontradas -->\r\n");
            sb.append(this._composeNavBarHTML());
            sb.append("</td></tr>\r\n");
        }
        sb.append("</table>\r\n");
        return sb.toString();
    }

    private String _composeHeaderHTML() {
        XMLLiterals lits = new XMLLiterals(this._codAplic, this._language);
        StringBuffer sb = new StringBuffer();
        if (this._buscador != null) {
            sb.append("<table>\r\n");
            sb.append("<tr><td>\r\n");
            sb.append("<table class='" + this._codAplic + "SearchHeaderBox'>\r\n");
            sb.append("<tr class='" + this._codAplic + "SearchHeadTitle'><td>" + lits.get("busqueda/cabecera/titulo") + "</td></tr>\r\n");
            sb.append("<tr class='" + this._codAplic + "SearchHeadText'><td><strong>\r\n");
            if (this._buscador.paginas != null) {
                if (this._buscador.paramsBusqueda != null && this._buscador.paramsBusqueda.size() > 0) {
                    sb.append(lits.customize("busqueda/cabecera/resultadosConParametros", new String[]{Integer.toString(this._buscador.paginas.getElementCount())}) + "\r\n");
                } else {
                    sb.append(lits.customize("busqueda/cabecera/resultadosSinParametros", new String[]{Integer.toString(this._buscador.paginas.getElementCount())}) + "\r\n");
                }
            } else {
                sb.append(lits.get("busqueda/cabecera/noResultados") + "\r\n");
            }
            sb.append("</strong></td></tr>\r\n");
            if (this._buscador.paramsBusqueda != null) {
                Map.Entry me2 = null;
                sb.append("<tr class='" + this._codAplic + "SearchHeadText'><td><!-- Resumen de la b\u00fasqueda -->\r\n");
                for (Map.Entry me2 : this._buscador.paramsBusqueda.entrySet()) {
                    SearchParameter currParam = (SearchParameter)me2.getValue();
                    String descripton = currParam.getDescription();
                    if (currParam == null || descripton == null) continue;
                    sb.append(descripton + "<br/>\r\n");
                }
                sb.append("</td></tr>\r\n");
            }
            sb.append("</table>\r\n");
            sb.append("</td></tr>\r\n");
            if (this._buscador.paginas != null) {
                sb.append("<tr><td>\r\n");
                sb.append("<table align='center'>\r\n");
                sb.append("<tr class='" + this._codAplic + "SearchHeadText'><td>\r\n");
                sb.append(lits.customize("busqueda/localizadorPagina", new String[]{Integer.toString(this._buscador.paginas.getCurrentPageElementNumber()), Integer.toString(this._buscador.paginas.getPageCount())}) + "<br>\r\n");
                sb.append(lits.customize("busqueda/localizadorResultados", new String[]{Integer.toString(this._buscador.paginas.getCurrentPageFirstElementNumber()), Integer.toString(this._buscador.paginas.getCurrentPageLastElementNumber())}) + "\r\n");
                sb.append("</td></tr>\r\n");
                sb.append("</table>\r\n");
                sb.append("</td></tr>\r\n");
            }
            sb.append("</table>\r\n");
        }
        return sb.toString();
    }

    private String _composeSearchResultsHTML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<table width='100%'>\r\n");
        if (this.rowHeader != null) {
            sb.append("<tr>\r\n");
            sb.append("\t<td>&nbsp;</td>\r\n");
            for (SearchCellData currCell : this.rowHeader.cells) {
                String text = currCell.src;
                String href = currCell.href;
                sb.append("<td " + (currCell.styleClass == null ? "" : "class='" + currCell.styleClass + "' ") + (currCell.style == null ? "" : "style=\"" + TagLibsUtils.fixQuotations(currCell.style) + "\" ") + (currCell.width == null ? "" : "width='" + currCell.width + "' ") + "colspan='" + currCell.colspan + "'>\r\n");
                if (href != null) {
                    sb.append("<a" + (href != null ? " href=\"" + TagLibsUtils.fixQuotations(href) + "\" " : " ") + "style='text-decoration: none;'>\r\n");
                }
                sb.append((text == null ? "" : text) + "\r\n");
                if (href != null) {
                    sb.append("</a>\r\n");
                }
                sb.append("</td>\r\n");
            }
            sb.append("</tr>\r\n");
        }
        Map element2 = null;
        int nProc = this._buscador.paginas.getCurrentPageFirstElementNumber();
        for (Map element2 : this._buscador.resultados) {
            sb.append("<tr>\r\n");
            int nRows = this.rows.size() + 1;
            sb.append("\t<td class='" + this._codAplic + "SearchResultNumber' rowSpan='" + nRows + "'>" + nProc++ + "</td>\r\n");
            sb.append("</tr>\r\n");
            for (SearchRowData currRow : this.rows) {
                sb.append("<tr>\r\n");
                for (SearchCellData currCell : currRow.cells) {
                    String text = (String)element2.get(currCell.src);
                    String href = (String)element2.get(currCell.href);
                    sb.append("\t<td " + (currCell.styleClass == null ? "" : "class='" + currCell.styleClass + "' ") + (currCell.style == null ? "" : "style=\"" + TagLibsUtils.fixQuotations(currCell.style) + "\" ") + (currCell.width == null ? "" : "width='" + currCell.width + "' ") + "colspan='" + currCell.colspan + "'>\r\n");
                    if (href != null) {
                        sb.append("<a" + (href != null ? " href=\"" + TagLibsUtils.fixQuotations(href) + "\" " : " ") + "style='text-decoration: none;'>\r\n");
                    }
                    sb.append((text == null ? "" : text) + "\r\n");
                    if (href != null) {
                        sb.append("</a>\r\n");
                    }
                    sb.append("\t</td>\r\n");
                }
                sb.append("</tr>\r\n");
            }
        }
        sb.append("</table>\r\n");
        return sb.toString();
    }

    private String _composeNavBarHTML() {
        XMLLiterals lits = new XMLLiterals(this._codAplic, this._language);
        String searchObjVarName = "oSrch" + StringUtils.capitalizeFirstLetter(this._name);
        StringBuffer sb = new StringBuffer();
        if (this._buscador.paginas.getPageCount() == 1) {
            sb.append("<table width='100%' class='" + this._codAplic + "SearchNavBar'><tr><td>&nbsp;</td></tr></table>\r\n");
        } else {
            sb.append("<table class='" + this._codAplic + "SearchNavBar'><tr>\r\n");
            if (this._buscador.paginas.getCurrentPageElementNumber() > 1) {
                sb.append("<td width='2%' align='right'>\r\n");
                sb.append("<a href='JavaScript:" + searchObjVarName + ".prevPg()' class='" + this._codAplic + "SearchNavBarBookMark'>&lt;&lt;</a>\r\n");
                sb.append("</td>\r\n");
                sb.append("<td width='18%' align='left'>\r\n");
                sb.append("<a href='JavaScript:" + searchObjVarName + ".prevPg()' class='" + this._codAplic + "SearchNavBarBookMark'>" + lits.get("busqueda/paginador/paginaAnterior") + "</a>\r\n");
                sb.append("</td>\r\n");
            } else {
                sb.append("<td width='2%' align='right'>&nbsp;</td>\r\n");
                sb.append("<td width='18%' align='left'>&nbsp;</td>\r\n");
            }
            sb.append("<td align='center'>\r\n");
            for (int i = 0; i < this._buscador.paginas.getCurrentBlockPageNumbers().length; ++i) {
                if (this._buscador.paginas.getCurrentBlockPageNumbers()[i] == this._buscador.paginas.getCurrentPageElementNumber()) {
                    sb.append("<font color='black'>" + this._buscador.paginas.getCurrentBlockPageNumbers()[i] + "</font>\r\n");
                    continue;
                }
                sb.append("<a href='JavaScript:" + searchObjVarName + ".pg(" + this._buscador.paginas.getCurrentBlockPageNumbers()[i] + ")' class='" + this._codAplic + "SearchNavBarBookMark'>" + this._buscador.paginas.getCurrentBlockPageNumbers()[i] + "</a>\r\n");
            }
            sb.append("</td>\r\n");
            if (this._buscador.paginas.getCurrentPageElementNumber() < this._buscador.paginas.getPageCount()) {
                sb.append("<td width='18%' align='right'>\r\n");
                sb.append("<a href='JavaScript:" + searchObjVarName + ".nextPg()' class='" + this._codAplic + "SearchNavBarBookMark'>" + lits.get("busqueda/paginador/paginaSiguiente") + "</a>\r\n");
                sb.append("</td>\r\n");
                sb.append("<td width='2%' align='right'>\r\n");
                sb.append("<a href='JavaScript:" + searchObjVarName + ".nextPg()' class='" + this._codAplic + "SearchNavBarBookMark'>&gt;&gt;</a>\r\n");
                sb.append("</td>\r\n");
            } else {
                sb.append("<td width='18%' align='right'>&nbsp;</td>\r\n");
                sb.append("<td width='2%' align='right'>&nbsp;</td>\r\n");
            }
            sb.append("</tr></table>\r\n");
        }
        return sb.toString();
    }
}

