/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.taglibs.xtags;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.taglibs.util.ResponseUtils;
import com.ejie.r01f.taglibs.xtags.BaseXTagWithEvents;
import com.ejie.r01f.taglibs.xtags.objects.XTagConstants;
import com.ejie.r01f.util.StringUtils;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;

public abstract class BaseInputXTag
extends BaseXTagWithEvents {
    private static final long serialVersionUID = -4165134423849114031L;
    protected String _type = null;
    protected String _value = null;
    protected String _cols = null;
    protected String _rows = null;
    protected String _maxlength = null;

    @Override
    public void release() {
        super.release();
        this._cols = null;
        this._rows = null;
        this._maxlength = null;
        this._value = null;
    }

    public int doStartTag() throws JspException {
        R01FLog.to("r01f.xTags").info("Abriendo XTAG:Input '" + this._fullPathName + "'");
        if (!this._generateHTML) {
            return 0;
        }
        int retValue = 2;
        StringBuffer sb = new StringBuffer();
        switch (this._tagType) {
            case 20: 
            case 22: 
            case 23: {
                ResponseUtils.write(this.pageContext, this._composeInputTag());
                retValue = 2;
                break;
            }
            case 21: {
                ResponseUtils.write(this.pageContext, this._composeTextAreaTag());
                retValue = 2;
                break;
            }
        }
        return retValue;
    }

    protected String _composeInputTag() {
        StringBuffer sb = new StringBuffer();
        sb.append("<input type=\"" + this._type + "\"");
        sb.append(this._prepareXTagAttrs());
        sb.append(this._prepareCommonAttrs());
        sb.append(" value=\"" + (this._value == null ? "" : StringUtils.filterChars(this._value, XTagConstants.htmlToEscapeChars, XTagConstants.htmlEscapedChars)) + "\"");
        sb.append(this._prepareNavigationAttrs());
        if (this._tagType == 20) {
            if (this._maxlength != null) {
                sb.append(" maxlength=\"" + this._maxlength + "\"");
            }
            if (this._cols != null) {
                sb.append(" size=\"" + this._cols + "\"");
            }
        }
        if (this._type.equalsIgnoreCase("file")) {
            // empty if block
        }
        sb.append(this._prepareStyles());
        sb.append(this._prepareEventHandlers());
        sb.append("/>");
        return sb.toString();
    }

    protected String _composeTextAreaTag() {
        StringBuffer sb = new StringBuffer();
        sb.append("<textarea");
        sb.append(this._prepareXTagAttrs());
        sb.append(this._prepareCommonAttrs());
        sb.append(this._prepareNavigationAttrs());
        if (this._cols != null) {
            sb.append(" cols=\"" + this._cols + "\"");
        }
        if (this._rows != null) {
            sb.append(" rows=\"" + this._rows + "\"");
        }
        sb.append(this._prepareStyles());
        sb.append(this._prepareEventHandlers());
        sb.append(">");
        return sb.toString();
    }

    public int doAfterBody() throws JspException {
        int retCode = 0;
        try {
            switch (this._tagType) {
                case 21: {
                    BodyContent currBodyContent = this.getBodyContent();
                    String bodyStr = currBodyContent.getString();
                    if (this._value != null) {
                        bodyStr = bodyStr + this._value;
                    }
                    bodyStr = StringUtils.filterChars(bodyStr, XTagConstants.htmlToEscapeChars, XTagConstants.htmlEscapedChars);
                    JspWriter out = this.bodyContent.getEnclosingWriter();
                    out.println(bodyStr);
                    this.bodyContent.writeOut((Writer)this.pageContext.getOut());
                    retCode = 0;
                    break;
                }
                default: {
                    retCode = 0;
                }
            }
            return retCode;
        }
        catch (IOException ioEx) {
            throw new JspTagException("Error al escribir el cuerpo de un tag: " + ioEx.getMessage());
        }
    }

    public int doEndTag() throws JspException {
        R01FLog.to("r01f.xTags").info("Cerrando XTAG:Input '" + this._fullPathName + "'");
        if (this._generateJS) {
            this._registerChildTag();
        }
        if (!this._generateHTML) {
            return 6;
        }
        switch (this._tagType) {
            case 21: {
                ResponseUtils.write(this.pageContext, "</textarea>");
                break;
            }
        }
        return 6;
    }

    public String getCols() {
        return this._cols;
    }

    public void setCols(String cols) {
        this._cols = cols;
    }

    public String getRows() {
        return this._rows;
    }

    public void setRows(String rows) {
        this._rows = rows;
    }

    public String getSize() {
        return this.getCols();
    }

    public void setSize(String size) {
        this.setCols(size);
    }

    public String getMaxlength() {
        return this._maxlength;
    }

    public void setMaxlength(String maxlength) {
        this._maxlength = maxlength;
    }

    public String getValue() {
        if (this._value == null) {
            return "";
        }
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
    }
}

