/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.sql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class SQLHelpper {
    static String composeSelect(List columns, List tables, String where, int[] columnsOrder, boolean desc, boolean distinct) {
        StringBuffer sb = new StringBuffer("");
        if (!distinct) {
            sb.append("SELECT ");
            sb.append(SQLHelpper._listToCommaDelimitedString(columns));
        } else {
            sb.append("SELECT DISTINCT ");
            sb.append(SQLHelpper._listToCommaDelimitedString(columns));
        }
        sb.append(" FROM ");
        sb.append(SQLHelpper._listToCommaDelimitedString(tables));
        if (where != null && where.length() > 0) {
            sb.append(" WHERE ");
            sb.append(where);
        }
        if (columnsOrder != null) {
            sb.append(" ORDER BY ");
            for (int i = 0; i < columnsOrder.length; ++i) {
                sb.append(columnsOrder[i]);
                if (i == columnsOrder.length - 1) continue;
                sb.append(", ");
            }
            if (desc) {
                sb.append(" DESC");
            }
        }
        return sb.toString();
    }

    static String composeInsert(List insertData, String table) {
        StringBuffer sbCols = new StringBuffer("");
        StringBuffer sbValues = new StringBuffer("");
        DBData currDBData = null;
        Iterator it = insertData.iterator();
        while (it.hasNext()) {
            currDBData = (DBData)it.next();
            if (currDBData.value == null) continue;
            sbCols.append(currDBData.columnName);
            if (currDBData.isNumeric) {
                sbValues.append(currDBData.value);
            } else {
                sbValues.append("'");
                sbValues.append(SQLHelpper._escapeString(currDBData.value));
                sbValues.append("'");
            }
            if (!it.hasNext()) continue;
            sbCols.append(",");
            sbValues.append(",");
        }
        StringBuffer sbOut = new StringBuffer("");
        sbOut.append("INSERT INTO " + table);
        sbOut.append(" (");
        sbOut.append(sbCols.toString());
        sbOut.append(") ");
        sbOut.append("VALUES");
        sbOut.append(" (");
        sbOut.append(sbValues.toString());
        sbOut.append(") ");
        return sbOut.toString();
    }

    static String composeUpdate(List updateData, String table, String where) {
        StringBuffer sb = new StringBuffer("");
        sb.append("UPDATE " + table + " SET ");
        DBData currDBData = null;
        Iterator it = updateData.iterator();
        while (it.hasNext()) {
            currDBData = (DBData)it.next();
            if (currDBData.value == null) continue;
            if (currDBData.isNumeric) {
                sb.append(currDBData.columnName);
                sb.append("=");
                sb.append(currDBData.value);
            } else {
                sb.append(currDBData.columnName);
                sb.append("= '");
                sb.append(SQLHelpper._escapeString(currDBData.value));
                sb.append("'");
            }
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        if (where != null && where.length() > 0) {
            sb.append(" WHERE ");
            sb.append(where);
        }
        return sb.toString();
    }

    static String composeDelete(String table, String where) {
        StringBuffer sb = new StringBuffer("");
        sb.append("DELETE FROM ");
        sb.append(table);
        if (where != null && where.length() > 0) {
            sb.append(" WHERE ");
            sb.append(where);
        }
        return sb.toString();
    }

    private static String _escapeString(String str) {
        StringBuffer sbEscape = new StringBuffer(str);
        for (int i = 0; i < sbEscape.length(); ++i) {
            if (sbEscape.charAt(i) != '\'') continue;
            sbEscape.replace(i, i, "'");
            ++i;
        }
        return sbEscape.toString();
    }

    private static String _listToCommaDelimitedString(List list) {
        StringBuffer sb = new StringBuffer("");
        Iterator it = list.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static DBData createDBData(String columnName, String value) {
        DBDataListCreator dbDataListCreator = new SQLHelpper().new DBDataListCreator();
        return dbDataListCreator.addDBData(columnName, value);
    }

    public static DBData createDBData(String columnName, String value, boolean isNumeric) {
        DBDataListCreator dbDataListCreator = new SQLHelpper().new DBDataListCreator();
        return dbDataListCreator.addDBData(columnName, value, isNumeric);
    }

    public class DBDataListCreator {
        private List _dbDataList = new ArrayList();

        public DBData addDBData(String inColumnName, String inValue, boolean inIsNumeric) {
            if (inValue == null) {
                return null;
            }
            SQLHelpper sQLHelpper = new SQLHelpper();
            sQLHelpper.getClass();
            DBData dbData = sQLHelpper.new DBData(inColumnName, inValue, inIsNumeric);
            this._dbDataList.add(dbData);
            return dbData;
        }

        public DBData addDBData(String inColumnName, String inValue) {
            return this.addDBData(inColumnName, inValue, false);
        }

        public List getDBDataList() {
            return this._dbDataList;
        }
    }

    public class DBData {
        String columnName;
        String value;
        boolean isNumeric;

        public DBData(String inColumnName, String inValue, boolean inIsNumeric) {
            this.columnName = inColumnName;
            this.value = inValue;
            this.isNumeric = inIsNumeric;
        }

        public DBData(String inColumnName, String inValue) {
            this(inColumnName, inValue, false);
        }
    }
}

