/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.sql;

import com.ejie.r01f.exceptions.InitializeException;
import com.ejie.r01f.file.ResourcesLoader;
import com.ejie.r01f.log.R01FLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class QueryManager {
    private Map _queriesByEntityMap;

    public QueryManager() {
    }

    public QueryManager(String queryDefFilePath) throws InitializeException {
        this();
        try {
            InputStream fis = ResourcesLoader.getResourceFileAsStream(queryDefFilePath);
            this.init(fis);
        }
        catch (FileNotFoundException fnfEx) {
            throw new InitializeException("No se encuentra el fichero de mapeo de queries en: " + queryDefFilePath);
        }
    }

    public QueryManager(File queryDefFile) throws InitializeException {
        this();
        try {
            FileInputStream fis = new FileInputStream(queryDefFile);
            this.init(fis);
        }
        catch (FileNotFoundException fnfEx) {
            throw new InitializeException("No se encuentra el fichero de mapeo de queries en: " + queryDefFile.getAbsolutePath() + File.pathSeparator + queryDefFile.getName());
        }
    }

    public QueryManager(InputStream queryDefInputStream) throws InitializeException {
        this();
        this.init(queryDefInputStream);
    }

    void init(InputStream is) throws InitializeException {
        this._queriesByEntityMap = this._loadQueries(is);
    }

    public String getQuerySQL(String entity, String queryId) {
        Map entityQueries;
        String querySql = null;
        if (this._queriesByEntityMap != null && (entityQueries = (Map)this._queriesByEntityMap.get(entity)) != null) {
            querySql = (String)entityQueries.get(queryId);
        }
        return querySql;
    }

    public String printDebugInfo() {
        if (this._queriesByEntityMap == null) {
            return "No queries";
        }
        StringBuffer sb = new StringBuffer("");
        Map.Entry eme2 = null;
        for (Map.Entry eme2 : this._queriesByEntityMap.entrySet()) {
            sb.append("Entidad: " + eme2.getKey() + "\r\n");
            if (eme2.getKey() == null) continue;
            Map.Entry qme2 = null;
            for (Map.Entry qme2 : ((Map)eme2.getValue()).entrySet()) {
                sb.append("\tQuery: " + qme2.getKey() + ": " + qme2.getValue() + "\r\n");
            }
        }
        return sb.toString();
    }

    private Map _loadQueries(InputStream is) throws InitializeException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            XMLMapLoader loader = new XMLMapLoader();
            saxParser.parse(is, (DefaultHandler)loader);
            return loader.getEntitiesMap();
        }
        catch (ParserConfigurationException pcEx) {
            throw new InitializeException("Error de configuracion del parser XML:" + pcEx.toString(), (Exception)pcEx);
        }
        catch (SAXException saxEx) {
            throw new InitializeException("Error durante el parseo de XML: " + saxEx.toString(), (Exception)saxEx);
        }
        catch (IOException ioEx) {
            throw new InitializeException("Error al leer el XML de mapeo de queries: " + ioEx.toString(), (Exception)ioEx);
        }
    }

    public static void main(String[] args) {
        try {
            long t1 = System.currentTimeMillis();
            int testTimes = 1;
            for (int times = 0; times < testTimes; ++times) {
                String queryFile = "d:/eAdmin/aplic/r01d/html/datos/r01dQueryModelMapping.xml";
                QueryManager mgr = new QueryManager(queryFile);
                R01FLog.to("r01f.test").info(mgr.getQuerySQL("cluster", "selectall"));
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to("r01f.test").info("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t1) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private class XMLMapLoader
    extends DefaultHandler {
        private final String QUERIES_TAG_NAME = "queries";
        private final String ENTITY_TAG_NAME = "entity";
        private final String QUERY_TAG_NAME = "query";
        private String _currNodeName = null;
        private String _currNodeValue = null;
        private Map _entityMap;
        private String _currEntityName = null;
        private Map _currQueryMap;
        private String _currQueryId = null;

        public Map getEntitiesMap() {
            return this._entityMap;
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
            this._currNodeName = lName;
            if ("".equals(this._currNodeName)) {
                this._currNodeName = qName;
            }
            if (this._currNodeName.equalsIgnoreCase("queries")) {
                this._currNodeName = null;
                this._entityMap = new HashMap();
                return;
            }
            if (this._currNodeName.equalsIgnoreCase("entity")) {
                this._currEntityName = attrs.getValue("name");
                if (this._currEntityName == null) {
                    throw new SAXException("Error en la definici\u00f3n del mapeo de queries. Falta el atributo name en el tag entity");
                }
                this._currQueryMap = new HashMap();
                return;
            }
            if (this._currNodeName.equalsIgnoreCase("query")) {
                this._currQueryId = attrs.getValue("id");
                if (this._currQueryId == null) {
                    throw new SAXException("Error en la definici\u00f3n del mapeo de queries. Falta el atributo id en el tag query");
                }
                return;
            }
        }

        @Override
        public void characters(char[] buf, int offset, int len) {
            this._currNodeValue = this._currNodeValue == null ? new String(buf, offset, len) : this._currNodeValue + new String(buf, offset, len);
        }

        @Override
        public void endElement(String namespaceURI, String sName, String qName) {
            if (this._currEntityName != null) {
                if (this._currQueryId != null) {
                    if (this._currNodeValue == null) {
                        this._currNodeValue = "";
                    }
                    this._currQueryMap.put(this._currQueryId, this._currNodeValue.trim());
                    this._currQueryId = null;
                } else {
                    this._entityMap.put(this._currEntityName, this._currQueryMap);
                    this._currQueryMap = null;
                    this._currEntityName = null;
                }
                this._currNodeName = null;
                this._currNodeValue = null;
            }
        }

        @Override
        public void endDocument() {
        }
    }
}

