/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.sql;

import com.ejie.r01f.xmlproperties.XMLProperties;
import java.util.Iterator;
import java.util.Map;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import weblogic.jdbc.wrapper.Blob;
import weblogic.jdbc.wrapper.Clob;

final class LOBHelpper {
    private static final boolean isWeblogic = XMLProperties.getBoolean("r01ft", "database/useWeblogicLOBS");

    LOBHelpper() {
    }

    static CLOB castClob(java.sql.Clob clob) {
        if (isWeblogic) {
            return (CLOB)((Clob)clob).getVendorObj();
        }
        return (CLOB)clob;
    }

    static BLOB castBlob(java.sql.Blob blob) {
        if (isWeblogic) {
            return (BLOB)((Blob)blob).getVendorObj();
        }
        return (BLOB)blob;
    }

    static String composeSelectForUpdateSQL(String tableName, String lobColumnName, Map pk) {
        String sqlBlock = "SELECT " + lobColumnName + " " + "FROM " + tableName + " " + "WHERE ";
        Iterator it = pk.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            sqlBlock = sqlBlock + (String)me.getKey() + " = '" + (String)me.getValue() + "' ";
            if (!it.hasNext()) continue;
            sqlBlock = sqlBlock + "AND ";
        }
        sqlBlock = sqlBlock + " FOR UPDATE";
        return sqlBlock;
    }

    static String composeSelectSQL(String tableName, String lobColumnName, Map pk) {
        String sql = "SELECT " + lobColumnName + " " + "FROM " + tableName + " " + "WHERE ";
        Iterator it = pk.keySet().iterator();
        while (it.hasNext()) {
            sql = sql + (String)it.next() + " = ? ";
            if (!it.hasNext()) continue;
            sql = sql + "AND ";
        }
        return sql;
    }
}

