/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.sql;

import com.ejie.r01f.sql.BDConnectionHelpper;
import com.ejie.r01f.sql.LOBHelpper;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import oracle.sql.CLOB;

public final class CLOBWriter
extends Writer {
    Connection _conx = null;
    boolean _endConnection = true;
    String _tableName = null;
    String _lobColumnName = null;
    Map _pk = null;
    private Statement _stmtBlock = null;
    private ResultSet _rsBlock = null;
    private CLOB _clob = null;
    private Writer _clobWriter = null;
    private long _clobSize = 0L;

    CLOBWriter(Connection conx, boolean endConnection, String tableName, String lobColumnName, Map pk) throws SQLException {
        this._conx = conx;
        this._endConnection = endConnection;
        this._tableName = tableName;
        this._lobColumnName = lobColumnName;
        this._pk = pk;
        this._clobWriter = this._obtainCLOBWriter();
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void write(int c) throws IOException {
        if (this._clobWriter == null) {
            throw new IOException("No se puede escribir ya que el clob o el writer son nulos");
        }
        this._clobWriter.write(c);
        ++this._clobSize;
    }

    @Override
    public void write(char[] c, int off, int len) throws IOException {
        if (this._clobWriter == null) {
            throw new IOException("No se puede escribir ya que el clob o el writer son nulos");
        }
        this._clobWriter.write(c, off, len);
        this._clobSize += (long)len;
    }

    @Override
    public void write(char[] c) throws IOException {
        if (this._clobWriter == null) {
            throw new IOException("No se puede escribir ya que el clob o el writer son nulos");
        }
        this._clobWriter.write(c);
        this._clobSize += (long)c.length;
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (this._clobWriter == null) {
            throw new IOException("No se puede escribir ya que el clob o el writer son nulos");
        }
        this._clobWriter.write(str, off, len);
        this._clobSize += (long)len;
    }

    @Override
    public void write(String str) throws IOException {
        if (this._clobWriter == null) {
            throw new IOException("No se puede escribir ya que el clob o el writer son nulos");
        }
        this._clobWriter.write(str);
        this._clobSize += (long)str.length();
    }

    @Override
    public void flush() throws IOException {
        if (this._clobWriter == null) {
            throw new IOException("No se puede escribir ya que el clob o el writer son nulos");
        }
        this._clobWriter.flush();
    }

    @Override
    public void close() throws IOException {
        if (this._clobWriter == null) {
            throw new IOException("No se puede cerrar ya que el clob o el writer son nulos");
        }
        try {
            this._clobWriter.flush();
            this._clobWriter.close();
            this._clobWriter = null;
            this._truncateCLOB();
        }
        catch (SQLException sqlEx) {
            throw new IOException("Error SQL al cerrar el CLOB: No se ha podido comprimir...\n" + sqlEx.toString());
        }
        finally {
            try {
                if (this._clob != null) {
                    if (this._clob.isOpen()) {
                        this._clob.close();
                    }
                    this._clob = null;
                }
                if (this._stmtBlock != null) {
                    this._stmtBlock.close();
                    this._stmtBlock = null;
                    if (this._rsBlock != null) {
                        this._rsBlock.close();
                        this._rsBlock = null;
                    }
                }
                if (this._endConnection && this._conx != null) {
                    this._conx.commit();
                    BDConnectionHelpper.closeConnection(this._conx);
                    this._conx = null;
                }
            }
            catch (SQLException sqlEx) {
                throw new IOException("Error SQL cerrar el CLOB: No se ha cerrar algun recurso...\n" + sqlEx.toString());
            }
        }
    }

    private Writer _obtainCLOBWriter() throws SQLException {
        this._conx.setAutoCommit(false);
        String sqlBlock = LOBHelpper.composeSelectForUpdateSQL(this._tableName, this._lobColumnName, this._pk);
        this._stmtBlock = this._conx.createStatement();
        this._stmtBlock.execute(sqlBlock);
        this._rsBlock = this._stmtBlock.getResultSet();
        if (this._rsBlock.next()) {
            this._clob = LOBHelpper.castClob(this._rsBlock.getClob(this._lobColumnName));
            if (this._clob == null) {
                throw new SQLException("No se ha podido obtener un CLOB de la columna '" + this._lobColumnName + "' de la tabla '" + this._tableName + "'. " + "Probablemente antes hay que inicializar el CLOB con un EMPTY_CLOB()");
            }
            return this._clob.getCharacterOutputStream();
        }
        throw new SQLException("No se ha encontrado la fila que contiene el CLOB. Es correcta la clave primaria suministrada?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _truncateCLOB() throws SQLException {
        Statement stmtTrim = null;
        try {
            stmtTrim = this._conx.prepareCall("BEGIN DBMS_LOB.TRIM(?," + this._clobSize + "); END;");
            stmtTrim.setClob(1, this._rsBlock.getClob(this._lobColumnName));
            stmtTrim.execute();
        }
        finally {
            if (stmtTrim != null) {
                stmtTrim.close();
            }
            stmtTrim = null;
        }
    }
}

