/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.sql;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.sql.CLOB;
import weblogic.jdbc.wrapper.Clob;

public class CLOBInvocationHandler
implements InvocationHandler {
    private static final boolean isWeblogic = XMLProperties.getBoolean("r01ft", "database/useWeblogicLOBS");
    private CLOB _clobInstance;

    public CLOBInvocationHandler() {
    }

    public CLOBInvocationHandler(java.sql.Clob clob) {
        this._clobInstance = isWeblogic ? (CLOB)((Clob)clob).getVendorObj() : (CLOB)clob;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method == null) {
            return null;
        }
        try {
            Method lobMethod = this._clobInstance.getClass().getMethod(method.getName(), method.getParameterTypes());
            return lobMethod.invoke((Object)this._clobInstance, args);
        }
        catch (NoSuchMethodException nsmEx) {
            R01FLog.to("r01f.sql").severe("No se encuentra el metodo (" + method + ") en el objeto " + this._clobInstance.getClass().getName() + ". Este objeto DEBE TENER LOS MISMOS METODOS y CON LA MISMA SIGNATURA que el Business Delegate!!!");
            throw nsmEx;
        }
        catch (IllegalAccessException illAccEx) {
            throw new Exception(illAccEx);
        }
        catch (InvocationTargetException invTgtEx) {
            throw invTgtEx.getTargetException();
        }
    }
}

