/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.sql;

import com.ejie.r01f.sql.BDConnectionHelpper;
import com.ejie.r01f.sql.LOBHelpper;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import oracle.sql.BLOB;

public class BLOBOutputStream
extends OutputStream {
    Connection _conx = null;
    boolean _endConnection = true;
    String _tableName = null;
    String _lobColumnName = null;
    Map _pk = null;
    private Statement _stmtBlock = null;
    private ResultSet _rsBlock = null;
    private BLOB _blob = null;
    private OutputStream _blobOutputStream = null;
    private long _blobSize = 0L;

    BLOBOutputStream(Connection conx, boolean endConnection, String tableName, String lobColumnName, Map pk) throws SQLException {
        this._conx = conx;
        this._endConnection = endConnection;
        this._tableName = tableName;
        this._lobColumnName = lobColumnName;
        this._pk = pk;
        this._blobOutputStream = this._obtainBLOBOutputStream();
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this._blobOutputStream == null) {
            throw new IOException("No se puede escribir ya que el blob o el outputStream son nulos");
        }
        this._blobOutputStream.write(b);
        ++this._blobSize;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this._blobOutputStream == null) {
            throw new IOException("No se puede escribir ya que el blob o el outputStream son nulos");
        }
        this._blobOutputStream.write(b, off, len);
        this._blobSize += (long)len;
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this._blobOutputStream == null) {
            throw new IOException("No se puede escribir ya que el blob o el outputStream son nulos");
        }
        this._blobOutputStream.write(b);
        this._blobSize += (long)b.length;
    }

    @Override
    public void flush() throws IOException {
        if (this._blobOutputStream == null) {
            throw new IOException("No se puede escribir ya que el blob o el outputStream son nulos");
        }
        this._blobOutputStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (this._blobOutputStream == null) {
            throw new IOException("No se puede escribir ya que el blob o el outputStream son nulos");
        }
        try {
            this._blobOutputStream.flush();
            this._blobOutputStream.close();
            this._blobOutputStream = null;
            this._truncateBLOB();
        }
        catch (SQLException sqlEx) {
            throw new IOException("Error SQL al cerrar el BLOB: No se ha podido comprimir...\n" + sqlEx.toString());
        }
        finally {
            try {
                if (this._blob != null) {
                    if (this._blob.isOpen()) {
                        this._blob.close();
                    }
                    this._blob = null;
                }
                if (this._stmtBlock != null) {
                    this._stmtBlock.close();
                    this._stmtBlock = null;
                    if (this._rsBlock != null) {
                        this._rsBlock.close();
                        this._rsBlock = null;
                    }
                }
                if (this._endConnection && this._conx != null) {
                    this._conx.commit();
                    BDConnectionHelpper.closeConnection(this._conx);
                    this._conx = null;
                }
            }
            catch (SQLException sqlEx) {
                throw new IOException("Error SQL cerrar el BLOB: No se ha cerrar algun recurso...\n" + sqlEx.toString());
            }
        }
    }

    OutputStream _obtainBLOBOutputStream() throws SQLException {
        this._conx.setAutoCommit(false);
        String sqlBlock = LOBHelpper.composeSelectForUpdateSQL(this._tableName, this._lobColumnName, this._pk);
        this._stmtBlock = this._conx.createStatement();
        this._stmtBlock.execute(sqlBlock);
        this._rsBlock = this._stmtBlock.getResultSet();
        if (this._rsBlock.next()) {
            this._blob = LOBHelpper.castBlob(this._rsBlock.getBlob(this._lobColumnName));
            if (this._blob == null) {
                throw new SQLException("No se ha podido obtener un BLOB de la columna '" + this._lobColumnName + "' de la tabla '" + this._tableName + "'. " + "Probablemente antes hay que inicializar el BLOB con un EMPTY_BLOB()");
            }
            return this._blob.getBinaryOutputStream();
        }
        throw new SQLException("No se ha encontrado la fila que contiene el CLOB. Es correcta la clave primaria suministrada?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _truncateBLOB() throws SQLException {
        Statement stmtTrim = null;
        try {
            stmtTrim = this._conx.prepareCall("BEGIN DBMS_LOB.TRIM(?," + this._blobSize + "); END;");
            stmtTrim.setBlob(1, this._rsBlock.getBlob(this._lobColumnName));
            stmtTrim.execute();
        }
        finally {
            if (stmtTrim != null) {
                stmtTrim.close();
            }
            stmtTrim = null;
        }
    }
}

