/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.sql;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class BDConnectionHelpper {
    private static Map _conxPropertiesCache = new HashMap();

    public static Properties obtainConnectionProperties(String appCode, String connectionName) {
        String key = appCode + "." + connectionName;
        Properties props = (Properties)_conxPropertiesCache.get(key);
        if (props == null) {
            props = XMLProperties.getProperties(appCode, "database/connection[@name='" + connectionName + "']");
        }
        if (props == null) {
            R01FLog.to("r01f.sql").severe("NO se han encontrado las propiedades de la conexi\u00f3n: " + appCode + " : " + connectionName);
        }
        return props;
    }

    public static Connection getConnection(String appCode, String conxName) throws SQLException {
        R01FLog.to("r01f.sql").info("Obteniendo conexion '" + conxName + "' de la aplicacion '" + appCode + "'");
        return BDConnectionHelpper.getConnection(XMLProperties.getProperties(appCode, "database/connection[@name='" + conxName + "']"));
    }

    public static Connection getConnection(Properties props) throws SQLException {
        R01FLog.to("r01f.sql").info("\r\nObteniendo conexion");
        if (props == null) {
            R01FLog.getLogger("r01f.sql").warning(BDConnectionHelpper.composeNoConfigErrorMessage());
            throw new IllegalArgumentException("Las propiedades para obtener la conexi\u00f3n no son validas (null)");
        }
        String driverClass = props.getProperty("class");
        if (driverClass == null || driverClass.length() == 0) {
            R01FLog.getLogger("r01f.sql").warning(BDConnectionHelpper.composeNoConfigErrorMessage());
            throw new IllegalArgumentException("La clase (class) de conexion especificada en las propiedades no es valida (null)");
        }
        String uri = props.getProperty("uri");
        if (uri == null || uri.length() == 0) {
            R01FLog.to("r01f.sql").warning(BDConnectionHelpper.composeNoConfigErrorMessage());
            throw new IllegalArgumentException("El uri especificado en las propiedades no es valida (null)");
        }
        if (driverClass.equalsIgnoreCase("DataSource")) {
            String dataSourceName = props.getProperty("uri");
            if (dataSourceName == null || dataSourceName.length() == 0) {
                throw new IllegalArgumentException("El nombre del dataSource especificado en las propiedades no es valida (null)");
            }
            return BDConnectionHelpper._obtainDataSourceConnection(dataSourceName, false);
        }
        if (driverClass.equalsIgnoreCase("TXDataSource")) {
            String dataSourceName = props.getProperty("uri");
            if (dataSourceName == null || dataSourceName.length() == 0) {
                throw new IllegalArgumentException("El nombre del dataSource especificado en las propiedades no es valida (null)");
            }
            return BDConnectionHelpper._obtainDataSourceConnection(dataSourceName, true);
        }
        if (driverClass.equalsIgnoreCase("Pool")) {
            String poolName = props.getProperty("uri");
            if (poolName == null || poolName.length() == 0) {
                throw new IllegalArgumentException("El nombre del pool especificado en las propiedades no es valida (null)");
            }
            return null;
        }
        String user = props.getProperty("user");
        String password = props.getProperty("password");
        String server = props.getProperty("server");
        return BDConnectionHelpper._obtainJDBCConnection(driverClass, uri, user, password, server);
    }

    public static void closeConnection(Connection conx) throws SQLException {
        R01FLog.to("r01f.sql").info("\r\nLiberando conexion");
        if (conx != null) {
            conx.close();
            conx = null;
        }
    }

    public static String composeNoConfigErrorMessage() {
        StringBuffer sb = new StringBuffer();
        sb.append("ERROR EN LA DEFINICI\u00d3N DE LA CONEXION A BASE DE DATOS\r\n");
        sb.append("-------------------------------------------------------------\r\n");
        sb.append("Este error puede estar provocado porque no se ha definido\r\n");
        sb.append("la conexion en el fichero .properties.xml o bien porque la\r\n");
        sb.append("definici\u00f3n no es correcta\r\n");
        sb.append("Una conexi\u00f3n en este fichero tiene las formas:\r\n");
        sb.append("<connection name='prueba'>\r\n");
        sb.append("\t<class>weblogic.jdbc20.oci.Driver</class>\r\n");
        sb.append("\t<uri>jdbc20:weblogic:oracle</uri>\r\n");
        sb.append("\t<user>usuario</user>\r\n");
        sb.append("\t<password>password</password>\r\n");
        sb.append("\t<server>server</server>\r\n");
        sb.append("</connection>\r\n");
        sb.append("<connection name='pruebaPool'>\r\n");
        sb.append("\t<class>Datasource</class>\r\n");
        sb.append("\t<uri>poolPrueba</uri>\r\n");
        sb.append("</connection>\r\n");
        sb.append("Solo hay que identificar la conexi\u00f3n con un nombre y pedirla\r\n");
        sb.append("con este mismo nombre en los programas java\r\n");
        return sb.toString();
    }

    private static Connection _obtainDataSourceConnection(String dataSourceName, boolean isTX) throws SQLException {
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = null;
            ds = isTX ? (DataSource)ctx.lookup(dataSourceName) : (DataSource)ctx.lookup(dataSourceName);
            Connection conx = ds.getConnection();
            if (conx == null) {
                throw new SQLException("No se ha podido obtener una conexion del dataSource " + dataSourceName);
            }
            return conx;
        }
        catch (NamingException nEx) {
            throw new SQLException("Error al obtener el DataSource: " + nEx.toString());
        }
    }

    private static Connection _obtainJDBCConnection(String driverClass, String uri, String user, String password, String server) throws SQLException {
        try {
            Properties props = new Properties();
            if (user != null) {
                props.setProperty("user", user);
            }
            if (password != null) {
                props.setProperty("password", password);
            }
            if (server != null) {
                props.setProperty("server", server);
            }
            Class.forName(driverClass).newInstance();
            Connection conx = DriverManager.getConnection(uri, props);
            if (conx == null) {
                throw new SQLException("No se ha podido obtener una conexion utilizando el driver " + driverClass + " a la uri " + uri);
            }
            return conx;
        }
        catch (ClassNotFoundException cnfEx) {
            throw new SQLException("Error al instanciar el driver JDBC [" + driverClass + "]: " + cnfEx.toString());
        }
        catch (IllegalAccessException illAccEx) {
            throw new SQLException("Acceso ilegar al instanciar el driver JDBC [" + driverClass + "]: " + illAccEx.toString());
        }
        catch (InstantiationException instEx) {
            throw new SQLException("Error al instanciar el driver JDBC [" + driverClass + "]: " + instEx.toString());
        }
    }
}

