/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.servlet.upload;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.servlet.RequestUtils;
import com.ejie.r01f.servlet.upload.FilePart;
import com.ejie.r01f.servlet.upload.MultipartParser;
import com.ejie.r01f.servlet.upload.ParamPart;
import com.ejie.r01f.servlet.upload.Part;
import com.ejie.r01f.servlet.upload.PartDigester;
import com.ejie.r01f.servlet.upload.PartDigesterException;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UploadServlet
extends HttpServlet {
    private static final String LOGGER_ID = "r01f.servlet";
    private static final long serialVersionUID = 4596904234068517501L;
    private static final String DIGESTERID = "digesterID";
    private static final String APPCODE = "appCode";
    private static final String PASSWORD = "passwd";
    private ServletConfig _config = null;
    private Properties partDigesterProperties = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this._config = config;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        R01FLog.to(LOGGER_ID).info("\n\n\n\n>>>>>>>>>>UploadServlet.................");
        String appCode = this._config.getInitParameter(APPCODE);
        String partDigesterID = null;
        String passwd = null;
        PartDigester partDigester = null;
        try {
            if (!StringUtils.isEmptyString(request.getParameter(DIGESTERID))) {
                partDigesterID = request.getParameter(DIGESTERID);
            } else if (!request.getParameterMap().isEmpty()) {
                throw new ServletException("UploadServlet configuration error: No se ha recibido el parametro digesterID");
            }
            Enumeration en = request.getParameterNames();
            while (en.hasMoreElements()) {
                String currParam = (String)en.nextElement();
                ParamPart paramPart = new ParamPart(currParam, request.getParameter(currParam));
                if (!paramPart.getName().equalsIgnoreCase(APPCODE) && !paramPart.getName().equalsIgnoreCase(DIGESTERID)) {
                    R01FLog.to(LOGGER_ID).info(">>> Recibido Parametro en la url '" + paramPart.getName() + "': '" + paramPart.getStringValue() + "'");
                    if (partDigester == null) {
                        partDigester = this._getPartDigesterInstance(appCode, partDigesterID);
                    }
                    partDigester.digestParamPart(paramPart);
                    continue;
                }
                if (!paramPart.getName().equalsIgnoreCase(APPCODE)) continue;
                appCode = paramPart.getStringValue();
            }
            int maxFileSize = 0x100000;
            if (appCode != null) {
                maxFileSize = XMLProperties.getInt(appCode, "uploadServlet/maxFileSize");
            }
            MultipartParser parser = new MultipartParser(request, maxFileSize);
            Part currPart = null;
            FilePart filePart = null;
            String fileName = null;
            String mimeType = null;
            while ((currPart = parser.readNextPart()) != null) {
                if (currPart.isParam()) {
                    ParamPart paramPart = (ParamPart)currPart;
                    if (paramPart.getName().equalsIgnoreCase(APPCODE)) {
                        appCode = paramPart.getStringValue();
                        continue;
                    }
                    if (paramPart.getName().equalsIgnoreCase(DIGESTERID)) {
                        partDigesterID = paramPart.getStringValue();
                        continue;
                    }
                    if (paramPart.getName().equalsIgnoreCase(PASSWORD)) {
                        passwd = paramPart.getStringValue();
                        continue;
                    }
                    R01FLog.to(LOGGER_ID).info(">>> Recibido Parametro en la url '" + paramPart.getName() + "': '" + paramPart.getStringValue() + "'");
                    System.out.println(">>> Recibido Parametro en la url '" + paramPart.getName() + "': '" + paramPart.getStringValue() + "'");
                    if (StringUtils.isEmptyString(partDigesterID)) {
                        partDigesterID = this._config.getInitParameter(DIGESTERID);
                    }
                    if (partDigester == null) {
                        partDigester = this._getPartDigesterInstance(appCode, partDigesterID);
                    }
                    partDigester.digestParamPart(paramPart);
                    continue;
                }
                if (currPart.isFile() || currPart.getName().equalsIgnoreCase("file")) {
                    filePart = (FilePart)currPart;
                    fileName = filePart.getFileName() == null ? "" : filePart.getFileName();
                    mimeType = filePart.getContentType() == null ? "" : filePart.getContentType();
                    R01FLog.to(LOGGER_ID).info(">>> Recibido Fichero tipo '" + mimeType + "': '" + fileName + "'");
                    if (StringUtils.isEmptyString(fileName)) continue;
                    List<String> allowedMimeTypes = XMLProperties.getPropertyList(appCode, "uploadServlet/digesters/digester[@id='" + partDigesterID + "']/allowedMimeTypes/mimeType");
                    if (allowedMimeTypes != null) {
                        boolean mimeTypeAllowed = false;
                        Iterator<String> mit = allowedMimeTypes.iterator();
                        while (mit.hasNext()) {
                            if (!mit.next().equals(mimeType)) continue;
                            mimeTypeAllowed = true;
                            break;
                        }
                        if (!mimeTypeAllowed) {
                            throw new ServletException("El mime-type: " + mimeType + " NO esta permitido. Revisa la configuracion del digester");
                        }
                    } else {
                        R01FLog.to(LOGGER_ID).info(">>NO se hace comprobacion del mime-type ya que no se ha configurado en el digester!");
                    }
                    if (StringUtils.isEmptyString(partDigesterID)) {
                        partDigesterID = this._config.getInitParameter(DIGESTERID);
                    }
                    if (partDigester == null) {
                        partDigester = this._getPartDigesterInstance(appCode, partDigesterID);
                    }
                    partDigester.digestFilePart(filePart);
                    continue;
                }
                R01FLog.to(LOGGER_ID).info(">>> Part NO reconocida. No es un parametro ni un fichero!!!!");
            }
            if (!StringUtils.isEmptyString(fileName)) {
                if (!StringUtils.isEmptyString(this._config.getInitParameter("password")) && !this._config.getInitParameter("password").equals(passwd)) {
                    partDigester.finalizeDigester(filePart);
                    throw new ServletException("UploadServlet security error: La clave de acceso no es v\u00e1lida.");
                }
                if (partDigester == null) {
                    partDigester = this._getPartDigesterInstance(appCode, partDigesterID);
                }
                partDigester.processDigester(filePart);
                partDigester.finalizeDigester(filePart);
            }
            if (partDigester != null && partDigester.getTargetPage() != null) {
                R01FLog.to(LOGGER_ID).info("despu\u00e9s de subir el fichero, redirigir a la p\u00e1gina " + partDigester.getTargetPage());
                RequestUtils.redirect(this._config, request, response, partDigester.getTargetPage());
            } else {
                R01FLog.to(LOGGER_ID).info("NO se ha suministrado p\u00e1gina a la que redirigir despu\u00e9s de subir el fichero");
                ServletOutputStream out = response.getOutputStream();
                out.println("<html><body><h1 style='text-align:center'>TransferenciaCorrecta</h1></body></html>");
                out.flush();
                out.close();
            }
            R01FLog.to(LOGGER_ID).info("<<<<<<<<<<UploadServlet.................\n\n\n\n");
        }
        catch (IOException ioEx) {
            throw new ServletException((Throwable)ioEx);
        }
        catch (PartDigesterException partDigEx) {
            throw new ServletException((Throwable)partDigEx);
        }
    }

    private PartDigester _getPartDigesterInstance(String appCode, String partDigesterID) throws ServletException, PartDigesterException {
        if (appCode == null) {
            throw new ServletException("UploadServlet configuration error: No se puede obtener la configuracion ya que no se ha especificado la propiedad appCode en el fichero web.xml o no se ha recibido el parametro de la request appCode");
        }
        if (partDigesterID == null) {
            throw new ServletException("UploadServlet configuration error: No se ha recibido el parametro digesterID");
        }
        try {
            PartDigester partDigester = null;
            String partDigesterClassName = XMLProperties.getString(appCode, "uploadServlet/digesters/digester[@id='" + partDigesterID + "']/class");
            this.partDigesterProperties = XMLProperties.getProperties(appCode, "uploadServlet/digesters/digester[@id='" + partDigesterID + "']/config");
            if (this.partDigesterProperties == null) {
                this.partDigesterProperties = new Properties();
            }
            this.partDigesterProperties.setProperty(APPCODE, appCode);
            if (partDigesterClassName == null) {
                throw new ServletException("UploadServlet configuration error: uploadServlet/digesters/digester[@id='" + partDigesterID + "']/class not found in " + appCode + ".properties file");
            }
            R01FLog.to(LOGGER_ID).info(">>> Instanciando clase digester de los parts: '" + partDigesterClassName + "'");
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> partDigesterClass = cl.loadClass(partDigesterClassName);
            partDigester = (PartDigester)partDigesterClass.newInstance();
            partDigester.setConfig(this.partDigesterProperties);
            return partDigester;
        }
        catch (ClassNotFoundException cnfEx) {
            throw new ServletException("ClassNotFoundException in UploadServlet: " + cnfEx.toString(), (Throwable)cnfEx);
        }
        catch (IllegalAccessException illAccEx) {
            throw new ServletException("IllegalAccessException in UploadServlet: " + illAccEx.toString(), (Throwable)illAccEx);
        }
        catch (InstantiationException instEx) {
            throw new ServletException("InstantiationException in UploadServlet: " + instEx.toString(), (Throwable)instEx);
        }
    }
}

