/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.servlet.upload;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.servlet.upload.BaseDigester;
import com.ejie.r01f.servlet.upload.DefaultFileRenamePolicy;
import com.ejie.r01f.servlet.upload.FilePart;
import com.ejie.r01f.servlet.upload.ParamPart;
import com.ejie.r01f.servlet.upload.PartDigester;
import com.ejie.r01f.servlet.upload.PartDigesterException;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public class SaveToFileDigester
extends BaseDigester
implements PartDigester {
    private Properties _props = null;
    private String _oid = null;

    public String getTargetDir() {
        if (this._props == null) {
            return null;
        }
        String targetDir = this._props.getProperty("dir");
        return targetDir;
    }

    @Override
    public void setConfig(Properties props) {
        if (this._props != null) {
            Enumeration<Object> propiedades = props.keys();
            while (propiedades.hasMoreElements()) {
                String currProp = (String)propiedades.nextElement();
                if (this._props.containsKey(currProp)) continue;
                this._props.setProperty(currProp, props.getProperty(currProp));
            }
        } else {
            this._props = props;
        }
    }

    @Override
    public void digestParamPart(ParamPart paramPart) {
        try {
            R01FLog.to("r01f.servlet").info(".... Recibido parametro:\n\t" + paramPart.getName() + "\n\t" + paramPart.getStringValue());
            if (paramPart.getName().equalsIgnoreCase("OID")) {
                this._oid = paramPart.getStringValue();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    @Override
    public void digestFilePart(FilePart filePart) throws PartDigesterException {
        String targetDir = this.getTargetDir();
        if (targetDir == null) {
            throw new PartDigesterException("SaveToFileDigester: Error de configuracion:\r\n\t-Error de configuracion, no se ha definido la seccion uploadServlet/digesters/digester[@id='..']/config dentro del fichero properties de la aplicacion\r\n\t-NO se ha definido la propiedad 'dir' donde se van a guardar los ficheros");
        }
        try {
            filePart.setRenamePolicy(new DefaultFileRenamePolicy());
            filePart.writeTo(new File(targetDir));
        }
        catch (IOException ioEx) {
            throw new PartDigesterException("Error al guardar el fichero: " + ioEx.toString());
        }
    }

    @Override
    public String getTargetPage() {
        return null;
    }
}

