/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.servlet.upload;

import com.ejie.r01f.servlet.upload.FileRenamePolicy;
import com.ejie.r01f.servlet.upload.MacBinaryDecoderOutputStream;
import com.ejie.r01f.servlet.upload.Part;
import com.ejie.r01f.servlet.upload.PartInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletInputStream;

public class FilePart
extends Part {
    private String _fileName;
    private String _filePath;
    private String _contentType;
    private PartInputStream _partInput;
    private FileRenamePolicy _policy;

    FilePart(String name, ServletInputStream in, String boundary, String contentType, String fileName, String filePath) {
        super(name);
        this._fileName = fileName;
        this._filePath = filePath;
        this._contentType = contentType;
        this._partInput = new PartInputStream(in, boundary);
    }

    public void setRenamePolicy(FileRenamePolicy policy) {
        this._policy = policy;
    }

    public String getFileName() {
        return this._fileName;
    }

    public String getFilePath() {
        return this._filePath;
    }

    public String getContentType() {
        return this._contentType;
    }

    public InputStream getInputStream() {
        return this._partInput;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeTo(File fileOrDirectory) throws IOException {
        long written = 0L;
        OutputStream fileOut = null;
        try {
            if (this._fileName != null) {
                File file = fileOrDirectory.isDirectory() ? new File(fileOrDirectory, this._fileName) : fileOrDirectory;
                if (this._policy != null) {
                    file = this._policy.rename(file);
                    this._fileName = file.getName();
                }
                fileOut = new BufferedOutputStream(new FileOutputStream(file));
                written = this.write(fileOut);
            }
        }
        finally {
            if (fileOut != null) {
                fileOut.close();
            }
        }
        return written;
    }

    public long writeTo(OutputStream out) throws IOException {
        long size = 0L;
        if (this._fileName != null) {
            size = this.write(out);
        }
        return size;
    }

    long write(OutputStream out) throws IOException {
        int read;
        if (this._contentType.equals("application/x-macbinary")) {
            out = new MacBinaryDecoderOutputStream(out);
        }
        long size = 0L;
        byte[] buf = new byte[8192];
        while ((read = this._partInput.read(buf)) != -1) {
            out.write(buf, 0, read);
            size += (long)read;
        }
        return size;
    }
}

