/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.servlet.upload;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.servlet.upload.BaseDigester;
import com.ejie.r01f.servlet.upload.FilePart;
import com.ejie.r01f.servlet.upload.ParamPart;
import com.ejie.r01f.servlet.upload.PartDigester;
import com.ejie.r01f.servlet.upload.PartDigesterException;
import com.ejie.r01f.sql.BDConnectionHelpper;
import com.ejie.r01f.sql.DBManager;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;

public class DataBaseDigester
extends BaseDigester
implements PartDigester {
    private Properties _props = null;
    private String _oid = null;

    @Override
    public void setConfig(Properties props) {
        this._props = props;
    }

    @Override
    public void digestParamPart(ParamPart paramPart) {
        try {
            R01FLog.to("r01f.servlet").info(".... Recibido parametro:\n\t" + paramPart.getName() + "\n\t" + paramPart.getStringValue());
            if (paramPart.getName().equalsIgnoreCase("OID")) {
                this._oid = paramPart.getStringValue();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    @Override
    public void digestFilePart(FilePart filePart) throws PartDigesterException {
        if (this._props == null) {
            throw new PartDigesterException(this.getClass().getName() + ": Error de configuracion, no se ha definido la seccion uploadServlet/digesters/digester[@id='..']/config dentro del fichero properties de la aplicacion");
        }
        if (this._props.getProperty("appCode") == null) {
            throw new PartDigesterException(this.getClass().getName() + ": Error de configuracion, no se ha definido la propiedad 'appCode' que define la aplicacion");
        }
        if (this._props.getProperty("connection") == null) {
            throw new PartDigesterException(this.getClass().getName() + ": Error de configuracion, no se ha definido la propiedad 'connection' que define la conexion a base de datos a utilizar");
        }
        if (this._props.getProperty("table") == null) {
            throw new PartDigesterException(this.getClass().getName() + ": Error de configuracion, no se ha definido la propiedad 'table' que define la tabla en donde se guarda el contenido");
        }
        if (this._props.getProperty("oidColumn") == null) {
            throw new PartDigesterException(this.getClass().getName() + ": Error de configuracion, no se ha definido la propiedad 'oidColumn' que define la columna que guarda el oid del registro");
        }
        if (this._props.getProperty("blobColumn") == null) {
            throw new PartDigesterException(this.getClass().getName() + ": Error de configuracion, no se ha definido la propiedad 'blobColumn' que define la columna que guarda el blob con el contenido");
        }
        if (this._oid == null || this._oid.length() == 0) {
            throw new PartDigesterException(this.getClass().getName() + ": Error en los parametros de llamada. No se ha pasado el identificador del registro (parametro oid)");
        }
        try {
            Properties conxProps = BDConnectionHelpper.obtainConnectionProperties(this._props.getProperty("appCode"), this._props.getProperty("connection"));
            DBManager dbman = new DBManager(conxProps);
            HashMap<String, String> pk = new HashMap<String, String>();
            pk.put(this._props.getProperty("oidColumn"), this._oid);
            OutputStream blobOutputStream = dbman.getBLOBOutputStream(this._props.getProperty("table"), this._props.getProperty("blobColumn"), pk);
            filePart.writeTo(blobOutputStream);
            blobOutputStream.flush();
            blobOutputStream.close();
        }
        catch (IOException ioEx) {
            throw new PartDigesterException("Error al leer el fichero desde el navegador:\n" + ioEx.toString());
        }
        catch (SQLException sqlEx) {
            throw new PartDigesterException("Error al guardar el fichero en base de datos:\n" + sqlEx.toString());
        }
    }

    @Override
    public String getTargetPage() {
        return null;
    }
}

