/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.servlet.serializer;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.process.AbstractExecQueue;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractSerializerServlet
extends HttpServlet {
    private static final long serialVersionUID = -4215994714352251595L;
    private ServletConfig _config = null;
    private AbstractExecQueue _execQueue = null;

    public String getServletInfo() {
        return "r01f: Servlet de serializacion de llamadas\r\n(c)DOMA: Direccion de la Oficina para la Modernizacion de la Administracion";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        R01FLog.to("r01f.servlet").info("\r\n\r\n<<r01f:SerializerServlet>>:Inicializando la cola de ejecuci\u00f3n......");
        this._config = config;
        String appCode = this._config.getInitParameter("appCode");
        if (appCode == null || appCode.length() == 0) {
            throw new ServletException("r01f:SerializerServlet: No se ha especificado el codigo de aplicacion al configurar el servlet en el fichero web.xml");
        }
        String instance = this._config.getInitParameter("instance");
        String xPath = "serializerServlet";
        if (instance != null && instance.length() > 0) {
            xPath = xPath + "[@id='" + instance + "']";
        }
        String workerClassName = XMLProperties.getString(appCode, xPath + "/workerClass");
        int lowerLimit = XMLProperties.getInt(appCode, xPath + "/lowerLimit");
        int upperLimit = XMLProperties.getInt(appCode, xPath + "/upperLimit");
        if (lowerLimit < 0 || upperLimit < 0) {
            throw new ServletException("r01f:SerializerServlet: El limite inferior o superior especificados para la cola no son validos");
        }
        if (workerClassName == null || workerClassName.length() == 0) {
            throw new ServletException("r01f:SerializerServlet: El nombre de la clase que se encarga de procesar la cola especificado en el fichero " + appCode + ".properties NO es valido");
        }
        R01FLog.to("r01f.servlet").info("Configuracion:\r\n\tAppCode: " + appCode + "\r\n\tWorkerClass: " + workerClassName + "\r\n\tLimites(inf,sup): " + lowerLimit + "," + upperLimit + "\r\n\r\n\r\n");
        try {
            Class workerClass = ReflectionUtils.getObjectClassDef(workerClassName);
            this._execQueue = (AbstractExecQueue)workerClass.newInstance();
            this._execQueue.setLimits(lowerLimit, upperLimit);
        }
        catch (ClassNotFoundException cnfEx) {
            throw new ServletException("Error al instanciar la clase procesadora '" + workerClassName + "': La clase no existe:\r\n" + cnfEx.toString());
        }
        catch (InstantiationException insEx) {
            throw new ServletException("Error al instanciar la clase procesadora '" + workerClassName + "': No se puede instanciar la clase:\r\n" + insEx.toString());
        }
        catch (IllegalAccessException illAccEx) {
            throw new ServletException("Error al acceder a la clase procesadora '" + workerClassName + "': No se puede acceder\r\n" + illAccEx.toString());
        }
        catch (ClassCastException ccs) {
            throw new ServletException("Error al instanciar la clase procesadora '" + workerClassName + "': No es del tipo esperado ya que no es una subclase de com.ejie.r01f.util.AbstractExecQueue");
        }
    }

    public void destroy() {
    }

    public void service(HttpServletRequest request, HttpServletResponse response) {
        Object obj = this.getObjectToProcess(request);
        if (obj != null) {
            this._execQueue.push(obj);
        }
    }

    protected abstract Object getObjectToProcess(HttpServletRequest var1);
}

