/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.servlet.filter.authorization;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.servlet.filter.authorization.R01FAuthCfg;
import com.ejie.r01f.servlet.filter.authorization.R01FAuthCtx;
import com.ejie.r01f.servlet.filter.authorization.R01FAuthFilterUtils;
import com.ejie.r01f.servlet.filter.authorization.R01FBaseAuthProvider;
import com.ejie.r01f.servlet.filter.authorization.R01FTargetCfg;
import com.ejie.r01f.servlet.filter.authorization.R01FTargetCtx;
import com.ejie.r01f.servlet.filter.authorization.R01FUserCtx;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class R01FAuthServletFilter
implements Filter {
    private static final String APPCODE = "appCode";
    private FilterConfig _config = null;
    private static Map _appCfgs = null;

    public void init(FilterConfig config) throws ServletException {
        this.setFilterConfig(config);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpSession ses;
        R01FLog.to("r01f.auth").info("\n\n\n\n>>>>>>>>>> Inicio: Filtro de Autorizacion >>>>>>>>>>>>>>>>>>>>>>");
        String reqParam = request.getParameter("r01fReload");
        if (reqParam != null && reqParam.equalsIgnoreCase("true")) {
            R01FLog.to("r01f.auth").warning("**** REINICIALIZANDO properties... *****");
            XMLProperties.reload();
            _appCfgs = null;
            HttpSession ses2 = ((HttpServletRequest)request).getSession(false);
        }
        String appCode = this._config.getInitParameter(APPCODE);
        R01FAuthCfg authCfg = new R01FAuthCfg();
        if (_appCfgs == null || _appCfgs.get(appCode) == null) {
            R01FLog.to("r01f.auth").info(">>>>> R01FAuthServletFilter.doFilter -->  Configuraciones no estan cargadas... Se cargan >>>>>>>>>>>>>>>>>>>>>>");
            authCfg.loadConfig(appCode);
            if (_appCfgs == null) {
                _appCfgs = new LinkedHashMap(1);
            }
            _appCfgs.put(appCode, authCfg);
        } else {
            R01FLog.to("r01f.auth").info(">>>>> R01FAuthServletFilter.doFilter --> Configuraciones ya estan cargadas: " + _appCfgs.size() + " ==> " + _appCfgs.toString());
        }
        authCfg = (R01FAuthCfg)_appCfgs.get(appCode);
        if (authCfg == null) {
            throw new ServletException("No se ha podido cargar la configuracion de autorizacion para la aplicacion '" + appCode + "'. Revisa la seccion <authorization> del fichero '" + appCode + ".properties.xml'");
        }
        if (authCfg.getProvider("userProvider") == null || authCfg.getProvider((String)"userProvider").className == null) {
            throw new ServletException("No se ha configurado el provider de autorizacion. Revisa el fichero de configuracion de la aplicacion " + appCode);
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        R01FBaseAuthProvider authProvider = null;
        R01FAuthCtx authCtx = null;
        R01FTargetCtx targetCtx = null;
        R01FLog.to("r01f.auth").info(authCfg.override ? ">>>>> R01FAuthServletFilter.doFilter --> NO se comprueba la autorizacion!!!!!\n\tParametro override=true" : ">>>>> R01FAuthServletFilter.doFilter --> Comprobando autorizacion...");
        String uri = R01FAuthFilterUtils.getURI(request);
        R01FLog.to("r01f.auth").info(">>>>> R01FAuthServletFilter.doFilter --> URI: " + uri);
        R01FTargetCfg targetCfg = R01FAuthFilterUtils.getResourceThatFirstMatches(authCfg, uri);
        R01FLog.to("r01f.auth").info(">>>>> R01FAuthServletFilter.doFilter --> Configuracion establecida para la URI: " + targetCfg.getURIPattern() + " : " + targetCfg.getKind());
        if (targetCfg == null) {
            throw new ServletException("El filtro de seguridad R01FAuthServletFilter NO ha verificado ning\u00fan patron para la uri '" + uri + "'.\n" + "Revisa la seccion <authCfg> del fichero " + appCode + ".properties.xml");
        }
        if (!authCfg.override && targetCfg.kind == R01FTargetCfg.RESTRICT_KIND) {
            R01FLog.to("r01f.auth").info(">>>>> R01FAuthServletFilter.doFilter --> ==== La url " + uri + " tiene el acceso protegido: authCfg.override=" + authCfg.override + " targetCfg.kind=" + targetCfg.kind + " ...comprobaci\u00f3n de la autenticaci\u00f3n:");
            if (authCfg.useSession) {
                R01FLog.to("r01f.auth").info("==== Comprobando si existe el contexto de seguridad en la sesi\u00f3n http");
                ses = req.getSession(false);
                if (ses != null) {
                    authCtx = (R01FAuthCtx)ses.getAttribute("R01FAuthCtx");
                    R01FLog.to("r01f.auth").info("\t\t>>>>> R01FAuthServletFilter.doFilter --> --->Contexto de seguridad obtenido de la sesi\u00f3n web!");
                } else {
                    R01FLog.to("r01f.auth").info("\t\t>>>>> R01FAuthServletFilter.doFilter --> --->NO existe el contexto de seguridad en la sesi\u00f3n web!");
                }
            } else {
                R01FLog.to("r01f.auth").info(">>>>> R01FAuthServletFilter.doFilter --> ==== La informacion de autorizacion NO se guarda en session http");
                authCtx = null;
            }
            if (authCtx == null) {
                if (authProvider == null) {
                    try {
                        authProvider = R01FAuthFilterUtils.obtainAuthProviderInstance(authCfg, (ServletRequest)req, "userProvider");
                    }
                    catch (ReflectionException refEx) {
                        throw new ServletException((Throwable)refEx);
                    }
                }
                R01FLog.to("r01f.auth").info(">>>>> R01FAuthServletFilter.doFilter --> No hay contexto de autorizacion:\n\t1.- Es la primera vez\n\t2.- No hay autenticacion");
                authCtx = authProvider.getContext(authCfg);
                System.out.println("******************* 1. Obtener contexto de autorizacion del provider. " + new Date() + " R01FBaseAuthProvider:" + authProvider + " R01FAuthCtx:" + authCtx + " Path:" + req.getContextPath() + "\n. Cookies -->> " + req.getHeader("Cookie") + "\n *******************");
                if (authCtx == null) {
                    R01FLog.to("r01f.auth").info(">>>>> R01FAuthServletFilter.doFilter --> ==== El usuario NO se ha autenticado, redirigir a la pagina de login");
                    String loginPage = authCfg.getProvider((String)"userProvider").loginPage;
                    if (loginPage == null || loginPage.length() == 0) {
                        loginPage = XMLProperties.getProperty("r01ft", "authCfg/provider/loginPage");
                    }
                    if (loginPage == null || loginPage.length() == 0) {
                        loginPage = XMLProperties.getProperty("r01ft", "xlnetsLoginURL");
                    }
                    if (loginPage == null) {
                        R01FLog.to("r01f.auth").warning(">>>>> R01FAuthServletFilter.doFilter --> ATENCI\u00d3N !!! : NO se ha podido encontrar la url de login. El orden de b\u00fasqueda ha sido:\r\n\t-Propiedad authCfg/provider/loginPage de la aplicacion\r\n\t-Propiedad authCfg/provider/loginPage de R01F\r\n\t-Propiedad xlnetsLoginURL de R01F");
                    } else {
                        if (loginPage != null) {
                            loginPage = loginPage + "?N38API=" + req.getRequestURL();
                        }
                        R01FLog.to("r01f.auth").info("...redirecting to login page: " + loginPage);
                        authProvider.redirectToLogin(response, loginPage);
                    }
                    return;
                }
            }
            R01FLog.to("r01f.auth").info(">>>>> R01FAuthServletFilter.doFilter --> ==== El usuario ya est\u00e1 autenticado. Comprobar la autorizaci\u00f3n de acceso para la uri " + uri);
            targetCtx = authCtx.getTargetAuth(targetCfg.uriPattern);
            if (targetCtx == null) {
                if (authProvider == null) {
                    try {
                        authProvider = R01FAuthFilterUtils.obtainAuthProviderInstance(authCfg, (ServletRequest)req, "userProvider");
                    }
                    catch (ReflectionException refEx) {
                        throw new ServletException((Throwable)refEx);
                    }
                }
                R01FLog.to("r01f.auth").info("\t\t>>>>> R01FAuthServletFilter.doFilter --> ...autenticando al usuario utilizando el provider " + authCfg.getProvider("userProvider").getClassName());
                targetCtx = authProvider.authorize(authCtx, targetCfg);
                if (targetCtx == null || targetCtx.authorizedResources == null || targetCtx.authorizedResources.size() == 0) {
                    R01FLog.to("r01f.auth").warning(">>>>> R01FAuthServletFilter.doFilter --> NO se ha podido cargar la info de autorizacion del recurso:\n1.- No hay acceso\n2.- El provider de autorizacion no ha funcionado");
                    res.sendError(403, "El filtro de seguridad R01F NO ha permitido el acceso al recurso!");
                    return;
                }
                R01FLog.to("r01f.auth").info(">>>>> R01FAuthServletFilter.doFilter --> ==== Introducir la informacion de autorizacion para el patr\u00f3n de url " + targetCtx.targetCfg.uriPattern + " en el contexto de autorizacion global en sesion");
                if (authCtx.authorizedTargets == null) {
                    authCtx.authorizedTargets = new LinkedHashMap<String, R01FTargetCtx>();
                }
                authCtx.authorizedTargets.put(targetCtx.targetCfg.uriPattern, targetCtx);
            }
            R01FLog.to("r01f.auth").info(">>>>> R01FAuthServletFilter.doFilter --> ==== Autorizado!!!!");
        } else {
            R01FLog.to("r01f.auth").info(">>>>> R01FAuthServletFilter.doFilter --> ==== NO se ha comprobado la seguridad: authCfg.override=" + authCfg.override + " targetCfg.kind=" + targetCfg.kind + "\r\n" + "\tEl atributo override=true o bien para el target que machea " + uri + " se ha configurado kind=" + R01FTargetCfg.ALLOW_KIND_STR);
            authCtx = new R01FAuthCtx(true, new R01FUserCtx(), null, new Date(), null);
        }
        if (authCfg.useSession) {
            ses = req.getSession(true);
            ses.setAttribute("R01FAuthCtx", (Object)authCtx);
        }
        req.setAttribute("R01FAuthCtx", (Object)authCtx);
        chain.doFilter(request, response);
        R01FLog.to("r01f.auth").info(">>>>>>>>>> Fin: Filtro de Autorizacion >>>>>>>>>>>>>>>>>>>>>>\n\n\n\n");
    }

    public void destroy() {
        this._config = null;
    }

    public FilterConfig getFilterConfig() {
        return this._config;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this._config = filterConfig;
    }

    public static void main(String[] args) {
        try {
            R01FAuthCfg authCfg = new R01FAuthCfg();
            authCfg.loadConfig("r01lt");
            R01FLog.to("r01f.auth").info("" + authCfg);
        }
        catch (Exception ex) {
            R01FLog.to("r01f.auth").severe("EXCEPTION!!!!: " + ex.toString());
        }
    }
}

