/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.servlet.filter.authorization;

import com.ejie.r01f.servlet.filter.authorization.R01FProfileCtx;
import com.ejie.r01f.servlet.filter.authorization.R01FTargetCtx;
import com.ejie.r01f.servlet.filter.authorization.R01FUserCtx;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class R01FAuthCtx
implements Serializable {
    private static final long serialVersionUID = 5697699783433808308L;
    public boolean override = false;
    public R01FUserCtx user = null;
    public Map<String, String> attributes = null;
    public Date loginDate = new Date();
    public Map<String, R01FProfileCtx> profiles = null;
    public Map<String, R01FTargetCtx> authorizedTargets = null;

    R01FAuthCtx() {
    }

    public R01FAuthCtx(boolean theOverride, R01FUserCtx theUser, Map<String, String> authAttrs, Date theLoginDate, Map<String, R01FProfileCtx> theProfiles) {
        this.override = theOverride;
        this.user = theUser;
        this.attributes = authAttrs;
        this.loginDate = theLoginDate;
        this.profiles = theProfiles;
    }

    public boolean isOverridingAuthorization() {
        return this.override;
    }

    public R01FUserCtx getUser() {
        return this.user;
    }

    public Date getLoginDate() {
        return this.loginDate;
    }

    public Iterator<R01FProfileCtx> getProfilesIterator() {
        if (this.profiles == null) {
            return null;
        }
        return this.profiles.values().iterator();
    }

    public R01FProfileCtx getProfile(String profileOID) {
        if (this.profiles == null || profileOID == null) {
            return null;
        }
        return this.profiles.get(profileOID);
    }

    public R01FTargetCtx getTargetAuth(String uriPattern) {
        if (this.authorizedTargets == null) {
            return null;
        }
        return this.authorizedTargets.get(uriPattern);
    }

    public String getAttribute(String attrName) {
        if (attrName == null) {
            return null;
        }
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(attrName);
    }

    public boolean hasProfile(String profileOID) {
        if (profileOID == null || this.profiles == null) {
            return false;
        }
        return this.profiles.containsKey(profileOID);
    }

    public boolean isValid() {
        if (this.user == null || !this.user.isValid()) {
            return false;
        }
        if (this.profiles == null || this.profiles.size() == 0) {
            return false;
        }
        for (R01FProfileCtx currProfile : this.profiles.values()) {
            if (currProfile.isValid()) continue;
            return false;
        }
        if (this.authorizedTargets == null || this.authorizedTargets.size() == 0) {
            return false;
        }
        for (R01FTargetCtx currRes : this.authorizedTargets.values()) {
            if (currRes.isValid()) continue;
            return false;
        }
        return true;
    }

    public String toXML() throws XOMarshallerException {
        String map = XMLProperties.get("r01ft", "authMapPath", "/html/datos/r01fAuthMapping.xml");
        if (map != null) {
            return XOManager.getXML(XMLProperties.get("r01ft", "authMapPath"), (Object)this);
        }
        return "";
    }
}

