/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.servlet.filter.authorization;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.servlet.filter.authorization.R01FTargetCfg;
import com.ejie.r01f.util.StringBilingue;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class R01FAuthCfg
implements Serializable {
    private static final long serialVersionUID = -4853237050490550353L;
    String appCode = "r01ft";
    boolean override = false;
    boolean useSession = true;
    Map providers = null;
    Map targets = null;

    public String toString() {
        Iterator it;
        StringBuffer sb = new StringBuffer(77);
        sb.append("**> Configuracion de seguridad de la aplicacion '");
        sb.append(this.appCode);
        sb.append("'; useSession=");
        sb.append(this.useSession);
        sb.append(" override=");
        sb.append(this.override);
        sb.append("\r\n");
        if (this.providers != null) {
            it = this.providers.values().iterator();
            while (it.hasNext()) {
                sb.append(((Provider)it.next()).toString());
            }
        }
        if (this.targets != null) {
            it = this.targets.values().iterator();
            while (it.hasNext()) {
                sb.append(((R01FTargetCfg)it.next()).toString());
            }
        }
        return sb.toString();
    }

    public void loadConfig(String theAppCode) {
        R01FLog.to("r01f.auth").info(">>>>> R01FAuthCfg.loadConfig --> Cargando la informacion de autorizacion del fichero '" + theAppCode + ".properties.xml'");
        Node appAuthDefNode = XMLProperties.getPropertyNode(theAppCode, "/authCfg");
        R01FLog.to("r01f.auth").info(">>>>> R01FAuthCfg.loadConfig --> Par\u00e1metros de seguridad cargados: " + appAuthDefNode);
        if (appAuthDefNode == null) {
            R01FLog.to("r01f.auth").severe("NO se puede cargar la informaci\u00f3n de seguridad de la aplicaci\u00f3n " + this.appCode + " ya que no existe la configuraci\u00f3n en el fichero " + this.appCode + ".properties.xml");
            return;
        }
        this.appCode = theAppCode;
        NamedNodeMap attrs = appAuthDefNode.getAttributes();
        Node currAttrNode = null;
        String currAttrValue = null;
        if (attrs != null && (currAttrNode = attrs.getNamedItem("override")) != null) {
            R01FLog.to("r01f.auth").info(">>>>> R01FAuthCfg.loadConfig --> Hay atributos(override). Se cargan.");
            currAttrValue = currAttrNode.getNodeValue().trim();
            R01FLog.to("r01f.auth").info(">>>>> R01FAuthCfg.loadConfig --> Recogido: " + currAttrNode.getNodeName() + " : " + currAttrValue);
            if (currAttrValue.length() > 0) {
                if ("true".equals(currAttrValue)) {
                    this.override = true;
                } else if ("false".equals(currAttrValue)) {
                    this.override = false;
                }
            }
        }
        if (attrs != null && (currAttrNode = attrs.getNamedItem("useSession")) != null) {
            R01FLog.to("r01f.auth").info(">>>>> R01FAuthCfg.loadConfig --> Hay atributos(useSession). Se cargan.");
            currAttrValue = currAttrNode.getNodeValue().trim();
            R01FLog.to("r01f.auth").info(">>>>> R01FAuthCfg.loadConfig --> Recogido: " + currAttrNode.getNodeName() + " : " + currAttrValue);
            if ("true".equals(currAttrValue)) {
                this.useSession = true;
            } else if ("false".equals(currAttrValue)) {
                this.useSession = false;
            }
        }
        R01FLog.to("r01f.auth").info(">>>>> R01FAuthCfg.loadConfig --> ** Cargando configuracion de seguridad de la aplicacion '" + theAppCode + "': override='" + this.override);
        NodeList rl = appAuthDefNode.getChildNodes();
        if (rl != null) {
            Node node = null;
            for (int i = 0; i < rl.getLength(); ++i) {
                int j;
                Node currNode;
                NodeList nl;
                node = rl.item(i);
                if (node.getNodeName().equals("provider")) {
                    Provider currProvider = new Provider();
                    currProvider.idProvider = node.getAttributes() != null && (currAttrNode = node.getAttributes().getNamedItem("id")) != null ? node.getAttributes().getNamedItem("id").getNodeValue() : "userProvider";
                    nl = node.getChildNodes();
                    if (nl != null) {
                        currNode = null;
                        for (j = 0; j < nl.getLength(); ++j) {
                            currNode = nl.item(j);
                            if (currNode.getNodeName().equals("className") && currNode.getFirstChild() != null) {
                                currProvider.className = currNode.getFirstChild().getNodeValue();
                                continue;
                            }
                            if (currNode.getNodeName().equals("initParam") && currNode.getAttributes() != null && currNode.getAttributes().getNamedItem("name") != null && currNode.getFirstChild() != null) {
                                if (currProvider.initParams == null) {
                                    currProvider.initParams = new Properties();
                                }
                                currProvider.initParams.setProperty(currNode.getAttributes().getNamedItem("name").getNodeValue(), currNode.getFirstChild().getNodeValue());
                                continue;
                            }
                            if (!currNode.getNodeName().equals("loginPage") || currNode.getFirstChild() == null) continue;
                            currProvider.loginPage = currNode.getFirstChild().getNodeValue();
                        }
                    }
                    R01FLog.to("r01f.auth").info(">>>>> R01FAuthCfg.loadConfig --> Provider: " + currProvider.getIdProvider() + " : " + currProvider.getClassName());
                    this.addNewProvider(currProvider);
                }
                if (!node.getNodeName().equals("target")) continue;
                R01FLog.to("r01f.auth").info(">>>>> R01FAuthCfg.loadConfig --> * Nueva configuracion de seguridad para un target");
                R01FTargetCfg currTargetCfg = new R01FTargetCfg();
                attrs = node.getAttributes();
                if (attrs != null && (currAttrNode = attrs.getNamedItem("kind")) != null) {
                    String kindStr = currAttrNode.getNodeValue();
                    R01FLog.to("r01f.auth").info(">>>>> R01FAuthCfg.loadConfig --> \r\nn$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ kind=" + kindStr + "\r\n");
                    if (kindStr != null && (kindStr.equalsIgnoreCase(R01FTargetCfg.ALLOW_KIND_STR) || kindStr.equalsIgnoreCase(R01FTargetCfg.RESTRICT_KIND_STR))) {
                        if (kindStr.equalsIgnoreCase(R01FTargetCfg.ALLOW_KIND_STR)) {
                            currTargetCfg.kind = R01FTargetCfg.ALLOW_KIND;
                        } else if (kindStr.equalsIgnoreCase(R01FTargetCfg.RESTRICT_KIND_STR)) {
                            currTargetCfg.kind = R01FTargetCfg.RESTRICT_KIND;
                        }
                    } else {
                        R01FLog.to("r01f.auth").severe(">>>>> R01FAuthCfg.loadConfig --> El valor '" + kindStr + "' del atributo kind de la configuraci\u00f3n del target de acceso NO es valido.\r\n" + "Los \u00fanicos valores v\u00e1lidos son " + R01FTargetCfg.RESTRICT_KIND_STR + " y " + R01FTargetCfg.ALLOW_KIND_STR);
                    }
                }
                nl = node.getChildNodes();
                R01FLog.to("r01f.auth").info(">>>>> R01FAuthCfg.loadConfig --> N\u00ba nodos: " + nl.getLength());
                if (nl != null) {
                    currNode = null;
                    for (j = 0; j < nl.getLength(); ++j) {
                        NodeList il;
                        currNode = nl.item(j);
                        if (currNode.getNodeName().equals("uri")) {
                            currTargetCfg.uriPattern = currNode.getFirstChild().getNodeValue();
                            continue;
                        }
                        if (!currNode.getNodeName().equals("resources") || (il = currNode.getChildNodes()) == null) continue;
                        Node currResNode = null;
                        NamedNodeMap currResAttrs = null;
                        NodeList bl = null;
                        String itemOID = null;
                        String itemMandatory = "false";
                        String itemType = null;
                        StringBilingue itemName = null;
                        for (int k = 0; k < il.getLength(); ++k) {
                            currResNode = il.item(k);
                            currResAttrs = currResNode.getAttributes();
                            bl = currResNode.getChildNodes();
                            if (!currResNode.getNodeName().equals("resource") || bl == null || bl.getLength() <= 0 || currResAttrs == null || currResAttrs.getNamedItem("oid") == null || currResAttrs.getNamedItem("type") == null) continue;
                            itemOID = currResAttrs.getNamedItem("oid").getNodeValue();
                            itemType = currResAttrs.getNamedItem("type").getNodeValue();
                            itemMandatory = currResAttrs.getNamedItem("mandatory") == null ? "false" : currResAttrs.getNamedItem("mandatory").getNodeValue();
                            itemName = new StringBilingue("auth-unknown", "auth-unknown");
                            for (int c = 0; c < bl.getLength(); ++c) {
                                if (bl.item(c).getNodeName().equals("es") && bl.item(c).getFirstChild() != null) {
                                    itemName.setEs(bl.item(c).getFirstChild().getNodeValue().trim());
                                }
                                if (!bl.item(c).getNodeName().equals("eu") || bl.item(c).getFirstChild() == null) continue;
                                itemName.setEu(bl.item(c).getFirstChild().getNodeValue().trim());
                            }
                            if (itemType == null || itemName == null) continue;
                            if (currTargetCfg.resources == null) {
                                currTargetCfg.resources = new LinkedHashMap();
                            }
                            R01FTargetCfg r01FTargetCfg = currTargetCfg;
                            r01FTargetCfg.getClass();
                            R01FTargetCfg.ResourceCfg resCfg = new R01FTargetCfg.ResourceCfg(r01FTargetCfg, itemOID.trim(), itemType.trim(), itemMandatory.equals("true"), itemName);
                            currTargetCfg.resources.put(resCfg.getOID(), resCfg);
                        }
                    }
                }
                if (this.targets == null) {
                    this.targets = new LinkedHashMap();
                }
                this.targets.put(currTargetCfg.uriPattern, currTargetCfg);
                R01FLog.to("r01f.auth").info(">>>>> R01FAuthCfg.loadConfig --> Target: " + currTargetCfg.getURIPattern() + " : " + currTargetCfg.getKind());
            }
        }
        R01FLog.to("r01f.auth").info(">>>>> R01FAuthCfg.loadConfig --> ** Fin de la carga de configuracion de seguridad");
    }

    public String getAppCode() {
        return this.appCode;
    }

    public void setAppCode(String theAppCode) {
        this.appCode = theAppCode;
    }

    public boolean isOverride() {
        return this.override;
    }

    public void setOverride(boolean theOverride) {
        this.override = theOverride;
    }

    public Provider getProvider(String providerId) {
        return (Provider)this.providers.get(providerId);
    }

    public void addNewProvider(Provider theProvider) {
        if (this.providers == null) {
            LinkedHashMap<String, Provider> newProviders = new LinkedHashMap<String, Provider>();
            newProviders.put(theProvider.getIdProvider(), theProvider);
            this.providers = newProviders;
        } else {
            this.providers.put(theProvider.getIdProvider(), theProvider);
        }
    }

    public Map getTargets() {
        return this.targets;
    }

    public void setTargets(Map theTargets) {
        this.targets = theTargets;
    }

    public boolean isUseSession() {
        return this.useSession;
    }

    public void setUseSession(boolean theUseSession) {
        this.useSession = theUseSession;
    }

    public class Provider {
        String className = null;
        String loginPage = null;
        Properties initParams = null;
        String idProvider = null;

        public String getClassName() {
            return this.className;
        }

        public String getLoginPage() {
            return this.loginPage;
        }

        public Properties getInitParams() {
            return this.initParams;
        }

        public String getIdProvider() {
            return this.idProvider;
        }

        public String getInitParameter(String paramName) {
            if (this.initParams == null) {
                return null;
            }
            return (String)this.initParams.get(paramName);
        }

        public void setInitParams(Properties theInitParams) {
            this.initParams = theInitParams;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(63);
            sb.append("\tProvider:\r\n\t\tidProvider=");
            sb.append(this.idProvider);
            sb.append("\r\n\t\tclass=");
            sb.append(this.className);
            sb.append("\r\n\t\tLoginPage: ");
            sb.append(this.loginPage != null ? this.loginPage : "not configured...it's asumed the r01f login page");
            if (this.initParams != null) {
                sb.append("\t\tInitParams:\r\n");
                Map.Entry<Object, Object> me2 = null;
                for (Map.Entry<Object, Object> me2 : this.initParams.entrySet()) {
                    sb.append("\t\t\t");
                    sb.append((String)me2.getKey());
                    sb.append('=');
                    sb.append((String)me2.getValue());
                }
            }
            return sb.toString();
        }
    }
}

